"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from mollie_api_python_alpha import utils
from mollie_api_python_alpha.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from mollie_api_python_alpha.utils import (
    FieldMetadata,
    PathParamMetadata,
    RequestMetadata,
)
import pydantic
from pydantic import model_serializer
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class UpdateCustomerRequestBodyTypedDict(TypedDict):
    name: NotRequired[Nullable[str]]
    email: NotRequired[Nullable[str]]
    locale: NotRequired[Nullable[str]]
    metadata: NotRequired[Nullable[str]]


class UpdateCustomerRequestBody(BaseModel):
    name: OptionalNullable[str] = UNSET

    email: OptionalNullable[str] = UNSET

    locale: OptionalNullable[str] = UNSET

    metadata: OptionalNullable[str] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["name", "email", "locale", "metadata"]
        nullable_fields = ["name", "email", "locale", "metadata"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class UpdateCustomerRequestTypedDict(TypedDict):
    id: str
    r"""Provide the ID of the item you want to perform this operation on."""
    request_body: NotRequired[UpdateCustomerRequestBodyTypedDict]


class UpdateCustomerRequest(BaseModel):
    id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""Provide the ID of the item you want to perform this operation on."""

    request_body: Annotated[
        Optional[UpdateCustomerRequestBody],
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ] = None


class UpdateCustomerDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: NotRequired[str]
    type: NotRequired[str]


class UpdateCustomerDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: Optional[str] = "https://docs.mollie.com/errors"

    type: Optional[str] = "text/html"


class UpdateCustomerLinksTypedDict(TypedDict):
    documentation: NotRequired[UpdateCustomerDocumentationTypedDict]
    r"""The URL to the generic Mollie API error handling guide."""


class UpdateCustomerLinks(BaseModel):
    documentation: Optional[UpdateCustomerDocumentation] = None
    r"""The URL to the generic Mollie API error handling guide."""


class UpdateCustomerResponseBodyData(BaseModel):
    status: Optional[int] = None
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: Optional[str] = None
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: Optional[str] = None
    r"""A detailed human-readable description of the error that occurred."""

    field: OptionalNullable[str] = UNSET
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name of the field that caused the issue."""

    links: Annotated[Optional[UpdateCustomerLinks], pydantic.Field(alias="_links")] = (
        None
    )


class UpdateCustomerResponseBody(Exception):
    r"""An error response object."""

    data: UpdateCustomerResponseBodyData

    def __init__(self, data: UpdateCustomerResponseBodyData):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(self.data, UpdateCustomerResponseBodyData)
