"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from mollie_api_python_alpha import utils
from mollie_api_python_alpha.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from mollie_api_python_alpha.utils import (
    FieldMetadata,
    PathParamMetadata,
    RequestMetadata,
)
import pydantic
from pydantic import model_serializer
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class UpdateOrderBillingAddressTypedDict(TypedDict):
    r"""If a payment method has already been selected, the original shipping address may have already been forwarded to the payment method provider."""


class UpdateOrderBillingAddress(BaseModel):
    r"""If a payment method has already been selected, the original shipping address may have already been forwarded to the payment method provider."""


class UpdateOrderShippingAddressTypedDict(TypedDict):
    r"""If a payment method has already been selected, the original billing address may have already been forwarded to the payment method provider."""


class UpdateOrderShippingAddress(BaseModel):
    r"""If a payment method has already been selected, the original billing address may have already been forwarded to the payment method provider."""


class UpdateOrderRequestBodyTypedDict(TypedDict):
    order_number: NotRequired[Nullable[str]]
    redirect_url: NotRequired[Nullable[str]]
    r"""Can be updated while the order is not yet finalized."""
    cancel_url: NotRequired[Nullable[str]]
    r"""Can be updated while the order is not yet finalized."""
    webhook_url: NotRequired[Nullable[str]]
    billing_address: NotRequired[Nullable[UpdateOrderBillingAddressTypedDict]]
    r"""If a payment method has already been selected, the original shipping address may have already been forwarded to the payment method provider."""
    shipping_address: NotRequired[Nullable[UpdateOrderShippingAddressTypedDict]]
    r"""If a payment method has already been selected, the original billing address may have already been forwarded to the payment method provider."""
    testmode: NotRequired[Nullable[bool]]
    r"""Most API credentials are specifically created for either live mode or test mode. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting `testmode` to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """


class UpdateOrderRequestBody(BaseModel):
    order_number: Annotated[
        OptionalNullable[str], pydantic.Field(alias="orderNumber")
    ] = UNSET

    redirect_url: Annotated[
        OptionalNullable[str], pydantic.Field(alias="redirectUrl")
    ] = UNSET
    r"""Can be updated while the order is not yet finalized."""

    cancel_url: Annotated[OptionalNullable[str], pydantic.Field(alias="cancelUrl")] = (
        UNSET
    )
    r"""Can be updated while the order is not yet finalized."""

    webhook_url: Annotated[
        OptionalNullable[str], pydantic.Field(alias="webhookUrl")
    ] = UNSET

    billing_address: Annotated[
        OptionalNullable[UpdateOrderBillingAddress],
        pydantic.Field(alias="billingAddress"),
    ] = UNSET
    r"""If a payment method has already been selected, the original shipping address may have already been forwarded to the payment method provider."""

    shipping_address: Annotated[
        OptionalNullable[UpdateOrderShippingAddress],
        pydantic.Field(alias="shippingAddress"),
    ] = UNSET
    r"""If a payment method has already been selected, the original billing address may have already been forwarded to the payment method provider."""

    testmode: OptionalNullable[bool] = False
    r"""Most API credentials are specifically created for either live mode or test mode. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting `testmode` to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "orderNumber",
            "redirectUrl",
            "cancelUrl",
            "webhookUrl",
            "billingAddress",
            "shippingAddress",
            "testmode",
        ]
        nullable_fields = [
            "orderNumber",
            "redirectUrl",
            "cancelUrl",
            "webhookUrl",
            "billingAddress",
            "shippingAddress",
            "testmode",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class UpdateOrderRequestTypedDict(TypedDict):
    id: str
    r"""Provide the ID of the item you want to perform this operation on."""
    request_body: NotRequired[UpdateOrderRequestBodyTypedDict]


class UpdateOrderRequest(BaseModel):
    id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""Provide the ID of the item you want to perform this operation on."""

    request_body: Annotated[
        Optional[UpdateOrderRequestBody],
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ] = None


class UpdateOrderOrdersDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: NotRequired[str]
    type: NotRequired[str]


class UpdateOrderOrdersDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: Optional[str] = "https://docs.mollie.com/errors"

    type: Optional[str] = "text/html"


class UpdateOrderOrdersLinksTypedDict(TypedDict):
    documentation: NotRequired[UpdateOrderOrdersDocumentationTypedDict]
    r"""The URL to the generic Mollie API error handling guide."""


class UpdateOrderOrdersLinks(BaseModel):
    documentation: Optional[UpdateOrderOrdersDocumentation] = None
    r"""The URL to the generic Mollie API error handling guide."""


class UpdateOrderOrdersResponseBodyData(BaseModel):
    status: Optional[int] = None
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: Optional[str] = None
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: Optional[str] = None
    r"""A detailed human-readable description of the error that occurred."""

    field: OptionalNullable[str] = UNSET
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name of the field that caused the issue."""

    links: Annotated[
        Optional[UpdateOrderOrdersLinks], pydantic.Field(alias="_links")
    ] = None


class UpdateOrderOrdersResponseBody(Exception):
    r"""An error response object."""

    data: UpdateOrderOrdersResponseBodyData

    def __init__(self, data: UpdateOrderOrdersResponseBodyData):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(self.data, UpdateOrderOrdersResponseBodyData)


class UpdateOrderDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: NotRequired[str]
    type: NotRequired[str]


class UpdateOrderDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: Optional[str] = "https://docs.mollie.com/errors"

    type: Optional[str] = "text/html"


class UpdateOrderLinksTypedDict(TypedDict):
    documentation: NotRequired[UpdateOrderDocumentationTypedDict]
    r"""The URL to the generic Mollie API error handling guide."""


class UpdateOrderLinks(BaseModel):
    documentation: Optional[UpdateOrderDocumentation] = None
    r"""The URL to the generic Mollie API error handling guide."""


class UpdateOrderResponseBodyData(BaseModel):
    status: Optional[int] = None
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: Optional[str] = None
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: Optional[str] = None
    r"""A detailed human-readable description of the error that occurred."""

    field: OptionalNullable[str] = UNSET
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name of the field that caused the issue."""

    links: Annotated[Optional[UpdateOrderLinks], pydantic.Field(alias="_links")] = None


class UpdateOrderResponseBody(Exception):
    r"""An error response object."""

    data: UpdateOrderResponseBodyData

    def __init__(self, data: UpdateOrderResponseBodyData):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(self.data, UpdateOrderResponseBodyData)
