"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

# pyright: reportReturnType = false
import asyncio
from typing_extensions import Protocol, runtime_checkable
import httpx
from typing import Any, Optional, Union


@runtime_checkable
class HttpClient(Protocol):
    def send(
        self,
        request: httpx.Request,
        *,
        stream: bool = False,
        auth: Union[
            httpx._types.AuthTypes, httpx._client.UseClientDefault, None
        ] = httpx.USE_CLIENT_DEFAULT,
        follow_redirects: Union[
            bool, httpx._client.UseClientDefault
        ] = httpx.USE_CLIENT_DEFAULT,
    ) -> httpx.Response:
        pass

    def build_request(
        self,
        method: str,
        url: httpx._types.URLTypes,
        *,
        content: Optional[httpx._types.RequestContent] = None,
        data: Optional[httpx._types.RequestData] = None,
        files: Optional[httpx._types.RequestFiles] = None,
        json: Optional[Any] = None,
        params: Optional[httpx._types.QueryParamTypes] = None,
        headers: Optional[httpx._types.HeaderTypes] = None,
        cookies: Optional[httpx._types.CookieTypes] = None,
        timeout: Union[
            httpx._types.TimeoutTypes, httpx._client.UseClientDefault
        ] = httpx.USE_CLIENT_DEFAULT,
        extensions: Optional[httpx._types.RequestExtensions] = None,
    ) -> httpx.Request:
        pass

    def close(self) -> None:
        pass


@runtime_checkable
class AsyncHttpClient(Protocol):
    async def send(
        self,
        request: httpx.Request,
        *,
        stream: bool = False,
        auth: Union[
            httpx._types.AuthTypes, httpx._client.UseClientDefault, None
        ] = httpx.USE_CLIENT_DEFAULT,
        follow_redirects: Union[
            bool, httpx._client.UseClientDefault
        ] = httpx.USE_CLIENT_DEFAULT,
    ) -> httpx.Response:
        pass

    def build_request(
        self,
        method: str,
        url: httpx._types.URLTypes,
        *,
        content: Optional[httpx._types.RequestContent] = None,
        data: Optional[httpx._types.RequestData] = None,
        files: Optional[httpx._types.RequestFiles] = None,
        json: Optional[Any] = None,
        params: Optional[httpx._types.QueryParamTypes] = None,
        headers: Optional[httpx._types.HeaderTypes] = None,
        cookies: Optional[httpx._types.CookieTypes] = None,
        timeout: Union[
            httpx._types.TimeoutTypes, httpx._client.UseClientDefault
        ] = httpx.USE_CLIENT_DEFAULT,
        extensions: Optional[httpx._types.RequestExtensions] = None,
    ) -> httpx.Request:
        pass

    async def aclose(self) -> None:
        pass


class ClientOwner(Protocol):
    client: Union[HttpClient, None]
    async_client: Union[AsyncHttpClient, None]


def close_clients(
    owner: ClientOwner,
    sync_client: Union[HttpClient, None],
    sync_client_supplied: bool,
    async_client: Union[AsyncHttpClient, None],
    async_client_supplied: bool,
) -> None:
    """
    A finalizer function that is meant to be used with weakref.finalize to close
    httpx clients used by an SDK so that underlying resources can be garbage
    collected.
    """

    # Unset the client/async_client properties so there are no more references
    # to them from the owning SDK instance and they can be reaped.
    owner.client = None
    owner.async_client = None

    if sync_client is not None and not sync_client_supplied:
        try:
            sync_client.close()
        except Exception:
            pass

    if async_client is not None and not async_client_supplied:
        # First, try the simplest approach - use asyncio.run()
        # This works when we're not in an async context
        try:
            asyncio.run(async_client.aclose())
        except RuntimeError as e:
            # If we get "RuntimeError: This event loop is already running",
            # it means we're in an async context
            if "already running" in str(e):
                try:
                    # We're in an async context, so get the running loop
                    loop = asyncio.get_running_loop()
                    # Create a task but don't wait for it
                    loop.create_task(async_client.aclose())
                except Exception:
                    # If we can't get the loop or create a task, just ignore
                    # The GC will eventually clean up the resources
                    pass
            # If we get "RuntimeError: There is no current event loop in thread",
            # we're not in an async context, but asyncio.run() failed for some reason
            # In this case, we can try to create a new event loop explicitly
            elif "no current event loop" in str(e):
                try:
                    # Create a new event loop and run the coroutine
                    loop = asyncio.new_event_loop()
                    asyncio.set_event_loop(loop)
                    try:
                        loop.run_until_complete(async_client.aclose())
                    finally:
                        loop.close()
                        asyncio.set_event_loop(None)
                except Exception:
                    # If this also fails, just ignore
                    pass
            # For any other RuntimeError, just ignore
            else:
                pass
        except Exception:
            # For any other exception, just ignore
            pass
