"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
from mollie import utils
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import FieldMetadata, PathParamMetadata, QueryParamMetadata
import pydantic
from pydantic import model_serializer
from typing import List, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


class GetCustomerQueryParamInclude(str, Enum):
    r"""This endpoint allows you to include additional information via the `include` query string parameter."""

    EVENTS = "events"


class GetCustomerRequestTypedDict(TypedDict):
    customer_id: str
    r"""Provide the ID of the related customer."""
    include: NotRequired[Nullable[GetCustomerQueryParamInclude]]
    r"""This endpoint allows you to include additional information via the `include` query string parameter."""
    testmode: NotRequired[Nullable[bool]]
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """


class GetCustomerRequest(BaseModel):
    customer_id: Annotated[
        str,
        pydantic.Field(alias="customerId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""Provide the ID of the related customer."""

    include: Annotated[
        OptionalNullable[GetCustomerQueryParamInclude],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""This endpoint allows you to include additional information via the `include` query string parameter."""

    testmode: Annotated[
        OptionalNullable[bool],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["include", "testmode"]
        nullable_fields = ["include", "testmode"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetCustomerCustomersDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: NotRequired[str]
    type: NotRequired[str]


class GetCustomerCustomersDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: Optional[str] = "https://docs.mollie.com/errors"

    type: Optional[str] = "text/html"


class GetCustomerCustomersResponseLinksTypedDict(TypedDict):
    documentation: NotRequired[GetCustomerCustomersDocumentationTypedDict]
    r"""The URL to the generic Mollie API error handling guide."""


class GetCustomerCustomersResponseLinks(BaseModel):
    documentation: Optional[GetCustomerCustomersDocumentation] = None
    r"""The URL to the generic Mollie API error handling guide."""


class GetCustomerCustomersResponseBodyData(BaseModel):
    status: Optional[int] = None
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: Optional[str] = None
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: Optional[str] = None
    r"""A detailed human-readable description of the error that occurred."""

    field: OptionalNullable[str] = UNSET
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name of the field that caused the issue."""

    links: Annotated[
        Optional[GetCustomerCustomersResponseLinks], pydantic.Field(alias="_links")
    ] = None


class GetCustomerCustomersResponseBody(Exception):
    r"""An error response object."""

    data: GetCustomerCustomersResponseBodyData

    def __init__(self, data: GetCustomerCustomersResponseBodyData):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(self.data, GetCustomerCustomersResponseBodyData)


class GetCustomerMetadata2TypedDict(TypedDict):
    pass


class GetCustomerMetadata2(BaseModel):
    pass


GetCustomerMetadataTypedDict = TypeAliasType(
    "GetCustomerMetadataTypedDict", Union[GetCustomerMetadata2TypedDict, str, List[str]]
)
r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB."""


GetCustomerMetadata = TypeAliasType(
    "GetCustomerMetadata", Union[GetCustomerMetadata2, str, List[str]]
)
r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB."""


class GetCustomerSelfTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class GetCustomerSelf(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class GetCustomerDashboardTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class GetCustomerDashboard(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class GetCustomerPaymentsTypedDict(TypedDict):
    r"""The API resource URL of the [payments](list-payments) linked to this customer. Omitted if no such payments exist (yet)."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class GetCustomerPayments(BaseModel):
    r"""The API resource URL of the [payments](list-payments) linked to this customer. Omitted if no such payments exist (yet)."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class GetCustomerMandatesTypedDict(TypedDict):
    r"""The API resource URL of the [mandates](list-mandates) linked to this customer. Omitted if no such mandates exist (yet)."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class GetCustomerMandates(BaseModel):
    r"""The API resource URL of the [mandates](list-mandates) linked to this customer. Omitted if no such mandates exist (yet)."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class GetCustomerSubscriptionsTypedDict(TypedDict):
    r"""The API resource URL of the [subscriptions](list-subscriptions) linked to this customer. Omitted if no such subscriptions exist (yet)."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class GetCustomerSubscriptions(BaseModel):
    r"""The API resource URL of the [subscriptions](list-subscriptions) linked to this customer. Omitted if no such subscriptions exist (yet)."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class GetCustomerDocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class GetCustomerDocumentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class GetCustomerLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: NotRequired[GetCustomerSelfTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    dashboard: NotRequired[GetCustomerDashboardTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    payments: NotRequired[Nullable[GetCustomerPaymentsTypedDict]]
    r"""The API resource URL of the [payments](list-payments) linked to this customer. Omitted if no such payments exist (yet)."""
    mandates: NotRequired[Nullable[GetCustomerMandatesTypedDict]]
    r"""The API resource URL of the [mandates](list-mandates) linked to this customer. Omitted if no such mandates exist (yet)."""
    subscriptions: NotRequired[Nullable[GetCustomerSubscriptionsTypedDict]]
    r"""The API resource URL of the [subscriptions](list-subscriptions) linked to this customer. Omitted if no such subscriptions exist (yet)."""
    documentation: NotRequired[GetCustomerDocumentationTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class GetCustomerLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[Optional[GetCustomerSelf], pydantic.Field(alias="self")] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    dashboard: Optional[GetCustomerDashboard] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    payments: OptionalNullable[GetCustomerPayments] = UNSET
    r"""The API resource URL of the [payments](list-payments) linked to this customer. Omitted if no such payments exist (yet)."""

    mandates: OptionalNullable[GetCustomerMandates] = UNSET
    r"""The API resource URL of the [mandates](list-mandates) linked to this customer. Omitted if no such mandates exist (yet)."""

    subscriptions: OptionalNullable[GetCustomerSubscriptions] = UNSET
    r"""The API resource URL of the [subscriptions](list-subscriptions) linked to this customer. Omitted if no such subscriptions exist (yet)."""

    documentation: Optional[GetCustomerDocumentation] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "self",
            "dashboard",
            "payments",
            "mandates",
            "subscriptions",
            "documentation",
        ]
        nullable_fields = ["payments", "mandates", "subscriptions"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class URLTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class URL(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class GetCustomerCustomersLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    url: NotRequired[URLTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class GetCustomerCustomersLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    url: Optional[URL] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class EventsTypedDict(TypedDict):
    resource: NotRequired[str]
    type: NotRequired[int]
    created_at: NotRequired[str]
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""
    message: NotRequired[str]
    links: NotRequired[GetCustomerCustomersLinksTypedDict]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""


class Events(BaseModel):
    resource: Optional[str] = "event"

    type: Optional[int] = None

    created_at: Annotated[Optional[str], pydantic.Field(alias="createdAt")] = None
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""

    message: Optional[str] = None

    links: Annotated[
        Optional[GetCustomerCustomersLinks], pydantic.Field(alias="_links")
    ] = None
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""


class GetCustomerResponseBodyTypedDict(TypedDict):
    r"""The customer object."""

    resource: NotRequired[str]
    r"""Indicates the response contains a customer object. Will always contain the string `customer` for this endpoint."""
    id: NotRequired[str]
    r"""The identifier uniquely referring to this customer. Example: `cst_vsKJpSsabw`."""
    mode: NotRequired[str]
    r"""Whether this entity was created in live mode or in test mode.

    Possible values: `live` `test`
    """
    name: NotRequired[Nullable[str]]
    r"""The full name of the customer."""
    email: NotRequired[Nullable[str]]
    r"""The email address of the customer."""
    locale: NotRequired[Nullable[str]]
    r"""Preconfigure the language to be used in the hosted payment pages shown to the customer. Should only be provided if absolutely necessary. If not provided, the browser language will be used which is typically highly accurate."""
    metadata: NotRequired[Nullable[GetCustomerMetadataTypedDict]]
    r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB."""
    created_at: NotRequired[str]
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""
    links: NotRequired[GetCustomerLinksTypedDict]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""
    events: NotRequired[List[EventsTypedDict]]


class GetCustomerResponseBody(BaseModel):
    r"""The customer object."""

    resource: Optional[str] = "customer"
    r"""Indicates the response contains a customer object. Will always contain the string `customer` for this endpoint."""

    id: Optional[str] = None
    r"""The identifier uniquely referring to this customer. Example: `cst_vsKJpSsabw`."""

    mode: Optional[str] = None
    r"""Whether this entity was created in live mode or in test mode.

    Possible values: `live` `test`
    """

    name: OptionalNullable[str] = UNSET
    r"""The full name of the customer."""

    email: OptionalNullable[str] = UNSET
    r"""The email address of the customer."""

    locale: OptionalNullable[str] = UNSET
    r"""Preconfigure the language to be used in the hosted payment pages shown to the customer. Should only be provided if absolutely necessary. If not provided, the browser language will be used which is typically highly accurate."""

    metadata: OptionalNullable[GetCustomerMetadata] = UNSET
    r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB."""

    created_at: Annotated[Optional[str], pydantic.Field(alias="createdAt")] = None
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""

    links: Annotated[Optional[GetCustomerLinks], pydantic.Field(alias="_links")] = None
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    events: Optional[List[Events]] = None

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "resource",
            "id",
            "mode",
            "name",
            "email",
            "locale",
            "metadata",
            "createdAt",
            "_links",
            "events",
        ]
        nullable_fields = ["name", "email", "locale", "metadata"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
