"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
from mollie import utils
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import FieldMetadata, QueryParamMetadata
import pydantic
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ListAllMethodsQueryParamAmountTypedDict(TypedDict):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class ListAllMethodsQueryParamAmount(BaseModel):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: Annotated[str, FieldMetadata(query=True)]
    r"""A three-character ISO 4217 currency code."""

    value: Annotated[str, FieldMetadata(query=True)]
    r"""A string containing an exact monetary amount in the given currency."""


class ListAllMethodsQueryParamInclude(str, Enum):
    r"""This endpoint allows you to include additional information via the `include` query string parameter."""

    ISSUERS = "issuers"
    PRICING = "pricing"


class ListAllMethodsRequestTypedDict(TypedDict):
    locale: NotRequired[str]
    r"""Passing a locale will sort the payment methods in the preferred order for the country, and translate the payment method names in the corresponding language."""
    amount: NotRequired[ListAllMethodsQueryParamAmountTypedDict]
    r"""If supplied, only payment methods that support the amount and currency are returned.

    Example: `/v2/methods/all?amount[value]=100.00&amount[currency]=USD`
    """
    include: NotRequired[Nullable[ListAllMethodsQueryParamInclude]]
    r"""This endpoint allows you to include additional information via the `include` query string parameter."""
    sequence_type: NotRequired[str]
    r"""Set this parameter to `first` to only return the methods that can be used for the first payment of a recurring sequence.

    Set it to `recurring` to only return methods that can be used for recurring payments or subscriptions.

    Possible values: `oneoff` `first` `recurring` (default: `oneoff`)
    """


class ListAllMethodsRequest(BaseModel):
    locale: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Passing a locale will sort the payment methods in the preferred order for the country, and translate the payment method names in the corresponding language."""

    amount: Annotated[
        Optional[ListAllMethodsQueryParamAmount],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""If supplied, only payment methods that support the amount and currency are returned.

    Example: `/v2/methods/all?amount[value]=100.00&amount[currency]=USD`
    """

    include: Annotated[
        OptionalNullable[ListAllMethodsQueryParamInclude],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""This endpoint allows you to include additional information via the `include` query string parameter."""

    sequence_type: Annotated[
        Optional[str],
        pydantic.Field(alias="sequenceType"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Set this parameter to `first` to only return the methods that can be used for the first payment of a recurring sequence.

    Set it to `recurring` to only return methods that can be used for recurring payments or subscriptions.

    Possible values: `oneoff` `first` `recurring` (default: `oneoff`)
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["locale", "amount", "include", "sequenceType"]
        nullable_fields = ["include"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListAllMethodsMethodsDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str
    type: str


class ListAllMethodsMethodsDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str

    type: str


class ListAllMethodsMethodsLinksTypedDict(TypedDict):
    documentation: ListAllMethodsMethodsDocumentationTypedDict
    r"""The URL to the generic Mollie API error handling guide."""


class ListAllMethodsMethodsLinks(BaseModel):
    documentation: ListAllMethodsMethodsDocumentation
    r"""The URL to the generic Mollie API error handling guide."""


class ListAllMethodsMethodsResponseBodyData(BaseModel):
    status: int
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: str
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: str
    r"""A detailed human-readable description of the error that occurred."""

    field: str
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name of the field that caused the issue."""

    links: Annotated[ListAllMethodsMethodsLinks, pydantic.Field(alias="_links")]


class ListAllMethodsMethodsResponseBody(Exception):
    r"""An error response object."""

    data: ListAllMethodsMethodsResponseBodyData

    def __init__(self, data: ListAllMethodsMethodsResponseBodyData):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(self.data, ListAllMethodsMethodsResponseBodyData)


class ListAllMethodsMinimumAmountTypedDict(TypedDict):
    r"""The minimum payment amount required to use this payment method."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class ListAllMethodsMinimumAmount(BaseModel):
    r"""The minimum payment amount required to use this payment method."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class ListAllMethodsMaximumAmountTypedDict(TypedDict):
    r"""The maximum payment amount allowed when using this payment method. If there is no method-specific maximum, `null` is returned instead."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class ListAllMethodsMaximumAmount(BaseModel):
    r"""The maximum payment amount allowed when using this payment method. If there is no method-specific maximum, `null` is returned instead."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class ListAllMethodsImageTypedDict(TypedDict):
    r"""URLs of images representing the payment method."""

    size1x: NotRequired[str]
    r"""The URL pointing to an icon of 32 by 24 pixels."""
    size2x: NotRequired[str]
    r"""The URL pointing to an icon of 64 by 48 pixels."""
    svg: NotRequired[str]
    r"""The URL pointing to a vector version of the icon. Usage of this format is preferred, since the icon can scale to any desired size without compromising visual quality."""


class ListAllMethodsImage(BaseModel):
    r"""URLs of images representing the payment method."""

    size1x: Optional[str] = None
    r"""The URL pointing to an icon of 32 by 24 pixels."""

    size2x: Optional[str] = None
    r"""The URL pointing to an icon of 64 by 48 pixels."""

    svg: Optional[str] = None
    r"""The URL pointing to a vector version of the icon. Usage of this format is preferred, since the icon can scale to any desired size without compromising visual quality."""


class ListAllMethodsMethodsImageTypedDict(TypedDict):
    r"""URLs of images representing the issuer."""

    size1x: NotRequired[str]
    r"""The URL pointing to an icon of 32 by 24 pixels."""
    size2x: NotRequired[str]
    r"""The URL pointing to an icon of 64 by 48 pixels."""
    svg: NotRequired[str]
    r"""The URL pointing to a vector version of the icon. Usage of this format is preferred, since the icon can scale to any desired size without compromising visual quality."""


class ListAllMethodsMethodsImage(BaseModel):
    r"""URLs of images representing the issuer."""

    size1x: Optional[str] = None
    r"""The URL pointing to an icon of 32 by 24 pixels."""

    size2x: Optional[str] = None
    r"""The URL pointing to an icon of 64 by 48 pixels."""

    svg: Optional[str] = None
    r"""The URL pointing to a vector version of the icon. Usage of this format is preferred, since the icon can scale to any desired size without compromising visual quality."""


class ListAllMethodsIssuersTypedDict(TypedDict):
    resource: NotRequired[str]
    id: NotRequired[str]
    name: NotRequired[str]
    r"""The full name of the issuer."""
    image: NotRequired[ListAllMethodsMethodsImageTypedDict]
    r"""URLs of images representing the issuer."""


class ListAllMethodsIssuers(BaseModel):
    resource: Optional[str] = "issuer"

    id: Optional[str] = None

    name: Optional[str] = None
    r"""The full name of the issuer."""

    image: Optional[ListAllMethodsMethodsImage] = None
    r"""URLs of images representing the issuer."""


class ListAllMethodsMethodsSelfTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class ListAllMethodsMethodsSelf(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class ListAllMethodsMethodsResponseDocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class ListAllMethodsMethodsResponseDocumentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class ListAllMethodsMethodsResponseLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: NotRequired[ListAllMethodsMethodsSelfTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    documentation: NotRequired[ListAllMethodsMethodsResponseDocumentationTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class ListAllMethodsMethodsResponseLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[
        Optional[ListAllMethodsMethodsSelf], pydantic.Field(alias="self")
    ] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    documentation: Optional[ListAllMethodsMethodsResponseDocumentation] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class FixedTypedDict(TypedDict):
    r"""The fixed price charged per payment."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class Fixed(BaseModel):
    r"""The fixed price charged per payment."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class PricingTypedDict(TypedDict):
    description: NotRequired[str]
    r"""A description of what the pricing applies to. For example, a specific country (`The Netherlands`) or a category of cards (`American Express`). If a `locale` is provided, the description may be translated."""
    fixed: NotRequired[FixedTypedDict]
    r"""The fixed price charged per payment."""
    variable: NotRequired[str]
    r"""The variable price charged per payment, as a percentage string."""
    fee_region: NotRequired[Nullable[str]]
    r"""Only present for credit card pricing. It will correspond with the `feeRegion` of credit card payments as returned in the [Payments API](get-payment)."""


class Pricing(BaseModel):
    description: Optional[str] = None
    r"""A description of what the pricing applies to. For example, a specific country (`The Netherlands`) or a category of cards (`American Express`). If a `locale` is provided, the description may be translated."""

    fixed: Optional[Fixed] = None
    r"""The fixed price charged per payment."""

    variable: Optional[str] = None
    r"""The variable price charged per payment, as a percentage string."""

    fee_region: Annotated[OptionalNullable[str], pydantic.Field(alias="feeRegion")] = (
        UNSET
    )
    r"""Only present for credit card pricing. It will correspond with the `feeRegion` of credit card payments as returned in the [Payments API](get-payment)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["description", "fixed", "variable", "feeRegion"]
        nullable_fields = ["feeRegion"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListAllMethodsMethodsTypedDict(TypedDict):
    resource: NotRequired[str]
    r"""Indicates the response contains a payment method object. Will always contain the string `method` for this endpoint."""
    id: NotRequired[str]
    r"""The unique identifier of the payment method. When used during [payment creation](create-payment), the payment method selection screen will be skipped.

    Possible values: `alma` `applepay` `bacs` `bancomatpay` `bancontact` `banktransfer` `belfius` `billie` `blik` `creditcard` `directdebit` `eps` `giftcard` `ideal` `in3` `kbc` `klarna` `klarnapaylater` `klarnapaynow` `klarnasliceit` `mybank` `paypal` `paysafecard` `przelewy24` `riverty` `satispay` `swish` `trustly` `twint` `voucher`
    """
    description: NotRequired[str]
    r"""The full name of the payment method.

    If a `locale` parameter is provided, the name is translated to the given locale if possible.
    """
    minimum_amount: NotRequired[ListAllMethodsMinimumAmountTypedDict]
    r"""The minimum payment amount required to use this payment method."""
    maximum_amount: NotRequired[Nullable[ListAllMethodsMaximumAmountTypedDict]]
    r"""The maximum payment amount allowed when using this payment method. If there is no method-specific maximum, `null` is returned instead."""
    image: NotRequired[ListAllMethodsImageTypedDict]
    r"""URLs of images representing the payment method."""
    status: NotRequired[Nullable[str]]
    r"""The payment method's activation status for this profile.

    Possible values: `activated` `pending-boarding` `pending-review` `pending-external` `rejected`
    """
    issuers: NotRequired[List[ListAllMethodsIssuersTypedDict]]
    r"""**Optional include.** Array of objects for each 'issuer' that is available for this payment method. Only relevant for iDEAL, KBC/CBC, gift cards, and vouchers."""
    links: NotRequired[ListAllMethodsMethodsResponseLinksTypedDict]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""
    pricing: NotRequired[List[PricingTypedDict]]
    r"""**Optional include.** Array of objects describing the pricing configuration applicable for this payment method on your account."""


class ListAllMethodsMethods(BaseModel):
    resource: Optional[str] = "method"
    r"""Indicates the response contains a payment method object. Will always contain the string `method` for this endpoint."""

    id: Optional[str] = None
    r"""The unique identifier of the payment method. When used during [payment creation](create-payment), the payment method selection screen will be skipped.

    Possible values: `alma` `applepay` `bacs` `bancomatpay` `bancontact` `banktransfer` `belfius` `billie` `blik` `creditcard` `directdebit` `eps` `giftcard` `ideal` `in3` `kbc` `klarna` `klarnapaylater` `klarnapaynow` `klarnasliceit` `mybank` `paypal` `paysafecard` `przelewy24` `riverty` `satispay` `swish` `trustly` `twint` `voucher`
    """

    description: Optional[str] = None
    r"""The full name of the payment method.

    If a `locale` parameter is provided, the name is translated to the given locale if possible.
    """

    minimum_amount: Annotated[
        Optional[ListAllMethodsMinimumAmount], pydantic.Field(alias="minimumAmount")
    ] = None
    r"""The minimum payment amount required to use this payment method."""

    maximum_amount: Annotated[
        OptionalNullable[ListAllMethodsMaximumAmount],
        pydantic.Field(alias="maximumAmount"),
    ] = UNSET
    r"""The maximum payment amount allowed when using this payment method. If there is no method-specific maximum, `null` is returned instead."""

    image: Optional[ListAllMethodsImage] = None
    r"""URLs of images representing the payment method."""

    status: OptionalNullable[str] = UNSET
    r"""The payment method's activation status for this profile.

    Possible values: `activated` `pending-boarding` `pending-review` `pending-external` `rejected`
    """

    issuers: Optional[List[ListAllMethodsIssuers]] = None
    r"""**Optional include.** Array of objects for each 'issuer' that is available for this payment method. Only relevant for iDEAL, KBC/CBC, gift cards, and vouchers."""

    links: Annotated[
        Optional[ListAllMethodsMethodsResponseLinks], pydantic.Field(alias="_links")
    ] = None
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    pricing: Optional[List[Pricing]] = None
    r"""**Optional include.** Array of objects describing the pricing configuration applicable for this payment method on your account."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "resource",
            "id",
            "description",
            "minimumAmount",
            "maximumAmount",
            "image",
            "status",
            "issuers",
            "_links",
            "pricing",
        ]
        nullable_fields = ["maximumAmount", "status"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListAllMethodsEmbeddedTypedDict(TypedDict):
    methods: NotRequired[List[ListAllMethodsMethodsTypedDict]]
    r"""An array of payment method objects. For a complete reference of the payment method object, refer to the [Get payment method endpoint](get-method) documentation."""


class ListAllMethodsEmbedded(BaseModel):
    methods: Optional[List[ListAllMethodsMethods]] = None
    r"""An array of payment method objects. For a complete reference of the payment method object, refer to the [Get payment method endpoint](get-method) documentation."""


class ListAllMethodsSelfTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class ListAllMethodsSelf(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class ListAllMethodsDocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class ListAllMethodsDocumentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class ListAllMethodsLinksTypedDict(TypedDict):
    self_: NotRequired[ListAllMethodsSelfTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    documentation: NotRequired[ListAllMethodsDocumentationTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class ListAllMethodsLinks(BaseModel):
    self_: Annotated[Optional[ListAllMethodsSelf], pydantic.Field(alias="self")] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    documentation: Optional[ListAllMethodsDocumentation] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class ListAllMethodsResponseBodyTypedDict(TypedDict):
    r"""A list of payment method objects. For a complete reference of the payment method object, refer to the [Get payment method endpoint](get-method) documentation."""

    count: NotRequired[int]
    r"""The number of payment method objects in this result set. Results are **not** paginated."""
    embedded: NotRequired[ListAllMethodsEmbeddedTypedDict]
    links: NotRequired[ListAllMethodsLinksTypedDict]


class ListAllMethodsResponseBody(BaseModel):
    r"""A list of payment method objects. For a complete reference of the payment method object, refer to the [Get payment method endpoint](get-method) documentation."""

    count: Optional[int] = None
    r"""The number of payment method objects in this result set. Results are **not** paginated."""

    embedded: Annotated[
        Optional[ListAllMethodsEmbedded], pydantic.Field(alias="_embedded")
    ] = None

    links: Annotated[Optional[ListAllMethodsLinks], pydantic.Field(alias="_links")] = (
        None
    )
