"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from mollie import utils
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import FieldMetadata, PathParamMetadata, QueryParamMetadata
import pydantic
from pydantic import model_serializer
from typing_extensions import Annotated, NotRequired, TypedDict


class ReleaseAuthorizationRequestTypedDict(TypedDict):
    payment_id: str
    r"""Provide the ID of the related payment."""
    testmode: NotRequired[Nullable[bool]]
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """


class ReleaseAuthorizationRequest(BaseModel):
    payment_id: Annotated[
        str,
        pydantic.Field(alias="paymentId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""Provide the ID of the related payment."""

    testmode: Annotated[
        OptionalNullable[bool],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["testmode"]
        nullable_fields = ["testmode"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ReleaseAuthorizationPaymentsDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str
    type: str


class ReleaseAuthorizationPaymentsDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str

    type: str


class ReleaseAuthorizationPaymentsLinksTypedDict(TypedDict):
    documentation: ReleaseAuthorizationPaymentsDocumentationTypedDict
    r"""The URL to the generic Mollie API error handling guide."""


class ReleaseAuthorizationPaymentsLinks(BaseModel):
    documentation: ReleaseAuthorizationPaymentsDocumentation
    r"""The URL to the generic Mollie API error handling guide."""


class ReleaseAuthorizationPaymentsResponseBodyData(BaseModel):
    status: int
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: str
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: str
    r"""A detailed human-readable description of the error that occurred."""

    field: str
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name of the field that caused the issue."""

    links: Annotated[ReleaseAuthorizationPaymentsLinks, pydantic.Field(alias="_links")]


class ReleaseAuthorizationPaymentsResponseBody(Exception):
    r"""An error response object."""

    data: ReleaseAuthorizationPaymentsResponseBodyData

    def __init__(self, data: ReleaseAuthorizationPaymentsResponseBodyData):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(
            self.data, ReleaseAuthorizationPaymentsResponseBodyData
        )


class ReleaseAuthorizationDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str
    type: str


class ReleaseAuthorizationDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str

    type: str


class ReleaseAuthorizationLinksTypedDict(TypedDict):
    documentation: ReleaseAuthorizationDocumentationTypedDict
    r"""The URL to the generic Mollie API error handling guide."""


class ReleaseAuthorizationLinks(BaseModel):
    documentation: ReleaseAuthorizationDocumentation
    r"""The URL to the generic Mollie API error handling guide."""


class ReleaseAuthorizationResponseBodyData(BaseModel):
    status: int
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: str
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: str
    r"""A detailed human-readable description of the error that occurred."""

    links: Annotated[ReleaseAuthorizationLinks, pydantic.Field(alias="_links")]


class ReleaseAuthorizationResponseBody(Exception):
    r"""An error response object."""

    data: ReleaseAuthorizationResponseBodyData

    def __init__(self, data: ReleaseAuthorizationResponseBodyData):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(self.data, ReleaseAuthorizationResponseBodyData)
