"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from mollie import utils
from mollie.types import BaseModel
from mollie.utils import FieldMetadata, PathParamMetadata
import pydantic
from typing_extensions import Annotated, TypedDict


class DeleteProfileRequestTypedDict(TypedDict):
    id: str
    r"""Provide the ID of the item you want to perform this operation on."""


class DeleteProfileRequest(BaseModel):
    id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""Provide the ID of the item you want to perform this operation on."""


class DeleteProfileProfilesDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str
    type: str


class DeleteProfileProfilesDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str

    type: str


class DeleteProfileProfilesLinksTypedDict(TypedDict):
    documentation: DeleteProfileProfilesDocumentationTypedDict
    r"""The URL to the generic Mollie API error handling guide."""


class DeleteProfileProfilesLinks(BaseModel):
    documentation: DeleteProfileProfilesDocumentation
    r"""The URL to the generic Mollie API error handling guide."""


class DeleteProfileProfilesResponseBodyData(BaseModel):
    status: int
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: str
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: str
    r"""A detailed human-readable description of the error that occurred."""

    links: Annotated[DeleteProfileProfilesLinks, pydantic.Field(alias="_links")]


class DeleteProfileProfilesResponseBody(Exception):
    r"""An error response object."""

    data: DeleteProfileProfilesResponseBodyData

    def __init__(self, data: DeleteProfileProfilesResponseBodyData):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(self.data, DeleteProfileProfilesResponseBodyData)


class DeleteProfileDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str
    type: str


class DeleteProfileDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str

    type: str


class DeleteProfileLinksTypedDict(TypedDict):
    documentation: DeleteProfileDocumentationTypedDict
    r"""The URL to the generic Mollie API error handling guide."""


class DeleteProfileLinks(BaseModel):
    documentation: DeleteProfileDocumentation
    r"""The URL to the generic Mollie API error handling guide."""


class DeleteProfileResponseBodyData(BaseModel):
    status: int
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: str
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: str
    r"""A detailed human-readable description of the error that occurred."""

    links: Annotated[DeleteProfileLinks, pydantic.Field(alias="_links")]


class DeleteProfileResponseBody(Exception):
    r"""An error response object."""

    data: DeleteProfileResponseBodyData

    def __init__(self, data: DeleteProfileResponseBodyData):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(self.data, DeleteProfileResponseBodyData)
