"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from mollie import utils
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
import pydantic
from pydantic import model_serializer
from typing_extensions import Annotated, NotRequired, TypedDict


class RequestApplePayPaymentSessionRequestBodyTypedDict(TypedDict):
    validation_url: str
    r"""The validationUrl you got from the [ApplePayValidateMerchant event](https://developer.apple.com/documentation/apple_pay_on_the_web/applepayvalidatemerchantevent).

    A list of all [valid host names](https://developer.apple.com/documentation/apple_pay_on_the_web/setting_up_your_server) for merchant validation is available. You should white list these in your application and reject any `validationUrl`s that have a host name not in the list.
    """
    domain: str
    r"""The domain of your web shop, that is visible in the browser's location bar. For example `pay.myshop.com`."""
    profile_id: NotRequired[Nullable[str]]
    r"""The identifier referring to the [profile](get-profile) this entity belongs to.

    Most API credentials are linked to a single profile. In these cases the `profileId` can be omitted in the creation request. For organization-level credentials such as OAuth access tokens however, the `profileId` parameter is required.
    """


class RequestApplePayPaymentSessionRequestBody(BaseModel):
    validation_url: Annotated[str, pydantic.Field(alias="validationUrl")]
    r"""The validationUrl you got from the [ApplePayValidateMerchant event](https://developer.apple.com/documentation/apple_pay_on_the_web/applepayvalidatemerchantevent).

    A list of all [valid host names](https://developer.apple.com/documentation/apple_pay_on_the_web/setting_up_your_server) for merchant validation is available. You should white list these in your application and reject any `validationUrl`s that have a host name not in the list.
    """

    domain: str
    r"""The domain of your web shop, that is visible in the browser's location bar. For example `pay.myshop.com`."""

    profile_id: Annotated[OptionalNullable[str], pydantic.Field(alias="profileId")] = (
        UNSET
    )
    r"""The identifier referring to the [profile](get-profile) this entity belongs to.

    Most API credentials are linked to a single profile. In these cases the `profileId` can be omitted in the creation request. For organization-level credentials such as OAuth access tokens however, the `profileId` parameter is required.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["profileId"]
        nullable_fields = ["profileId"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class RequestApplePayPaymentSessionDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str
    type: str


class RequestApplePayPaymentSessionDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str

    type: str


class RequestApplePayPaymentSessionLinksTypedDict(TypedDict):
    documentation: RequestApplePayPaymentSessionDocumentationTypedDict
    r"""The URL to the generic Mollie API error handling guide."""


class RequestApplePayPaymentSessionLinks(BaseModel):
    documentation: RequestApplePayPaymentSessionDocumentation
    r"""The URL to the generic Mollie API error handling guide."""


class RequestApplePayPaymentSessionResponseBodyData(BaseModel):
    status: int
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: str
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: str
    r"""A detailed human-readable description of the error that occurred."""

    field: str
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name of the field that caused the issue."""

    links: Annotated[RequestApplePayPaymentSessionLinks, pydantic.Field(alias="_links")]


class RequestApplePayPaymentSessionResponseBody(Exception):
    r"""An error response object."""

    data: RequestApplePayPaymentSessionResponseBodyData

    def __init__(self, data: RequestApplePayPaymentSessionResponseBodyData):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(
            self.data, RequestApplePayPaymentSessionResponseBodyData
        )
