"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from .basesdk import BaseSDK
from mollie import models, utils
from mollie._hooks import HookContext
from mollie.types import OptionalNullable, UNSET
from mollie.utils import get_security_from_env
from typing import Any, Mapping, Optional


class Mandates(BaseSDK):
    def create(
        self,
        *,
        customer_id: str,
        method: str,
        consumer_name: str,
        id: Optional[str] = None,
        consumer_account: OptionalNullable[str] = UNSET,
        consumer_bic: OptionalNullable[str] = UNSET,
        consumer_email: OptionalNullable[str] = UNSET,
        signature_date: OptionalNullable[str] = UNSET,
        mandate_reference: OptionalNullable[str] = UNSET,
        paypal_billing_agreement_id: OptionalNullable[str] = UNSET,
        pay_pal_vault_id: OptionalNullable[str] = UNSET,
        testmode: OptionalNullable[bool] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.CreateMandateResponseBody:
        r"""Create mandate

        Create a mandate for a specific customer. Mandates allow you to charge a customer's card, PayPal account or bank account recurrently.

        It is only possible to create mandates for IBANs and PayPal billing agreements with this endpoint. To create mandates for cards, your customers need to perform a 'first payment' with their card.

        > 🔑 Access with
        >
        > [API key](/reference/authentication)
        >
        > [Access token with **mandates.write**](/reference/authentication)

        :param customer_id: Provide the ID of the related customer.
        :param method: Payment method of the mandate.  SEPA Direct Debit and PayPal mandates can be created directly.  Possible values: `creditcard` `directdebit` `paypal`
        :param consumer_name: The customer's name.
        :param id: The identifier uniquely referring to this mandate. Example: `mdt_pWUnw6pkBN`.
        :param consumer_account: The customer's IBAN. Required for SEPA Direct Debit mandates.
        :param consumer_bic: The BIC of the customer's bank.
        :param consumer_email: The customer's email address. Required for PayPal mandates.
        :param signature_date: The date when the mandate was signed in `YYYY-MM-DD` format.
        :param mandate_reference: A custom mandate reference. For SEPA Direct Debit, it is vital to provide a unique reference. Some banks will decline Direct Debit payments if the mandate reference is not unique.
        :param paypal_billing_agreement_id: The billing agreement ID given by PayPal. For example: `B-12A34567B8901234CD`. Required for PayPal mandates. Must provide either this field or `payPalVaultId`, but not both.
        :param pay_pal_vault_id: The Vault ID given by PayPal. For example: `8kk8451t`. Required for PayPal mandates. Must provide either this field or `paypalBillingAgreementId`, but not both.
        :param testmode: Whether to create the entity in test mode or live mode.  Most API credentials are specifically created for either live mode or test mode, in which case this parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting `testmode` to `true`.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.CreateMandateRequest(
            customer_id=customer_id,
            request_body=models.CreateMandateRequestBody(
                id=id,
                method=method,
                consumer_name=consumer_name,
                consumer_account=consumer_account,
                consumer_bic=consumer_bic,
                consumer_email=consumer_email,
                signature_date=signature_date,
                mandate_reference=mandate_reference,
                paypal_billing_agreement_id=paypal_billing_agreement_id,
                pay_pal_vault_id=pay_pal_vault_id,
                testmode=testmode,
            ),
        )

        req = self._build_request(
            method="POST",
            path="/customers/{customerId}/mandates",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/hal+json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.request_body,
                False,
                True,
                "json",
                Optional[models.CreateMandateRequestBody],
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(500, 60000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["5xx"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                base_url=base_url or "",
                operation_id="create-mandate",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["404", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "201", "application/hal+json"):
            return utils.unmarshal_json(http_res.text, models.CreateMandateResponseBody)
        if utils.match_response(http_res, "404", "application/hal+json"):
            response_data = utils.unmarshal_json(
                http_res.text, models.CreateMandateMandatesResponseBodyData
            )
            raise models.CreateMandateMandatesResponseBody(data=response_data)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = utils.stream_to_text(http_res)
        raise models.APIError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )

    async def create_async(
        self,
        *,
        customer_id: str,
        method: str,
        consumer_name: str,
        id: Optional[str] = None,
        consumer_account: OptionalNullable[str] = UNSET,
        consumer_bic: OptionalNullable[str] = UNSET,
        consumer_email: OptionalNullable[str] = UNSET,
        signature_date: OptionalNullable[str] = UNSET,
        mandate_reference: OptionalNullable[str] = UNSET,
        paypal_billing_agreement_id: OptionalNullable[str] = UNSET,
        pay_pal_vault_id: OptionalNullable[str] = UNSET,
        testmode: OptionalNullable[bool] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.CreateMandateResponseBody:
        r"""Create mandate

        Create a mandate for a specific customer. Mandates allow you to charge a customer's card, PayPal account or bank account recurrently.

        It is only possible to create mandates for IBANs and PayPal billing agreements with this endpoint. To create mandates for cards, your customers need to perform a 'first payment' with their card.

        > 🔑 Access with
        >
        > [API key](/reference/authentication)
        >
        > [Access token with **mandates.write**](/reference/authentication)

        :param customer_id: Provide the ID of the related customer.
        :param method: Payment method of the mandate.  SEPA Direct Debit and PayPal mandates can be created directly.  Possible values: `creditcard` `directdebit` `paypal`
        :param consumer_name: The customer's name.
        :param id: The identifier uniquely referring to this mandate. Example: `mdt_pWUnw6pkBN`.
        :param consumer_account: The customer's IBAN. Required for SEPA Direct Debit mandates.
        :param consumer_bic: The BIC of the customer's bank.
        :param consumer_email: The customer's email address. Required for PayPal mandates.
        :param signature_date: The date when the mandate was signed in `YYYY-MM-DD` format.
        :param mandate_reference: A custom mandate reference. For SEPA Direct Debit, it is vital to provide a unique reference. Some banks will decline Direct Debit payments if the mandate reference is not unique.
        :param paypal_billing_agreement_id: The billing agreement ID given by PayPal. For example: `B-12A34567B8901234CD`. Required for PayPal mandates. Must provide either this field or `payPalVaultId`, but not both.
        :param pay_pal_vault_id: The Vault ID given by PayPal. For example: `8kk8451t`. Required for PayPal mandates. Must provide either this field or `paypalBillingAgreementId`, but not both.
        :param testmode: Whether to create the entity in test mode or live mode.  Most API credentials are specifically created for either live mode or test mode, in which case this parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting `testmode` to `true`.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.CreateMandateRequest(
            customer_id=customer_id,
            request_body=models.CreateMandateRequestBody(
                id=id,
                method=method,
                consumer_name=consumer_name,
                consumer_account=consumer_account,
                consumer_bic=consumer_bic,
                consumer_email=consumer_email,
                signature_date=signature_date,
                mandate_reference=mandate_reference,
                paypal_billing_agreement_id=paypal_billing_agreement_id,
                pay_pal_vault_id=pay_pal_vault_id,
                testmode=testmode,
            ),
        )

        req = self._build_request_async(
            method="POST",
            path="/customers/{customerId}/mandates",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/hal+json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.request_body,
                False,
                True,
                "json",
                Optional[models.CreateMandateRequestBody],
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(500, 60000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["5xx"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                base_url=base_url or "",
                operation_id="create-mandate",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["404", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "201", "application/hal+json"):
            return utils.unmarshal_json(http_res.text, models.CreateMandateResponseBody)
        if utils.match_response(http_res, "404", "application/hal+json"):
            response_data = utils.unmarshal_json(
                http_res.text, models.CreateMandateMandatesResponseBodyData
            )
            raise models.CreateMandateMandatesResponseBody(data=response_data)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = await utils.stream_to_text_async(http_res)
        raise models.APIError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )

    def list(
        self,
        *,
        customer_id: str,
        from_: Optional[str] = None,
        limit: OptionalNullable[int] = 50,
        sort: OptionalNullable[str] = UNSET,
        testmode: OptionalNullable[bool] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.ListMandatesResponseBody:
        r"""List mandates

        Retrieve a list of all mandates.

        The results are paginated.

        > 🔑 Access with
        >
        > [API key](/reference/authentication)
        >
        > [Access token with **mandates.read**](/reference/authentication)

        :param customer_id: Provide the ID of the related customer.
        :param from_: Provide an ID to start the result set from the item with the given ID and onwards. This allows you to paginate the result set.
        :param limit: The maximum number of items to return. Defaults to 50 items.
        :param sort: Used for setting the direction of the result set. Defaults to descending order, meaning the results are ordered from newest to oldest.  Possible values: `asc` `desc` (default: `desc`)
        :param testmode: Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting the `testmode` query parameter to `true`.  Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.ListMandatesRequest(
            customer_id=customer_id,
            from_=from_,
            limit=limit,
            sort=sort,
            testmode=testmode,
        )

        req = self._build_request(
            method="GET",
            path="/customers/{customerId}/mandates",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/hal+json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(500, 60000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["5xx"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                base_url=base_url or "",
                operation_id="list-mandates",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "404", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/hal+json"):
            return utils.unmarshal_json(http_res.text, models.ListMandatesResponseBody)
        if utils.match_response(http_res, "400", "application/hal+json"):
            response_data = utils.unmarshal_json(
                http_res.text, models.ListMandatesMandatesResponseBodyData
            )
            raise models.ListMandatesMandatesResponseBody(data=response_data)
        if utils.match_response(http_res, "404", "application/hal+json"):
            response_data = utils.unmarshal_json(
                http_res.text, models.ListMandatesMandatesResponseResponseBodyData
            )
            raise models.ListMandatesMandatesResponseResponseBody(data=response_data)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = utils.stream_to_text(http_res)
        raise models.APIError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )

    async def list_async(
        self,
        *,
        customer_id: str,
        from_: Optional[str] = None,
        limit: OptionalNullable[int] = 50,
        sort: OptionalNullable[str] = UNSET,
        testmode: OptionalNullable[bool] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.ListMandatesResponseBody:
        r"""List mandates

        Retrieve a list of all mandates.

        The results are paginated.

        > 🔑 Access with
        >
        > [API key](/reference/authentication)
        >
        > [Access token with **mandates.read**](/reference/authentication)

        :param customer_id: Provide the ID of the related customer.
        :param from_: Provide an ID to start the result set from the item with the given ID and onwards. This allows you to paginate the result set.
        :param limit: The maximum number of items to return. Defaults to 50 items.
        :param sort: Used for setting the direction of the result set. Defaults to descending order, meaning the results are ordered from newest to oldest.  Possible values: `asc` `desc` (default: `desc`)
        :param testmode: Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting the `testmode` query parameter to `true`.  Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.ListMandatesRequest(
            customer_id=customer_id,
            from_=from_,
            limit=limit,
            sort=sort,
            testmode=testmode,
        )

        req = self._build_request_async(
            method="GET",
            path="/customers/{customerId}/mandates",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/hal+json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(500, 60000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["5xx"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                base_url=base_url or "",
                operation_id="list-mandates",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "404", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/hal+json"):
            return utils.unmarshal_json(http_res.text, models.ListMandatesResponseBody)
        if utils.match_response(http_res, "400", "application/hal+json"):
            response_data = utils.unmarshal_json(
                http_res.text, models.ListMandatesMandatesResponseBodyData
            )
            raise models.ListMandatesMandatesResponseBody(data=response_data)
        if utils.match_response(http_res, "404", "application/hal+json"):
            response_data = utils.unmarshal_json(
                http_res.text, models.ListMandatesMandatesResponseResponseBodyData
            )
            raise models.ListMandatesMandatesResponseResponseBody(data=response_data)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = await utils.stream_to_text_async(http_res)
        raise models.APIError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )

    def get(
        self,
        *,
        customer_id: str,
        mandate_id: str,
        testmode: OptionalNullable[bool] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.GetMandateResponseBody:
        r"""Get mandate

        Retrieve a single mandate by its ID. Depending on the type of mandate, the object will contain the customer's bank account details, card details, or PayPal account details.

        > 🔑 Access with
        >
        > [API key](/reference/authentication)
        >
        > [Access token with **mandates.read**](/reference/authentication)

        :param customer_id: Provide the ID of the related customer.
        :param mandate_id: Provide the ID of the related mandate.
        :param testmode: Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting the `testmode` query parameter to `true`.  Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetMandateRequest(
            customer_id=customer_id,
            mandate_id=mandate_id,
            testmode=testmode,
        )

        req = self._build_request(
            method="GET",
            path="/customers/{customerId}/mandates/{mandateId}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/hal+json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(500, 60000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["5xx"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                base_url=base_url or "",
                operation_id="get-mandate",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["404", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/hal+json"):
            return utils.unmarshal_json(http_res.text, models.GetMandateResponseBody)
        if utils.match_response(http_res, "404", "application/hal+json"):
            response_data = utils.unmarshal_json(
                http_res.text, models.GetMandateMandatesResponseBodyData
            )
            raise models.GetMandateMandatesResponseBody(data=response_data)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = utils.stream_to_text(http_res)
        raise models.APIError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )

    async def get_async(
        self,
        *,
        customer_id: str,
        mandate_id: str,
        testmode: OptionalNullable[bool] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.GetMandateResponseBody:
        r"""Get mandate

        Retrieve a single mandate by its ID. Depending on the type of mandate, the object will contain the customer's bank account details, card details, or PayPal account details.

        > 🔑 Access with
        >
        > [API key](/reference/authentication)
        >
        > [Access token with **mandates.read**](/reference/authentication)

        :param customer_id: Provide the ID of the related customer.
        :param mandate_id: Provide the ID of the related mandate.
        :param testmode: Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting the `testmode` query parameter to `true`.  Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetMandateRequest(
            customer_id=customer_id,
            mandate_id=mandate_id,
            testmode=testmode,
        )

        req = self._build_request_async(
            method="GET",
            path="/customers/{customerId}/mandates/{mandateId}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/hal+json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(500, 60000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["5xx"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                base_url=base_url or "",
                operation_id="get-mandate",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["404", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/hal+json"):
            return utils.unmarshal_json(http_res.text, models.GetMandateResponseBody)
        if utils.match_response(http_res, "404", "application/hal+json"):
            response_data = utils.unmarshal_json(
                http_res.text, models.GetMandateMandatesResponseBodyData
            )
            raise models.GetMandateMandatesResponseBody(data=response_data)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = await utils.stream_to_text_async(http_res)
        raise models.APIError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )

    def revoke(
        self,
        *,
        customer_id: str,
        mandate_id: str,
        testmode: OptionalNullable[bool] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Any:
        r"""Revoke mandate

        Revoke a customer's mandate. You will no longer be able to charge the customer's bank account or card with this mandate, and all connected subscriptions will be canceled.

        > 🔑 Access with
        >
        > [API key](/reference/authentication)
        >
        > [Access token with **mandates.write**](/reference/authentication)

        :param customer_id: Provide the ID of the related customer.
        :param mandate_id: Provide the ID of the related mandate.
        :param testmode: Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting the `testmode` query parameter to `true`.  Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.RevokeMandateRequest(
            customer_id=customer_id,
            mandate_id=mandate_id,
            testmode=testmode,
        )

        req = self._build_request(
            method="DELETE",
            path="/customers/{customerId}/mandates/{mandateId}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/hal+json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(500, 60000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["5xx"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                base_url=base_url or "",
                operation_id="revoke-mandate",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["404", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "204", "application/hal+json"):
            return utils.unmarshal_json(http_res.text, Any)
        if utils.match_response(http_res, "404", "application/hal+json"):
            response_data = utils.unmarshal_json(
                http_res.text, models.RevokeMandateResponseBodyData
            )
            raise models.RevokeMandateResponseBody(data=response_data)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = utils.stream_to_text(http_res)
        raise models.APIError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )

    async def revoke_async(
        self,
        *,
        customer_id: str,
        mandate_id: str,
        testmode: OptionalNullable[bool] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Any:
        r"""Revoke mandate

        Revoke a customer's mandate. You will no longer be able to charge the customer's bank account or card with this mandate, and all connected subscriptions will be canceled.

        > 🔑 Access with
        >
        > [API key](/reference/authentication)
        >
        > [Access token with **mandates.write**](/reference/authentication)

        :param customer_id: Provide the ID of the related customer.
        :param mandate_id: Provide the ID of the related mandate.
        :param testmode: Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting the `testmode` query parameter to `true`.  Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.RevokeMandateRequest(
            customer_id=customer_id,
            mandate_id=mandate_id,
            testmode=testmode,
        )

        req = self._build_request_async(
            method="DELETE",
            path="/customers/{customerId}/mandates/{mandateId}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/hal+json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(500, 60000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["5xx"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                base_url=base_url or "",
                operation_id="revoke-mandate",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["404", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "204", "application/hal+json"):
            return utils.unmarshal_json(http_res.text, Any)
        if utils.match_response(http_res, "404", "application/hal+json"):
            response_data = utils.unmarshal_json(
                http_res.text, models.RevokeMandateResponseBodyData
            )
            raise models.RevokeMandateResponseBody(data=response_data)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = await utils.stream_to_text_async(http_res)
        raise models.APIError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )
