"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
from mollie import utils
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import FieldMetadata, PathParamMetadata, RequestMetadata
import pydantic
from pydantic import model_serializer
from typing import List, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


class CreateOrderRefundAmountTypedDict(TypedDict):
    r"""The amount refunded to your customer with this refund. The amount is allowed to be lower than the original payment amount."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateOrderRefundAmount(BaseModel):
    r"""The amount refunded to your customer with this refund. The amount is allowed to be lower than the original payment amount."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateOrderRefundMetadata2TypedDict(TypedDict):
    pass


class CreateOrderRefundMetadata2(BaseModel):
    pass


CreateOrderRefundMetadataTypedDict = TypeAliasType(
    "CreateOrderRefundMetadataTypedDict",
    Union[CreateOrderRefundMetadata2TypedDict, str, List[str]],
)
r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB."""


CreateOrderRefundMetadata = TypeAliasType(
    "CreateOrderRefundMetadata", Union[CreateOrderRefundMetadata2, str, List[str]]
)
r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB."""


class CreateOrderRefundExternalReferenceTypedDict(TypedDict):
    type: NotRequired[str]
    r"""Specifies the reference type

    Possible values: `acquirer-reference`
    """
    id: NotRequired[str]
    r"""Unique reference from the payment provider"""


class CreateOrderRefundExternalReference(BaseModel):
    type: Optional[str] = None
    r"""Specifies the reference type

    Possible values: `acquirer-reference`
    """

    id: Optional[str] = None
    r"""Unique reference from the payment provider"""


class Type(str, Enum):
    PHYSICAL = "physical"
    DIGITAL = "digital"
    DISCOUNT = "discount"
    SHIPPING_FEE = "shipping_fee"
    STORE_CREDIT = "store_credit"
    GIFT_CARD = "gift_card"
    SURCHARGE = "surcharge"


class Status(str, Enum):
    CREATED = "created"
    AUTHORIZED = "authorized"
    PAID = "paid"
    CANCELED = "canceled"
    SHIPPING = "shipping"
    COMPLETED = "completed"


class CreateOrderRefundMetadataRefunds2TypedDict(TypedDict):
    pass


class CreateOrderRefundMetadataRefunds2(BaseModel):
    pass


CreateOrderRefundRefundsMetadataTypedDict = TypeAliasType(
    "CreateOrderRefundRefundsMetadataTypedDict",
    Union[CreateOrderRefundMetadataRefunds2TypedDict, str, List[str]],
)
r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB."""


CreateOrderRefundRefundsMetadata = TypeAliasType(
    "CreateOrderRefundRefundsMetadata",
    Union[CreateOrderRefundMetadataRefunds2, str, List[str]],
)
r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB."""


class AmountShippedTypedDict(TypedDict):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class AmountShipped(BaseModel):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class AmountRefundedTypedDict(TypedDict):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class AmountRefunded(BaseModel):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class AmountCanceledTypedDict(TypedDict):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class AmountCanceled(BaseModel):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateOrderRefundRefundsAmountTypedDict(TypedDict):
    r"""The amount that you want to refund. In almost all cases, Mollie can determine the amount automatically.

    The amount is required only if you are partially refunding an order line which has a non-zero `discountAmount`.

    The amount you can refund depends on various properties of the order line and the create order refund request. The maximum that can be refunded is `unit price x quantity to ship`.

    The minimum amount depends on the discount applied to the line, the quantity already refunded or shipped, the amounts already refunded or shipped and the quantity you want to refund.

    If you do not send an amount, Mollie will determine the amount automatically or respond with an error if the amount cannot be determined automatically. The error will contain the `extra.minimumAmount` and `extra.maximumAmount` properties that allow you pick the right amount.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateOrderRefundRefundsAmount(BaseModel):
    r"""The amount that you want to refund. In almost all cases, Mollie can determine the amount automatically.

    The amount is required only if you are partially refunding an order line which has a non-zero `discountAmount`.

    The amount you can refund depends on various properties of the order line and the create order refund request. The maximum that can be refunded is `unit price x quantity to ship`.

    The minimum amount depends on the discount applied to the line, the quantity already refunded or shipped, the amounts already refunded or shipped and the quantity you want to refund.

    If you do not send an amount, Mollie will determine the amount automatically or respond with an error if the amount cannot be determined automatically. The error will contain the `extra.minimumAmount` and `extra.maximumAmount` properties that allow you pick the right amount.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateOrderRefundLinesTypedDict(TypedDict):
    id: NotRequired[str]
    r"""The ID of the order line you wish to refund. For example: `odl_jp31y97yjz`."""
    name: NotRequired[str]
    sku: NotRequired[Nullable[str]]
    type: NotRequired[Type]
    status: NotRequired[Status]
    metadata: NotRequired[Nullable[CreateOrderRefundRefundsMetadataTypedDict]]
    r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB."""
    is_cancelable: NotRequired[bool]
    quantity: NotRequired[int]
    r"""The number of items that should be refunded for this order line. When this parameter is omitted, the whole order line will be refunded.

    Must be less than the number of items already refunded for this order line.
    """
    quantity_shipped: NotRequired[int]
    amount_shipped: NotRequired[AmountShippedTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    quantity_refunded: NotRequired[int]
    amount_refunded: NotRequired[AmountRefundedTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    quantity_canceled: NotRequired[int]
    amount_canceled: NotRequired[AmountCanceledTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    amount: NotRequired[CreateOrderRefundRefundsAmountTypedDict]
    r"""The amount that you want to refund. In almost all cases, Mollie can determine the amount automatically.

    The amount is required only if you are partially refunding an order line which has a non-zero `discountAmount`.

    The amount you can refund depends on various properties of the order line and the create order refund request. The maximum that can be refunded is `unit price x quantity to ship`.

    The minimum amount depends on the discount applied to the line, the quantity already refunded or shipped, the amounts already refunded or shipped and the quantity you want to refund.

    If you do not send an amount, Mollie will determine the amount automatically or respond with an error if the amount cannot be determined automatically. The error will contain the `extra.minimumAmount` and `extra.maximumAmount` properties that allow you pick the right amount.
    """
    shippable_quantity: NotRequired[int]
    refundable_quantity: NotRequired[int]
    cancelable_quantity: NotRequired[int]
    vat_rate: NotRequired[str]
    created_at: NotRequired[str]


class CreateOrderRefundLines(BaseModel):
    id: Optional[str] = None
    r"""The ID of the order line you wish to refund. For example: `odl_jp31y97yjz`."""

    name: Optional[str] = None

    sku: OptionalNullable[str] = UNSET

    type: Optional[Type] = None

    status: Optional[Status] = None

    metadata: OptionalNullable[CreateOrderRefundRefundsMetadata] = UNSET
    r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB."""

    is_cancelable: Annotated[Optional[bool], pydantic.Field(alias="isCancelable")] = (
        None
    )

    quantity: Optional[int] = None
    r"""The number of items that should be refunded for this order line. When this parameter is omitted, the whole order line will be refunded.

    Must be less than the number of items already refunded for this order line.
    """

    quantity_shipped: Annotated[
        Optional[int], pydantic.Field(alias="quantityShipped")
    ] = None

    amount_shipped: Annotated[
        Optional[AmountShipped], pydantic.Field(alias="amountShipped")
    ] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    quantity_refunded: Annotated[
        Optional[int], pydantic.Field(alias="quantityRefunded")
    ] = None

    amount_refunded: Annotated[
        Optional[AmountRefunded], pydantic.Field(alias="amountRefunded")
    ] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    quantity_canceled: Annotated[
        Optional[int], pydantic.Field(alias="quantityCanceled")
    ] = None

    amount_canceled: Annotated[
        Optional[AmountCanceled], pydantic.Field(alias="amountCanceled")
    ] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    amount: Optional[CreateOrderRefundRefundsAmount] = None
    r"""The amount that you want to refund. In almost all cases, Mollie can determine the amount automatically.

    The amount is required only if you are partially refunding an order line which has a non-zero `discountAmount`.

    The amount you can refund depends on various properties of the order line and the create order refund request. The maximum that can be refunded is `unit price x quantity to ship`.

    The minimum amount depends on the discount applied to the line, the quantity already refunded or shipped, the amounts already refunded or shipped and the quantity you want to refund.

    If you do not send an amount, Mollie will determine the amount automatically or respond with an error if the amount cannot be determined automatically. The error will contain the `extra.minimumAmount` and `extra.maximumAmount` properties that allow you pick the right amount.
    """

    shippable_quantity: Annotated[
        Optional[int], pydantic.Field(alias="shippableQuantity")
    ] = None

    refundable_quantity: Annotated[
        Optional[int], pydantic.Field(alias="refundableQuantity")
    ] = None

    cancelable_quantity: Annotated[
        Optional[int], pydantic.Field(alias="cancelableQuantity")
    ] = None

    vat_rate: Annotated[Optional[str], pydantic.Field(alias="vatRate")] = None

    created_at: Annotated[Optional[str], pydantic.Field(alias="createdAt")] = None

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "id",
            "name",
            "sku",
            "type",
            "status",
            "metadata",
            "isCancelable",
            "quantity",
            "quantityShipped",
            "amountShipped",
            "quantityRefunded",
            "amountRefunded",
            "quantityCanceled",
            "amountCanceled",
            "amount",
            "shippableQuantity",
            "refundableQuantity",
            "cancelableQuantity",
            "vatRate",
            "createdAt",
        ]
        nullable_fields = ["sku", "metadata"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class CreateOrderRefundRequestBodyTypedDict(TypedDict):
    lines: List[CreateOrderRefundLinesTypedDict]
    r"""A refund can optionally be linked to specific order lines.

    The lines will show the `quantity`, `discountAmount`, `vatAmount`, and `totalAmount` refunded. If the line was partially refunded, these values will be different from the values in response from the [Get payment](get-payment) endpoint.
    """
    description: NotRequired[str]
    r"""The description of the refund that may be shown to your customer, depending on the payment method used."""
    amount: NotRequired[CreateOrderRefundAmountTypedDict]
    r"""The amount refunded to your customer with this refund. The amount is allowed to be lower than the original payment amount."""
    metadata: NotRequired[Nullable[CreateOrderRefundMetadataTypedDict]]
    r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB."""
    external_reference: NotRequired[CreateOrderRefundExternalReferenceTypedDict]
    testmode: NotRequired[Nullable[bool]]
    r"""Whether to create the entity in test mode or live mode.

    Most API credentials are specifically created for either live mode or test mode, in which case this parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting `testmode` to `true`.
    """


class CreateOrderRefundRequestBody(BaseModel):
    lines: List[CreateOrderRefundLines]
    r"""A refund can optionally be linked to specific order lines.

    The lines will show the `quantity`, `discountAmount`, `vatAmount`, and `totalAmount` refunded. If the line was partially refunded, these values will be different from the values in response from the [Get payment](get-payment) endpoint.
    """

    description: Optional[str] = None
    r"""The description of the refund that may be shown to your customer, depending on the payment method used."""

    amount: Optional[CreateOrderRefundAmount] = None
    r"""The amount refunded to your customer with this refund. The amount is allowed to be lower than the original payment amount."""

    metadata: OptionalNullable[CreateOrderRefundMetadata] = UNSET
    r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB."""

    external_reference: Annotated[
        Optional[CreateOrderRefundExternalReference],
        pydantic.Field(alias="externalReference"),
    ] = None

    testmode: OptionalNullable[bool] = UNSET
    r"""Whether to create the entity in test mode or live mode.

    Most API credentials are specifically created for either live mode or test mode, in which case this parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting `testmode` to `true`.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "description",
            "amount",
            "metadata",
            "externalReference",
            "testmode",
        ]
        nullable_fields = ["metadata", "testmode"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class CreateOrderRefundRequestTypedDict(TypedDict):
    order_id: str
    r"""Provide the ID of the related order."""
    request_body: NotRequired[CreateOrderRefundRequestBodyTypedDict]


class CreateOrderRefundRequest(BaseModel):
    order_id: Annotated[
        str,
        pydantic.Field(alias="orderId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""Provide the ID of the related order."""

    request_body: Annotated[
        Optional[CreateOrderRefundRequestBody],
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ] = None


class CreateOrderRefundRefundsResponseDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str
    type: str


class CreateOrderRefundRefundsResponseDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str

    type: str


class CreateOrderRefundRefundsResponseLinksTypedDict(TypedDict):
    documentation: CreateOrderRefundRefundsResponseDocumentationTypedDict
    r"""The URL to the generic Mollie API error handling guide."""


class CreateOrderRefundRefundsResponseLinks(BaseModel):
    documentation: CreateOrderRefundRefundsResponseDocumentation
    r"""The URL to the generic Mollie API error handling guide."""


class CreateOrderRefundRefundsResponseResponseBodyData(BaseModel):
    status: int
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: str
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: str
    r"""A detailed human-readable description of the error that occurred."""

    field: str
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name of the field that caused the issue."""

    links: Annotated[
        CreateOrderRefundRefundsResponseLinks, pydantic.Field(alias="_links")
    ]


class CreateOrderRefundRefundsResponseResponseBody(Exception):
    r"""An error response object."""

    data: CreateOrderRefundRefundsResponseResponseBodyData

    def __init__(self, data: CreateOrderRefundRefundsResponseResponseBodyData):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(
            self.data, CreateOrderRefundRefundsResponseResponseBodyData
        )


class CreateOrderRefundRefundsDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str
    type: str


class CreateOrderRefundRefundsDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str

    type: str


class CreateOrderRefundRefundsLinksTypedDict(TypedDict):
    documentation: CreateOrderRefundRefundsDocumentationTypedDict
    r"""The URL to the generic Mollie API error handling guide."""


class CreateOrderRefundRefundsLinks(BaseModel):
    documentation: CreateOrderRefundRefundsDocumentation
    r"""The URL to the generic Mollie API error handling guide."""


class CreateOrderRefundRefundsResponseBodyData(BaseModel):
    status: int
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: str
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: str
    r"""A detailed human-readable description of the error that occurred."""

    links: Annotated[CreateOrderRefundRefundsLinks, pydantic.Field(alias="_links")]


class CreateOrderRefundRefundsResponseBody(Exception):
    r"""An error response object."""

    data: CreateOrderRefundRefundsResponseBodyData

    def __init__(self, data: CreateOrderRefundRefundsResponseBodyData):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(self.data, CreateOrderRefundRefundsResponseBodyData)


class CreateOrderRefundRefundsResponseAmountTypedDict(TypedDict):
    r"""The amount refunded to your customer with this refund. The amount is allowed to be lower than the original payment amount."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateOrderRefundRefundsResponseAmount(BaseModel):
    r"""The amount refunded to your customer with this refund. The amount is allowed to be lower than the original payment amount."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateOrderRefundSettlementAmountTypedDict(TypedDict):
    r"""This optional field will contain the approximate amount that will be deducted from your account balance, converted to the currency your account is settled in.

    The amount is a **negative** amount.

    If the refund is not directly processed by Mollie, for example for PayPal refunds, the settlement amount will be zero.

    Since the field contains an estimated amount during refund processing, it may change over time. For example, while the refund is queued the settlement amount is likely not yet available.

    To retrieve accurate settlement amounts we recommend using the [List balance transactions endpoint](list-balance-transactions) instead.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateOrderRefundSettlementAmount(BaseModel):
    r"""This optional field will contain the approximate amount that will be deducted from your account balance, converted to the currency your account is settled in.

    The amount is a **negative** amount.

    If the refund is not directly processed by Mollie, for example for PayPal refunds, the settlement amount will be zero.

    Since the field contains an estimated amount during refund processing, it may change over time. For example, while the refund is queued the settlement amount is likely not yet available.

    To retrieve accurate settlement amounts we recommend using the [List balance transactions endpoint](list-balance-transactions) instead.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateOrderRefundMetadataRefundsResponse2TypedDict(TypedDict):
    pass


class CreateOrderRefundMetadataRefundsResponse2(BaseModel):
    pass


CreateOrderRefundRefundsResponseMetadataTypedDict = TypeAliasType(
    "CreateOrderRefundRefundsResponseMetadataTypedDict",
    Union[CreateOrderRefundMetadataRefundsResponse2TypedDict, str, List[str]],
)
r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB."""


CreateOrderRefundRefundsResponseMetadata = TypeAliasType(
    "CreateOrderRefundRefundsResponseMetadata",
    Union[CreateOrderRefundMetadataRefundsResponse2, str, List[str]],
)
r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB."""


class CreateOrderRefundRefundsExternalReferenceTypedDict(TypedDict):
    type: NotRequired[str]
    r"""Specifies the reference type

    Possible values: `acquirer-reference`
    """
    id: NotRequired[str]
    r"""Unique reference from the payment provider"""


class CreateOrderRefundRefundsExternalReference(BaseModel):
    type: Optional[str] = None
    r"""Specifies the reference type

    Possible values: `acquirer-reference`
    """

    id: Optional[str] = None
    r"""Unique reference from the payment provider"""


class CreateOrderRefundType(str, Enum):
    PHYSICAL = "physical"
    DIGITAL = "digital"
    DISCOUNT = "discount"
    SHIPPING_FEE = "shipping_fee"
    STORE_CREDIT = "store_credit"
    GIFT_CARD = "gift_card"
    SURCHARGE = "surcharge"


class CreateOrderRefundStatus(str, Enum):
    CREATED = "created"
    AUTHORIZED = "authorized"
    PAID = "paid"
    CANCELED = "canceled"
    SHIPPING = "shipping"
    COMPLETED = "completed"


class CreateOrderRefundMetadataRefundsResponse2012TypedDict(TypedDict):
    pass


class CreateOrderRefundMetadataRefundsResponse2012(BaseModel):
    pass


CreateOrderRefundRefundsResponse201MetadataTypedDict = TypeAliasType(
    "CreateOrderRefundRefundsResponse201MetadataTypedDict",
    Union[CreateOrderRefundMetadataRefundsResponse2012TypedDict, str, List[str]],
)
r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB."""


CreateOrderRefundRefundsResponse201Metadata = TypeAliasType(
    "CreateOrderRefundRefundsResponse201Metadata",
    Union[CreateOrderRefundMetadataRefundsResponse2012, str, List[str]],
)
r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB."""


class CreateOrderRefundAmountShippedTypedDict(TypedDict):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateOrderRefundAmountShipped(BaseModel):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateOrderRefundAmountRefundedTypedDict(TypedDict):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateOrderRefundAmountRefunded(BaseModel):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateOrderRefundAmountCanceledTypedDict(TypedDict):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateOrderRefundAmountCanceled(BaseModel):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateOrderRefundUnitPriceTypedDict(TypedDict):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateOrderRefundUnitPrice(BaseModel):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateOrderRefundTotalAmountTypedDict(TypedDict):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateOrderRefundTotalAmount(BaseModel):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateOrderRefundVatAmountTypedDict(TypedDict):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateOrderRefundVatAmount(BaseModel):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class DiscountedAmountTypedDict(TypedDict):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class DiscountedAmount(BaseModel):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateOrderRefundLinesOutputTypedDict(TypedDict):
    resource: NotRequired[str]
    id: NotRequired[str]
    r"""The ID of the order line you wish to refund. For example: `odl_jp31y97yjz`."""
    order_id: NotRequired[str]
    name: NotRequired[str]
    sku: NotRequired[Nullable[str]]
    type: NotRequired[CreateOrderRefundType]
    status: NotRequired[CreateOrderRefundStatus]
    metadata: NotRequired[
        Nullable[CreateOrderRefundRefundsResponse201MetadataTypedDict]
    ]
    r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB."""
    is_cancelable: NotRequired[bool]
    quantity: NotRequired[int]
    r"""The number of items that should be refunded for this order line. When this parameter is omitted, the whole order line will be refunded.

    Must be less than the number of items already refunded for this order line.
    """
    quantity_shipped: NotRequired[int]
    amount_shipped: NotRequired[CreateOrderRefundAmountShippedTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    quantity_refunded: NotRequired[int]
    amount_refunded: NotRequired[CreateOrderRefundAmountRefundedTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    quantity_canceled: NotRequired[int]
    amount_canceled: NotRequired[CreateOrderRefundAmountCanceledTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    shippable_quantity: NotRequired[int]
    refundable_quantity: NotRequired[int]
    cancelable_quantity: NotRequired[int]
    unit_price: NotRequired[CreateOrderRefundUnitPriceTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    total_amount: NotRequired[CreateOrderRefundTotalAmountTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    vat_rate: NotRequired[str]
    vat_amount: NotRequired[CreateOrderRefundVatAmountTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    created_at: NotRequired[str]
    discounted_amount: NotRequired[DiscountedAmountTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""


class CreateOrderRefundLinesOutput(BaseModel):
    resource: Optional[str] = "orderline"

    id: Optional[str] = None
    r"""The ID of the order line you wish to refund. For example: `odl_jp31y97yjz`."""

    order_id: Annotated[Optional[str], pydantic.Field(alias="orderId")] = None

    name: Optional[str] = None

    sku: OptionalNullable[str] = UNSET

    type: Optional[CreateOrderRefundType] = None

    status: Optional[CreateOrderRefundStatus] = None

    metadata: OptionalNullable[CreateOrderRefundRefundsResponse201Metadata] = UNSET
    r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB."""

    is_cancelable: Annotated[Optional[bool], pydantic.Field(alias="isCancelable")] = (
        None
    )

    quantity: Optional[int] = None
    r"""The number of items that should be refunded for this order line. When this parameter is omitted, the whole order line will be refunded.

    Must be less than the number of items already refunded for this order line.
    """

    quantity_shipped: Annotated[
        Optional[int], pydantic.Field(alias="quantityShipped")
    ] = None

    amount_shipped: Annotated[
        Optional[CreateOrderRefundAmountShipped], pydantic.Field(alias="amountShipped")
    ] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    quantity_refunded: Annotated[
        Optional[int], pydantic.Field(alias="quantityRefunded")
    ] = None

    amount_refunded: Annotated[
        Optional[CreateOrderRefundAmountRefunded],
        pydantic.Field(alias="amountRefunded"),
    ] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    quantity_canceled: Annotated[
        Optional[int], pydantic.Field(alias="quantityCanceled")
    ] = None

    amount_canceled: Annotated[
        Optional[CreateOrderRefundAmountCanceled],
        pydantic.Field(alias="amountCanceled"),
    ] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    shippable_quantity: Annotated[
        Optional[int], pydantic.Field(alias="shippableQuantity")
    ] = None

    refundable_quantity: Annotated[
        Optional[int], pydantic.Field(alias="refundableQuantity")
    ] = None

    cancelable_quantity: Annotated[
        Optional[int], pydantic.Field(alias="cancelableQuantity")
    ] = None

    unit_price: Annotated[
        Optional[CreateOrderRefundUnitPrice], pydantic.Field(alias="unitPrice")
    ] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    total_amount: Annotated[
        Optional[CreateOrderRefundTotalAmount], pydantic.Field(alias="totalAmount")
    ] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    vat_rate: Annotated[Optional[str], pydantic.Field(alias="vatRate")] = None

    vat_amount: Annotated[
        Optional[CreateOrderRefundVatAmount], pydantic.Field(alias="vatAmount")
    ] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    created_at: Annotated[Optional[str], pydantic.Field(alias="createdAt")] = None

    discounted_amount: Annotated[
        Optional[DiscountedAmount], pydantic.Field(alias="discountedAmount")
    ] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "resource",
            "id",
            "orderId",
            "name",
            "sku",
            "type",
            "status",
            "metadata",
            "isCancelable",
            "quantity",
            "quantityShipped",
            "amountShipped",
            "quantityRefunded",
            "amountRefunded",
            "quantityCanceled",
            "amountCanceled",
            "shippableQuantity",
            "refundableQuantity",
            "cancelableQuantity",
            "unitPrice",
            "totalAmount",
            "vatRate",
            "vatAmount",
            "createdAt",
            "discountedAmount",
        ]
        nullable_fields = ["sku", "metadata"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class CreateOrderRefundSelfTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreateOrderRefundSelf(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreateOrderRefundOrderTypedDict(TypedDict):
    r"""The API resource URL of the [order](get-order) that this refund belongs to, if applicable."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreateOrderRefundOrder(BaseModel):
    r"""The API resource URL of the [order](get-order) that this refund belongs to, if applicable."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreateOrderRefundSettlementTypedDict(TypedDict):
    r"""The API resource URL of the [settlement](get-settlement) this refund has been settled with. Not present if not yet settled."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class CreateOrderRefundSettlement(BaseModel):
    r"""The API resource URL of the [settlement](get-settlement) this refund has been settled with. Not present if not yet settled."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class CreateOrderRefundDocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreateOrderRefundDocumentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreateOrderRefundLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: NotRequired[CreateOrderRefundSelfTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    order: NotRequired[CreateOrderRefundOrderTypedDict]
    r"""The API resource URL of the [order](get-order) that this refund belongs to, if applicable."""
    settlement: NotRequired[Nullable[CreateOrderRefundSettlementTypedDict]]
    r"""The API resource URL of the [settlement](get-settlement) this refund has been settled with. Not present if not yet settled."""
    documentation: NotRequired[CreateOrderRefundDocumentationTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class CreateOrderRefundLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[Optional[CreateOrderRefundSelf], pydantic.Field(alias="self")] = (
        None
    )
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    order: Optional[CreateOrderRefundOrder] = None
    r"""The API resource URL of the [order](get-order) that this refund belongs to, if applicable."""

    settlement: OptionalNullable[CreateOrderRefundSettlement] = UNSET
    r"""The API resource URL of the [settlement](get-settlement) this refund has been settled with. Not present if not yet settled."""

    documentation: Optional[CreateOrderRefundDocumentation] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["self", "order", "settlement", "documentation"]
        nullable_fields = ["settlement"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class CreateOrderRefundResponseBodyTypedDict(TypedDict):
    r"""The newly created refund object."""

    resource: NotRequired[str]
    r"""Indicates the response contains a refund object. Will always contain the string `refund` for this endpoint."""
    id: NotRequired[str]
    r"""The identifier uniquely referring to this refund. Mollie assigns this identifier at refund creation time. Mollie will always refer to the refund by this ID. Example: `re_4qqhO89gsT`."""
    mode: NotRequired[str]
    r"""Whether this entity was created in live mode or in test mode.

    Possible values: `live` `test`
    """
    description: NotRequired[str]
    r"""The description of the refund that may be shown to your customer, depending on the payment method used."""
    amount: NotRequired[CreateOrderRefundRefundsResponseAmountTypedDict]
    r"""The amount refunded to your customer with this refund. The amount is allowed to be lower than the original payment amount."""
    settlement_amount: NotRequired[Nullable[CreateOrderRefundSettlementAmountTypedDict]]
    r"""This optional field will contain the approximate amount that will be deducted from your account balance, converted to the currency your account is settled in.

    The amount is a **negative** amount.

    If the refund is not directly processed by Mollie, for example for PayPal refunds, the settlement amount will be zero.

    Since the field contains an estimated amount during refund processing, it may change over time. For example, while the refund is queued the settlement amount is likely not yet available.

    To retrieve accurate settlement amounts we recommend using the [List balance transactions endpoint](list-balance-transactions) instead.
    """
    metadata: NotRequired[Nullable[CreateOrderRefundRefundsResponseMetadataTypedDict]]
    r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB."""
    order_id: NotRequired[str]
    r"""The unique identifier of the order this refund was created for. For example: `ord_8wmqcHMN4U`. Not present if the refund was not created for an order."""
    settlement_id: NotRequired[Nullable[str]]
    r"""The identifier referring to the settlement this refund was settled with. This field is omitted if the refund is not settled (yet)."""
    status: NotRequired[str]
    r"""Refunds may take some time to get confirmed.

    Possible values: `queued` `pending` `processing` `refunded` `failed` `canceled`
    """
    created_at: NotRequired[str]
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""
    external_reference: NotRequired[CreateOrderRefundRefundsExternalReferenceTypedDict]
    lines: NotRequired[List[CreateOrderRefundLinesOutputTypedDict]]
    r"""A refund can optionally be linked to specific order lines.

    The lines will show the `quantity`, `discountAmount`, `vatAmount`, and `totalAmount` refunded. If the line was partially refunded, these values will be different from the values in response from the [Get payment](get-payment) endpoint.
    """
    links: NotRequired[CreateOrderRefundLinksTypedDict]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""


class CreateOrderRefundResponseBody(BaseModel):
    r"""The newly created refund object."""

    resource: Optional[str] = "refund"
    r"""Indicates the response contains a refund object. Will always contain the string `refund` for this endpoint."""

    id: Optional[str] = None
    r"""The identifier uniquely referring to this refund. Mollie assigns this identifier at refund creation time. Mollie will always refer to the refund by this ID. Example: `re_4qqhO89gsT`."""

    mode: Optional[str] = None
    r"""Whether this entity was created in live mode or in test mode.

    Possible values: `live` `test`
    """

    description: Optional[str] = None
    r"""The description of the refund that may be shown to your customer, depending on the payment method used."""

    amount: Optional[CreateOrderRefundRefundsResponseAmount] = None
    r"""The amount refunded to your customer with this refund. The amount is allowed to be lower than the original payment amount."""

    settlement_amount: Annotated[
        OptionalNullable[CreateOrderRefundSettlementAmount],
        pydantic.Field(alias="settlementAmount"),
    ] = UNSET
    r"""This optional field will contain the approximate amount that will be deducted from your account balance, converted to the currency your account is settled in.

    The amount is a **negative** amount.

    If the refund is not directly processed by Mollie, for example for PayPal refunds, the settlement amount will be zero.

    Since the field contains an estimated amount during refund processing, it may change over time. For example, while the refund is queued the settlement amount is likely not yet available.

    To retrieve accurate settlement amounts we recommend using the [List balance transactions endpoint](list-balance-transactions) instead.
    """

    metadata: OptionalNullable[CreateOrderRefundRefundsResponseMetadata] = UNSET
    r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB."""

    order_id: Annotated[Optional[str], pydantic.Field(alias="orderId")] = None
    r"""The unique identifier of the order this refund was created for. For example: `ord_8wmqcHMN4U`. Not present if the refund was not created for an order."""

    settlement_id: Annotated[
        OptionalNullable[str], pydantic.Field(alias="settlementId")
    ] = UNSET
    r"""The identifier referring to the settlement this refund was settled with. This field is omitted if the refund is not settled (yet)."""

    status: Optional[str] = None
    r"""Refunds may take some time to get confirmed.

    Possible values: `queued` `pending` `processing` `refunded` `failed` `canceled`
    """

    created_at: Annotated[Optional[str], pydantic.Field(alias="createdAt")] = None
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""

    external_reference: Annotated[
        Optional[CreateOrderRefundRefundsExternalReference],
        pydantic.Field(alias="externalReference"),
    ] = None

    lines: Optional[List[CreateOrderRefundLinesOutput]] = None
    r"""A refund can optionally be linked to specific order lines.

    The lines will show the `quantity`, `discountAmount`, `vatAmount`, and `totalAmount` refunded. If the line was partially refunded, these values will be different from the values in response from the [Get payment](get-payment) endpoint.
    """

    links: Annotated[
        Optional[CreateOrderRefundLinks], pydantic.Field(alias="_links")
    ] = None
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "resource",
            "id",
            "mode",
            "description",
            "amount",
            "settlementAmount",
            "metadata",
            "orderId",
            "settlementId",
            "status",
            "createdAt",
            "externalReference",
            "lines",
            "_links",
        ]
        nullable_fields = ["settlementAmount", "metadata", "settlementId"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
