"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from mollie import utils
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import FieldMetadata, PathParamMetadata, QueryParamMetadata
import pydantic
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ListMandatesRequestTypedDict(TypedDict):
    customer_id: str
    r"""Provide the ID of the related customer."""
    from_: NotRequired[str]
    r"""Provide an ID to start the result set from the item with the given ID and onwards. This allows you to paginate the result set."""
    limit: NotRequired[Nullable[int]]
    r"""The maximum number of items to return. Defaults to 50 items."""
    sort: NotRequired[Nullable[str]]
    r"""Used for setting the direction of the result set. Defaults to descending order, meaning the results are ordered from newest to oldest.

    Possible values: `asc` `desc` (default: `desc`)
    """
    testmode: NotRequired[Nullable[bool]]
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """


class ListMandatesRequest(BaseModel):
    customer_id: Annotated[
        str,
        pydantic.Field(alias="customerId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""Provide the ID of the related customer."""

    from_: Annotated[
        Optional[str],
        pydantic.Field(alias="from"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Provide an ID to start the result set from the item with the given ID and onwards. This allows you to paginate the result set."""

    limit: Annotated[
        OptionalNullable[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 50
    r"""The maximum number of items to return. Defaults to 50 items."""

    sort: Annotated[
        OptionalNullable[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Used for setting the direction of the result set. Defaults to descending order, meaning the results are ordered from newest to oldest.

    Possible values: `asc` `desc` (default: `desc`)
    """

    testmode: Annotated[
        OptionalNullable[bool],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["from", "limit", "sort", "testmode"]
        nullable_fields = ["limit", "sort", "testmode"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListMandatesMandatesResponseDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str
    type: str


class ListMandatesMandatesResponseDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str

    type: str


class ListMandatesMandatesResponseLinksTypedDict(TypedDict):
    documentation: ListMandatesMandatesResponseDocumentationTypedDict
    r"""The URL to the generic Mollie API error handling guide."""


class ListMandatesMandatesResponseLinks(BaseModel):
    documentation: ListMandatesMandatesResponseDocumentation
    r"""The URL to the generic Mollie API error handling guide."""


class ListMandatesMandatesResponseResponseBodyData(BaseModel):
    status: int
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: str
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: str
    r"""A detailed human-readable description of the error that occurred."""

    links: Annotated[ListMandatesMandatesResponseLinks, pydantic.Field(alias="_links")]


class ListMandatesMandatesResponseResponseBody(Exception):
    r"""An error response object."""

    data: ListMandatesMandatesResponseResponseBodyData

    def __init__(self, data: ListMandatesMandatesResponseResponseBodyData):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(
            self.data, ListMandatesMandatesResponseResponseBodyData
        )


class ListMandatesMandatesDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str
    type: str


class ListMandatesMandatesDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str

    type: str


class ListMandatesMandatesLinksTypedDict(TypedDict):
    documentation: ListMandatesMandatesDocumentationTypedDict
    r"""The URL to the generic Mollie API error handling guide."""


class ListMandatesMandatesLinks(BaseModel):
    documentation: ListMandatesMandatesDocumentation
    r"""The URL to the generic Mollie API error handling guide."""


class ListMandatesMandatesResponseBodyData(BaseModel):
    status: int
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: str
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: str
    r"""A detailed human-readable description of the error that occurred."""

    field: str
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name of the field that caused the issue."""

    links: Annotated[ListMandatesMandatesLinks, pydantic.Field(alias="_links")]


class ListMandatesMandatesResponseBody(Exception):
    r"""An error response object."""

    data: ListMandatesMandatesResponseBodyData

    def __init__(self, data: ListMandatesMandatesResponseBodyData):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(self.data, ListMandatesMandatesResponseBodyData)


class ListMandatesDetailsTypedDict(TypedDict):
    consumer_name: NotRequired[Nullable[str]]
    r"""The customer's name. Available for SEPA Direct Debit and PayPal mandates."""
    consumer_account: NotRequired[Nullable[str]]
    r"""The customer's IBAN or email address. Available for SEPA Direct Debit and PayPal mandates."""
    consumer_bic: NotRequired[Nullable[str]]
    r"""The BIC of the customer's bank. Available for SEPA Direct Debit mandates."""
    card_holder: NotRequired[Nullable[str]]
    r"""The card holder's name. Available for card mandates."""
    card_number: NotRequired[Nullable[str]]
    r"""The last four digits of the card number. Available for card mandates."""
    card_expiry_date: NotRequired[Nullable[str]]
    r"""The card's expiry date in `YYYY-MM-DD` format. Available for card mandates."""
    card_label: NotRequired[Nullable[str]]
    r"""The card's label. Available for card mandates, if the card label could be detected.

    Possible values: `American Express` `Carta Si` `Carte Bleue` `Dankort` `Diners Club` `Discover` `JCB` `Laser` `Maestro` `Mastercard` `Unionpay` `Visa`
    """
    card_fingerprint: NotRequired[Nullable[str]]
    r"""Unique alphanumeric representation of this specific card. Available for card mandates. Can be used to identify returning customers."""


class ListMandatesDetails(BaseModel):
    consumer_name: Annotated[
        OptionalNullable[str], pydantic.Field(alias="consumerName")
    ] = UNSET
    r"""The customer's name. Available for SEPA Direct Debit and PayPal mandates."""

    consumer_account: Annotated[
        OptionalNullable[str], pydantic.Field(alias="consumerAccount")
    ] = UNSET
    r"""The customer's IBAN or email address. Available for SEPA Direct Debit and PayPal mandates."""

    consumer_bic: Annotated[
        OptionalNullable[str], pydantic.Field(alias="consumerBic")
    ] = UNSET
    r"""The BIC of the customer's bank. Available for SEPA Direct Debit mandates."""

    card_holder: Annotated[
        OptionalNullable[str], pydantic.Field(alias="cardHolder")
    ] = UNSET
    r"""The card holder's name. Available for card mandates."""

    card_number: Annotated[
        OptionalNullable[str], pydantic.Field(alias="cardNumber")
    ] = UNSET
    r"""The last four digits of the card number. Available for card mandates."""

    card_expiry_date: Annotated[
        OptionalNullable[str], pydantic.Field(alias="cardExpiryDate")
    ] = UNSET
    r"""The card's expiry date in `YYYY-MM-DD` format. Available for card mandates."""

    card_label: Annotated[OptionalNullable[str], pydantic.Field(alias="cardLabel")] = (
        UNSET
    )
    r"""The card's label. Available for card mandates, if the card label could be detected.

    Possible values: `American Express` `Carta Si` `Carte Bleue` `Dankort` `Diners Club` `Discover` `JCB` `Laser` `Maestro` `Mastercard` `Unionpay` `Visa`
    """

    card_fingerprint: Annotated[
        OptionalNullable[str], pydantic.Field(alias="cardFingerprint")
    ] = UNSET
    r"""Unique alphanumeric representation of this specific card. Available for card mandates. Can be used to identify returning customers."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "consumerName",
            "consumerAccount",
            "consumerBic",
            "cardHolder",
            "cardNumber",
            "cardExpiryDate",
            "cardLabel",
            "cardFingerprint",
        ]
        nullable_fields = [
            "consumerName",
            "consumerAccount",
            "consumerBic",
            "cardHolder",
            "cardNumber",
            "cardExpiryDate",
            "cardLabel",
            "cardFingerprint",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListMandatesMandatesSelfTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListMandatesMandatesSelf(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListMandatesCustomerTypedDict(TypedDict):
    r"""The API resource URL of the [customer](get-customer) that this mandate belongs to."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListMandatesCustomer(BaseModel):
    r"""The API resource URL of the [customer](get-customer) that this mandate belongs to."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListMandatesMandatesResponse200DocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListMandatesMandatesResponse200Documentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListMandatesMandatesResponse200LinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: NotRequired[ListMandatesMandatesSelfTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    customer: NotRequired[ListMandatesCustomerTypedDict]
    r"""The API resource URL of the [customer](get-customer) that this mandate belongs to."""
    documentation: NotRequired[ListMandatesMandatesResponse200DocumentationTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class ListMandatesMandatesResponse200Links(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[
        Optional[ListMandatesMandatesSelf], pydantic.Field(alias="self")
    ] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    customer: Optional[ListMandatesCustomer] = None
    r"""The API resource URL of the [customer](get-customer) that this mandate belongs to."""

    documentation: Optional[ListMandatesMandatesResponse200Documentation] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class ListMandatesMandatesTypedDict(TypedDict):
    resource: NotRequired[str]
    r"""Indicates the response contains a mandate object. Will always contain the string `mandate` for this endpoint."""
    id: NotRequired[str]
    r"""The identifier uniquely referring to this mandate. Example: `mdt_pWUnw6pkBN`."""
    mode: NotRequired[str]
    r"""Whether this entity was created in live mode or in test mode.

    Possible values: `live` `test`
    """
    method: NotRequired[str]
    r"""Payment method of the mandate.

    SEPA Direct Debit and PayPal mandates can be created directly.

    Possible values: `creditcard` `directdebit` `paypal`
    """
    details: NotRequired[ListMandatesDetailsTypedDict]
    signature_date: NotRequired[Nullable[str]]
    r"""The date when the mandate was signed in `YYYY-MM-DD` format."""
    mandate_reference: NotRequired[Nullable[str]]
    r"""A custom mandate reference. For SEPA Direct Debit, it is vital to provide a unique reference. Some banks will decline Direct Debit payments if the mandate reference is not unique."""
    status: NotRequired[str]
    r"""The status of the mandate. A status can be `pending` for mandates when the first payment is not yet finalized, or when we did not received the IBAN yet from the first payment.

    Possible values: `valid` `pending` `invalid`
    """
    customer_id: NotRequired[str]
    r"""The identifier referring to the [customer](get-customer) this mandate was linked to."""
    created_at: NotRequired[str]
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""
    links: NotRequired[ListMandatesMandatesResponse200LinksTypedDict]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""


class ListMandatesMandates(BaseModel):
    resource: Optional[str] = "mandate"
    r"""Indicates the response contains a mandate object. Will always contain the string `mandate` for this endpoint."""

    id: Optional[str] = None
    r"""The identifier uniquely referring to this mandate. Example: `mdt_pWUnw6pkBN`."""

    mode: Optional[str] = None
    r"""Whether this entity was created in live mode or in test mode.

    Possible values: `live` `test`
    """

    method: Optional[str] = None
    r"""Payment method of the mandate.

    SEPA Direct Debit and PayPal mandates can be created directly.

    Possible values: `creditcard` `directdebit` `paypal`
    """

    details: Optional[ListMandatesDetails] = None

    signature_date: Annotated[
        OptionalNullable[str], pydantic.Field(alias="signatureDate")
    ] = UNSET
    r"""The date when the mandate was signed in `YYYY-MM-DD` format."""

    mandate_reference: Annotated[
        OptionalNullable[str], pydantic.Field(alias="mandateReference")
    ] = UNSET
    r"""A custom mandate reference. For SEPA Direct Debit, it is vital to provide a unique reference. Some banks will decline Direct Debit payments if the mandate reference is not unique."""

    status: Optional[str] = None
    r"""The status of the mandate. A status can be `pending` for mandates when the first payment is not yet finalized, or when we did not received the IBAN yet from the first payment.

    Possible values: `valid` `pending` `invalid`
    """

    customer_id: Annotated[Optional[str], pydantic.Field(alias="customerId")] = None
    r"""The identifier referring to the [customer](get-customer) this mandate was linked to."""

    created_at: Annotated[Optional[str], pydantic.Field(alias="createdAt")] = None
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""

    links: Annotated[
        Optional[ListMandatesMandatesResponse200Links], pydantic.Field(alias="_links")
    ] = None
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "resource",
            "id",
            "mode",
            "method",
            "details",
            "signatureDate",
            "mandateReference",
            "status",
            "customerId",
            "createdAt",
            "_links",
        ]
        nullable_fields = ["signatureDate", "mandateReference"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListMandatesEmbeddedTypedDict(TypedDict):
    mandates: NotRequired[List[ListMandatesMandatesTypedDict]]
    r"""An array of mandate objects."""


class ListMandatesEmbedded(BaseModel):
    mandates: Optional[List[ListMandatesMandates]] = None
    r"""An array of mandate objects."""


class ListMandatesSelfTypedDict(TypedDict):
    r"""The URL to the current set of items."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListMandatesSelf(BaseModel):
    r"""The URL to the current set of items."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListMandatesPreviousTypedDict(TypedDict):
    r"""The previous set of items, if available."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class ListMandatesPrevious(BaseModel):
    r"""The previous set of items, if available."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class ListMandatesNextTypedDict(TypedDict):
    r"""The next set of items, if available."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class ListMandatesNext(BaseModel):
    r"""The next set of items, if available."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class ListMandatesDocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListMandatesDocumentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListMandatesLinksTypedDict(TypedDict):
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""

    self_: NotRequired[ListMandatesSelfTypedDict]
    r"""The URL to the current set of items."""
    previous: NotRequired[Nullable[ListMandatesPreviousTypedDict]]
    r"""The previous set of items, if available."""
    next: NotRequired[Nullable[ListMandatesNextTypedDict]]
    r"""The next set of items, if available."""
    documentation: NotRequired[ListMandatesDocumentationTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class ListMandatesLinks(BaseModel):
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[Optional[ListMandatesSelf], pydantic.Field(alias="self")] = None
    r"""The URL to the current set of items."""

    previous: OptionalNullable[ListMandatesPrevious] = UNSET
    r"""The previous set of items, if available."""

    next: OptionalNullable[ListMandatesNext] = UNSET
    r"""The next set of items, if available."""

    documentation: Optional[ListMandatesDocumentation] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["self", "previous", "next", "documentation"]
        nullable_fields = ["previous", "next"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListMandatesResponseBodyTypedDict(TypedDict):
    r"""A list of mandate objects."""

    count: NotRequired[int]
    r"""The number of items in this result set. If more items are available, a `_links.next` URL will be present in the result as well.

    The maximum number of items per result set is controlled by the `limit` property provided in the request. The default limit is 50 items.
    """
    embedded: NotRequired[ListMandatesEmbeddedTypedDict]
    links: NotRequired[ListMandatesLinksTypedDict]
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""


class ListMandatesResponseBody(BaseModel):
    r"""A list of mandate objects."""

    count: Optional[int] = None
    r"""The number of items in this result set. If more items are available, a `_links.next` URL will be present in the result as well.

    The maximum number of items per result set is controlled by the `limit` property provided in the request. The default limit is 50 items.
    """

    embedded: Annotated[
        Optional[ListMandatesEmbedded], pydantic.Field(alias="_embedded")
    ] = None

    links: Annotated[Optional[ListMandatesLinks], pydantic.Field(alias="_links")] = None
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""
