"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
from mollie import utils
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import FieldMetadata, PathParamMetadata, QueryParamMetadata
import pydantic
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class GetClientRequestTypedDict(TypedDict):
    id: str
    r"""Provide the ID of the item you want to perform this operation on."""
    embed: NotRequired[Nullable[str]]
    r"""This endpoint allows embedding related API items by appending the following values via the `embed` query string parameter.

    * `organization`: Include the organization of the client. Available for `signuplink` partners, or for `oauth` partners with the `organizations.read` scope.
    * `onboarding`: Include the onboarding status of the client. Available for `signuplink` partners, or for `oauth` partners with the `onboarding.read` scope.
    * `capabilities`: Include the [capabilities](list-capabilities) of the client organization. Available for *oauth* partners with the `onboarding.read` scope.
    """


class GetClientRequest(BaseModel):
    id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""Provide the ID of the item you want to perform this operation on."""

    embed: Annotated[
        OptionalNullable[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""This endpoint allows embedding related API items by appending the following values via the `embed` query string parameter.

    * `organization`: Include the organization of the client. Available for `signuplink` partners, or for `oauth` partners with the `organizations.read` scope.
    * `onboarding`: Include the onboarding status of the client. Available for `signuplink` partners, or for `oauth` partners with the `onboarding.read` scope.
    * `capabilities`: Include the [capabilities](list-capabilities) of the client organization. Available for *oauth* partners with the `onboarding.read` scope.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["embed"]
        nullable_fields = ["embed"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetClientClientsDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str
    type: str


class GetClientClientsDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str

    type: str


class GetClientClientsLinksTypedDict(TypedDict):
    documentation: GetClientClientsDocumentationTypedDict
    r"""The URL to the generic Mollie API error handling guide."""


class GetClientClientsLinks(BaseModel):
    documentation: GetClientClientsDocumentation
    r"""The URL to the generic Mollie API error handling guide."""


class GetClientClientsResponseBodyData(BaseModel):
    status: int
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: str
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: str
    r"""A detailed human-readable description of the error that occurred."""

    links: Annotated[GetClientClientsLinks, pydantic.Field(alias="_links")]

    field: Optional[str] = None
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name of the field that caused the issue."""


class GetClientClientsResponseBody(Exception):
    r"""An error response object."""

    data: GetClientClientsResponseBodyData

    def __init__(self, data: GetClientClientsResponseBodyData):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(self.data, GetClientClientsResponseBodyData)


class CommissionTypedDict(TypedDict):
    r"""The commission object."""

    count: NotRequired[int]
    r"""The commission count."""


class Commission(BaseModel):
    r"""The commission object."""

    count: Optional[int] = None
    r"""The commission count."""


class GetClientSelfTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetClientSelf(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetClientOrganizationTypedDict(TypedDict):
    r"""The API resource URL of the client's organization."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetClientOrganization(BaseModel):
    r"""The API resource URL of the client's organization."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetClientClientsOnboardingTypedDict(TypedDict):
    r"""The API resource URL of the client's onboarding status."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetClientClientsOnboarding(BaseModel):
    r"""The API resource URL of the client's onboarding status."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetClientDocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetClientDocumentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetClientLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: NotRequired[GetClientSelfTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    organization: NotRequired[GetClientOrganizationTypedDict]
    r"""The API resource URL of the client's organization."""
    onboarding: NotRequired[GetClientClientsOnboardingTypedDict]
    r"""The API resource URL of the client's onboarding status."""
    documentation: NotRequired[GetClientDocumentationTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class GetClientLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[Optional[GetClientSelf], pydantic.Field(alias="self")] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    organization: Optional[GetClientOrganization] = None
    r"""The API resource URL of the client's organization."""

    onboarding: Optional[GetClientClientsOnboarding] = None
    r"""The API resource URL of the client's onboarding status."""

    documentation: Optional[GetClientDocumentation] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class GetClientAddressTypedDict(TypedDict):
    r"""The address of the organization."""

    street_and_number: NotRequired[str]
    r"""A street and street number."""
    postal_code: NotRequired[str]
    r"""A postal code. This field may be required if the provided country has a postal code system."""
    city: NotRequired[str]
    country: NotRequired[str]
    r"""A country code in [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) format."""


class GetClientAddress(BaseModel):
    r"""The address of the organization."""

    street_and_number: Annotated[
        Optional[str], pydantic.Field(alias="streetAndNumber")
    ] = None
    r"""A street and street number."""

    postal_code: Annotated[Optional[str], pydantic.Field(alias="postalCode")] = None
    r"""A postal code. This field may be required if the provided country has a postal code system."""

    city: Optional[str] = None

    country: Optional[str] = None
    r"""A country code in [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) format."""


class GetClientClientsSelfTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetClientClientsSelf(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetClientDashboardTypedDict(TypedDict):
    r"""Direct link to the organization's Mollie dashboard."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetClientDashboard(BaseModel):
    r"""Direct link to the organization's Mollie dashboard."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetClientClientsResponse200DocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetClientClientsResponse200Documentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetClientClientsResponse200LinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: NotRequired[GetClientClientsSelfTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    dashboard: NotRequired[GetClientDashboardTypedDict]
    r"""Direct link to the organization's Mollie dashboard."""
    documentation: NotRequired[GetClientClientsResponse200DocumentationTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class GetClientClientsResponse200Links(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[Optional[GetClientClientsSelf], pydantic.Field(alias="self")] = (
        None
    )
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    dashboard: Optional[GetClientDashboard] = None
    r"""Direct link to the organization's Mollie dashboard."""

    documentation: Optional[GetClientClientsResponse200Documentation] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class GetClientClientsOrganizationTypedDict(TypedDict):
    resource: NotRequired[str]
    r"""Indicates the response contains an organization object. Will always contain the string `organization` for this resource type."""
    id: NotRequired[str]
    r"""The identifier uniquely referring to this organization. Example: `org_12345678`."""
    name: NotRequired[str]
    r"""The name of the organization."""
    email: NotRequired[str]
    r"""The email address associated with the organization."""
    locale: NotRequired[str]
    r"""The preferred locale of the merchant, as set in their Mollie dashboard."""
    address: NotRequired[GetClientAddressTypedDict]
    r"""The address of the organization."""
    registration_number: NotRequired[str]
    r"""The registration number of the organization at their local chamber of commerce."""
    vat_number: NotRequired[Nullable[str]]
    r"""The VAT number of the organization, if based in the European Union or in The United Kingdom. VAT numbers are verified against the international registry *VIES*.

    The field is not present for merchants residing in other countries.
    """
    vat_regulation: NotRequired[Nullable[str]]
    r"""Mollie applies Dutch VAT for merchants based in The Netherlands, British VAT for merchants based in The United Kingdom, and shifted VAT for merchants in the European Union.

    The field is not present for merchants residing in other countries.

    Possible values: `dutch` `british` `shifted`
    """
    links: NotRequired[GetClientClientsResponse200LinksTypedDict]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""


class GetClientClientsOrganization(BaseModel):
    resource: Optional[str] = "organization"
    r"""Indicates the response contains an organization object. Will always contain the string `organization` for this resource type."""

    id: Optional[str] = None
    r"""The identifier uniquely referring to this organization. Example: `org_12345678`."""

    name: Optional[str] = None
    r"""The name of the organization."""

    email: Optional[str] = None
    r"""The email address associated with the organization."""

    locale: Optional[str] = None
    r"""The preferred locale of the merchant, as set in their Mollie dashboard."""

    address: Optional[GetClientAddress] = None
    r"""The address of the organization."""

    registration_number: Annotated[
        Optional[str], pydantic.Field(alias="registrationNumber")
    ] = None
    r"""The registration number of the organization at their local chamber of commerce."""

    vat_number: Annotated[OptionalNullable[str], pydantic.Field(alias="vatNumber")] = (
        UNSET
    )
    r"""The VAT number of the organization, if based in the European Union or in The United Kingdom. VAT numbers are verified against the international registry *VIES*.

    The field is not present for merchants residing in other countries.
    """

    vat_regulation: Annotated[
        OptionalNullable[str], pydantic.Field(alias="vatRegulation")
    ] = UNSET
    r"""Mollie applies Dutch VAT for merchants based in The Netherlands, British VAT for merchants based in The United Kingdom, and shifted VAT for merchants in the European Union.

    The field is not present for merchants residing in other countries.

    Possible values: `dutch` `british` `shifted`
    """

    links: Annotated[
        Optional[GetClientClientsResponse200Links], pydantic.Field(alias="_links")
    ] = None
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "resource",
            "id",
            "name",
            "email",
            "locale",
            "address",
            "registrationNumber",
            "vatNumber",
            "vatRegulation",
            "_links",
        ]
        nullable_fields = ["vatNumber", "vatRegulation"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetClientClientsResponseSelfTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetClientClientsResponseSelf(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetClientClientsDashboardTypedDict(TypedDict):
    r"""Direct link to the onboarding process in the Mollie dashboard. The merchant can be redirected to this page to complete their onboarding."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetClientClientsDashboard(BaseModel):
    r"""Direct link to the onboarding process in the Mollie dashboard. The merchant can be redirected to this page to complete their onboarding."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetClientClientsResponseOrganizationTypedDict(TypedDict):
    r"""The API resource URL of the organization."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetClientClientsResponseOrganization(BaseModel):
    r"""The API resource URL of the organization."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetClientClientsResponseDocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetClientClientsResponseDocumentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetClientClientsResponseLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: NotRequired[GetClientClientsResponseSelfTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    dashboard: NotRequired[GetClientClientsDashboardTypedDict]
    r"""Direct link to the onboarding process in the Mollie dashboard. The merchant can be redirected to this page to complete their onboarding."""
    organization: NotRequired[GetClientClientsResponseOrganizationTypedDict]
    r"""The API resource URL of the organization."""
    documentation: NotRequired[GetClientClientsResponseDocumentationTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class GetClientClientsResponseLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[
        Optional[GetClientClientsResponseSelf], pydantic.Field(alias="self")
    ] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    dashboard: Optional[GetClientClientsDashboard] = None
    r"""Direct link to the onboarding process in the Mollie dashboard. The merchant can be redirected to this page to complete their onboarding."""

    organization: Optional[GetClientClientsResponseOrganization] = None
    r"""The API resource URL of the organization."""

    documentation: Optional[GetClientClientsResponseDocumentation] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class GetClientOnboardingTypedDict(TypedDict):
    resource: NotRequired[str]
    r"""Indicates the response contains an onboarding status object. Will always contain the string `onboarding` for this resource type."""
    name: NotRequired[str]
    r"""The name of the organization."""
    status: NotRequired[str]
    r"""The current status of the organization's onboarding process.

    * `needs-data` — The merchant needs to provide additional information
    * `in-review` — The merchant provided all information, awaiting review from Mollie
    * `completed` — The onboarding is completed

    Possible values: `needs-data` `in-review` `completed`
    """
    can_receive_payments: NotRequired[bool]
    r"""Whether the organization can receive payments."""
    can_receive_settlements: NotRequired[bool]
    r"""Whether the organization can receive settlements to their external bank account."""
    signed_up_at: NotRequired[str]
    r"""The sign up date time of the organization in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""
    links: NotRequired[GetClientClientsResponseLinksTypedDict]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""


class GetClientOnboarding(BaseModel):
    resource: Optional[str] = "onboarding"
    r"""Indicates the response contains an onboarding status object. Will always contain the string `onboarding` for this resource type."""

    name: Optional[str] = None
    r"""The name of the organization."""

    status: Optional[str] = None
    r"""The current status of the organization's onboarding process.

    * `needs-data` — The merchant needs to provide additional information
    * `in-review` — The merchant provided all information, awaiting review from Mollie
    * `completed` — The onboarding is completed

    Possible values: `needs-data` `in-review` `completed`
    """

    can_receive_payments: Annotated[
        Optional[bool], pydantic.Field(alias="canReceivePayments")
    ] = None
    r"""Whether the organization can receive payments."""

    can_receive_settlements: Annotated[
        Optional[bool], pydantic.Field(alias="canReceiveSettlements")
    ] = None
    r"""Whether the organization can receive settlements to their external bank account."""

    signed_up_at: Annotated[Optional[str], pydantic.Field(alias="signedUpAt")] = None
    r"""The sign up date time of the organization in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""

    links: Annotated[
        Optional[GetClientClientsResponseLinks], pydantic.Field(alias="_links")
    ] = None
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""


class GetClientStatus(str, Enum):
    UNREQUESTED = "unrequested"
    ENABLED = "enabled"
    DISABLED = "disabled"
    PENDING = "pending"


class GetClientStatusReason(str, Enum):
    REQUIREMENT_PAST_DUE = "requirement-past-due"
    ONBOARDING_INFORMATION_NEEDED = "onboarding-information-needed"


class GetClientClientsResponseDashboardTypedDict(TypedDict):
    r"""If known, a deep link to the Mollie dashboard of the client, where the requirement can be fulfilled. For example, where necessary documents are to be uploaded."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class GetClientClientsResponseDashboard(BaseModel):
    r"""If known, a deep link to the Mollie dashboard of the client, where the requirement can be fulfilled. For example, where necessary documents are to be uploaded."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class GetClientClientsResponse200ApplicationHalPlusJSONLinksTypedDict(TypedDict):
    dashboard: NotRequired[GetClientClientsResponseDashboardTypedDict]
    r"""If known, a deep link to the Mollie dashboard of the client, where the requirement can be fulfilled. For example, where necessary documents are to be uploaded."""


class GetClientClientsResponse200ApplicationHalPlusJSONLinks(BaseModel):
    dashboard: Optional[GetClientClientsResponseDashboard] = None
    r"""If known, a deep link to the Mollie dashboard of the client, where the requirement can be fulfilled. For example, where necessary documents are to be uploaded."""


class GetClientRequirementsTypedDict(TypedDict):
    id: NotRequired[str]
    r"""The name of this requirement, referring to the task to be fulfilled by the organization to enable or re-enable the capability. The name is unique among other requirements of the same capability."""
    status: NotRequired[str]
    r"""The status of the requirement depends on its due date. If no due date is given, the status will be `requested`.

    Possible values: `currently-due` `past-due` `requested`
    """
    due_date: NotRequired[Nullable[str]]
    r"""Due date until the requirement must be fulfilled, if any. The date is shown in ISO-8601 format."""
    links: NotRequired[GetClientClientsResponse200ApplicationHalPlusJSONLinksTypedDict]


class GetClientRequirements(BaseModel):
    id: Optional[str] = None
    r"""The name of this requirement, referring to the task to be fulfilled by the organization to enable or re-enable the capability. The name is unique among other requirements of the same capability."""

    status: Optional[str] = None
    r"""The status of the requirement depends on its due date. If no due date is given, the status will be `requested`.

    Possible values: `currently-due` `past-due` `requested`
    """

    due_date: Annotated[OptionalNullable[str], pydantic.Field(alias="dueDate")] = UNSET
    r"""Due date until the requirement must be fulfilled, if any. The date is shown in ISO-8601 format."""

    links: Annotated[
        Optional[GetClientClientsResponse200ApplicationHalPlusJSONLinks],
        pydantic.Field(alias="_links"),
    ] = None

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "status", "dueDate", "_links"]
        nullable_fields = ["dueDate"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetClientCapabilitiesTypedDict(TypedDict):
    resource: NotRequired[str]
    r"""Always the word `capability` for this resource type."""
    name: NotRequired[str]
    r"""A unique name for this capability like `payments` / `settlements`."""
    status: NotRequired[GetClientStatus]
    status_reason: NotRequired[Nullable[GetClientStatusReason]]
    requirements: NotRequired[List[GetClientRequirementsTypedDict]]


class GetClientCapabilities(BaseModel):
    resource: Optional[str] = None
    r"""Always the word `capability` for this resource type."""

    name: Optional[str] = None
    r"""A unique name for this capability like `payments` / `settlements`."""

    status: Optional[GetClientStatus] = None

    status_reason: Annotated[
        OptionalNullable[GetClientStatusReason], pydantic.Field(alias="statusReason")
    ] = UNSET

    requirements: Optional[List[GetClientRequirements]] = None

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["resource", "name", "status", "statusReason", "requirements"]
        nullable_fields = ["statusReason"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetClientEmbeddedTypedDict(TypedDict):
    organization: NotRequired[GetClientClientsOrganizationTypedDict]
    onboarding: NotRequired[GetClientOnboardingTypedDict]
    capabilities: NotRequired[GetClientCapabilitiesTypedDict]


class GetClientEmbedded(BaseModel):
    organization: Optional[GetClientClientsOrganization] = None

    onboarding: Optional[GetClientOnboarding] = None

    capabilities: Optional[GetClientCapabilities] = None


class GetClientResponseBodyTypedDict(TypedDict):
    r"""The client object."""

    resource: NotRequired[str]
    r"""Indicates the response contains a client object. Will always contain the string `client` for this resource type."""
    id: NotRequired[str]
    r"""The identifier uniquely referring to this client. Example: `org_12345678`."""
    commission: NotRequired[Nullable[CommissionTypedDict]]
    r"""The commission object."""
    organization_created_at: NotRequired[str]
    r"""The date and time the client organization was created, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""
    links: NotRequired[GetClientLinksTypedDict]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""
    embedded: NotRequired[GetClientEmbeddedTypedDict]


class GetClientResponseBody(BaseModel):
    r"""The client object."""

    resource: Optional[str] = "client"
    r"""Indicates the response contains a client object. Will always contain the string `client` for this resource type."""

    id: Optional[str] = None
    r"""The identifier uniquely referring to this client. Example: `org_12345678`."""

    commission: OptionalNullable[Commission] = UNSET
    r"""The commission object."""

    organization_created_at: Annotated[
        Optional[str], pydantic.Field(alias="organizationCreatedAt")
    ] = None
    r"""The date and time the client organization was created, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""

    links: Annotated[Optional[GetClientLinks], pydantic.Field(alias="_links")] = None
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    embedded: Annotated[
        Optional[GetClientEmbedded], pydantic.Field(alias="_embedded")
    ] = None

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "resource",
            "id",
            "commission",
            "organizationCreatedAt",
            "_links",
            "_embedded",
        ]
        nullable_fields = ["commission"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
