"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from mollie import utils
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import FieldMetadata, PathParamMetadata
import pydantic
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class GetSettlementRequestTypedDict(TypedDict):
    id: str
    r"""Provide the ID of the item you want to perform this operation on."""


class GetSettlementRequest(BaseModel):
    id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""Provide the ID of the item you want to perform this operation on."""


class GetSettlementSettlementsDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str
    type: str


class GetSettlementSettlementsDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str

    type: str


class GetSettlementSettlementsLinksTypedDict(TypedDict):
    documentation: GetSettlementSettlementsDocumentationTypedDict
    r"""The URL to the generic Mollie API error handling guide."""


class GetSettlementSettlementsLinks(BaseModel):
    documentation: GetSettlementSettlementsDocumentation
    r"""The URL to the generic Mollie API error handling guide."""


class GetSettlementSettlementsResponseBodyData(BaseModel):
    status: int
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: str
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: str
    r"""A detailed human-readable description of the error that occurred."""

    links: Annotated[GetSettlementSettlementsLinks, pydantic.Field(alias="_links")]

    field: Optional[str] = None
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name of the field that caused the issue."""


class GetSettlementSettlementsResponseBody(Exception):
    r"""An error response object."""

    data: GetSettlementSettlementsResponseBodyData

    def __init__(self, data: GetSettlementSettlementsResponseBodyData):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(self.data, GetSettlementSettlementsResponseBodyData)


class GetSettlementAmountTypedDict(TypedDict):
    r"""The total amount of the settlement."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GetSettlementAmount(BaseModel):
    r"""The total amount of the settlement."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GetSettlementFixedTypedDict(TypedDict):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GetSettlementFixed(BaseModel):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class PercentageTypedDict(TypedDict):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class Percentage(BaseModel):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class RateTypedDict(TypedDict):
    r"""The service rates, further divided into `fixed` and `percentage` costs."""

    fixed: NotRequired[GetSettlementFixedTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    percentage: NotRequired[PercentageTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""


class Rate(BaseModel):
    r"""The service rates, further divided into `fixed` and `percentage` costs."""

    fixed: Optional[GetSettlementFixed] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    percentage: Optional[Percentage] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""


class AmountNetTypedDict(TypedDict):
    r"""The net total cost, i.e. excluding VAT"""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class AmountNet(BaseModel):
    r"""The net total cost, i.e. excluding VAT"""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class AmountVatTypedDict(TypedDict):
    r"""The applicable VAT"""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class AmountVat(BaseModel):
    r"""The applicable VAT"""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class AmountGrossTypedDict(TypedDict):
    r"""The gross total cost, i.e. including VAT"""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class AmountGross(BaseModel):
    r"""The gross total cost, i.e. including VAT"""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CostsTypedDict(TypedDict):
    description: NotRequired[str]
    r"""A description of the cost subtotal"""
    method: NotRequired[Nullable[str]]
    r"""The payment method, if applicable

    Possible values: `alma` `bacs` `applepay` `bancomatpay` `bancontact` `banktransfer` `belfius` `billie` `bizum` `bitcoin` `blik` `creditcard` `directdebit` `eps` `giftcard` `giropay` `googlepay` `ideal` `in3` `inghomepay` `kbc` `klarnapaylater` `klarnapaynow` `klarnasliceit` `klarna` `mbway` `multibanco` `mybank` `paybybank` `payconiq` `paypal` `paysafecard` `przelewy24` `riverty` `satispay` `podiumcadeaukaart` `pointofsale` `sofort` `swish` `trustly` `twint` `voucher`
    """
    count: NotRequired[int]
    r"""The number of fees"""
    rate: NotRequired[RateTypedDict]
    r"""The service rates, further divided into `fixed` and `percentage` costs."""
    amount_net: NotRequired[AmountNetTypedDict]
    r"""The net total cost, i.e. excluding VAT"""
    amount_vat: NotRequired[AmountVatTypedDict]
    r"""The applicable VAT"""
    amount_gross: NotRequired[AmountGrossTypedDict]
    r"""The gross total cost, i.e. including VAT"""


class Costs(BaseModel):
    description: Optional[str] = None
    r"""A description of the cost subtotal"""

    method: OptionalNullable[str] = UNSET
    r"""The payment method, if applicable

    Possible values: `alma` `bacs` `applepay` `bancomatpay` `bancontact` `banktransfer` `belfius` `billie` `bizum` `bitcoin` `blik` `creditcard` `directdebit` `eps` `giftcard` `giropay` `googlepay` `ideal` `in3` `inghomepay` `kbc` `klarnapaylater` `klarnapaynow` `klarnasliceit` `klarna` `mbway` `multibanco` `mybank` `paybybank` `payconiq` `paypal` `paysafecard` `przelewy24` `riverty` `satispay` `podiumcadeaukaart` `pointofsale` `sofort` `swish` `trustly` `twint` `voucher`
    """

    count: Optional[int] = None
    r"""The number of fees"""

    rate: Optional[Rate] = None
    r"""The service rates, further divided into `fixed` and `percentage` costs."""

    amount_net: Annotated[Optional[AmountNet], pydantic.Field(alias="amountNet")] = None
    r"""The net total cost, i.e. excluding VAT"""

    amount_vat: Annotated[Optional[AmountVat], pydantic.Field(alias="amountVat")] = None
    r"""The applicable VAT"""

    amount_gross: Annotated[
        Optional[AmountGross], pydantic.Field(alias="amountGross")
    ] = None
    r"""The gross total cost, i.e. including VAT"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "description",
            "method",
            "count",
            "rate",
            "amountNet",
            "amountVat",
            "amountGross",
        ]
        nullable_fields = ["method"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetSettlementAmountNetTypedDict(TypedDict):
    r"""The net total of received funds, i.e. excluding VAT"""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GetSettlementAmountNet(BaseModel):
    r"""The net total of received funds, i.e. excluding VAT"""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GetSettlementAmountVatTypedDict(TypedDict):
    r"""The applicable VAT"""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GetSettlementAmountVat(BaseModel):
    r"""The applicable VAT"""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GetSettlementAmountGrossTypedDict(TypedDict):
    r"""The gross total of received funds, i.e. including VAT"""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GetSettlementAmountGross(BaseModel):
    r"""The gross total of received funds, i.e. including VAT"""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class RevenueTypedDict(TypedDict):
    description: NotRequired[str]
    r"""A description of the revenue subtotal"""
    method: NotRequired[Nullable[str]]
    r"""The payment method, if applicable

    Possible values: `alma` `bacs` `applepay` `bancomatpay` `bancontact` `banktransfer` `belfius` `billie` `bizum` `bitcoin` `blik` `creditcard` `directdebit` `eps` `giftcard` `giropay` `googlepay` `ideal` `in3` `inghomepay` `kbc` `klarnapaylater` `klarnapaynow` `klarnasliceit` `klarna` `mbway` `multibanco` `mybank` `paybybank` `payconiq` `paypal` `paysafecard` `przelewy24` `riverty` `satispay` `podiumcadeaukaart` `pointofsale` `sofort` `swish` `trustly` `twint` `voucher`
    """
    count: NotRequired[int]
    r"""The number of payments"""
    amount_net: NotRequired[GetSettlementAmountNetTypedDict]
    r"""The net total of received funds, i.e. excluding VAT"""
    amount_vat: NotRequired[GetSettlementAmountVatTypedDict]
    r"""The applicable VAT"""
    amount_gross: NotRequired[GetSettlementAmountGrossTypedDict]
    r"""The gross total of received funds, i.e. including VAT"""


class Revenue(BaseModel):
    description: Optional[str] = None
    r"""A description of the revenue subtotal"""

    method: OptionalNullable[str] = UNSET
    r"""The payment method, if applicable

    Possible values: `alma` `bacs` `applepay` `bancomatpay` `bancontact` `banktransfer` `belfius` `billie` `bizum` `bitcoin` `blik` `creditcard` `directdebit` `eps` `giftcard` `giropay` `googlepay` `ideal` `in3` `inghomepay` `kbc` `klarnapaylater` `klarnapaynow` `klarnasliceit` `klarna` `mbway` `multibanco` `mybank` `paybybank` `payconiq` `paypal` `paysafecard` `przelewy24` `riverty` `satispay` `podiumcadeaukaart` `pointofsale` `sofort` `swish` `trustly` `twint` `voucher`
    """

    count: Optional[int] = None
    r"""The number of payments"""

    amount_net: Annotated[
        Optional[GetSettlementAmountNet], pydantic.Field(alias="amountNet")
    ] = None
    r"""The net total of received funds, i.e. excluding VAT"""

    amount_vat: Annotated[
        Optional[GetSettlementAmountVat], pydantic.Field(alias="amountVat")
    ] = None
    r"""The applicable VAT"""

    amount_gross: Annotated[
        Optional[GetSettlementAmountGross], pydantic.Field(alias="amountGross")
    ] = None
    r"""The gross total of received funds, i.e. including VAT"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "description",
            "method",
            "count",
            "amountNet",
            "amountVat",
            "amountGross",
        ]
        nullable_fields = ["method"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class LessThanMonthGreaterThanTypedDict(TypedDict):
    costs: NotRequired[List[CostsTypedDict]]
    r"""An array of cost objects, describing the fees withheld for each payment method during this period."""
    revenue: NotRequired[List[RevenueTypedDict]]
    r"""An array of revenue objects containing the total revenue for each payment method during this period."""
    invoice_id: NotRequired[Nullable[str]]
    r"""The ID of the invoice created for this period, if the invoice has been created already."""
    invoice_reference: NotRequired[Nullable[str]]
    r"""The invoice reference, if the invoice has been created already."""


class LessThanMonthGreaterThan(BaseModel):
    costs: Optional[List[Costs]] = None
    r"""An array of cost objects, describing the fees withheld for each payment method during this period."""

    revenue: Optional[List[Revenue]] = None
    r"""An array of revenue objects containing the total revenue for each payment method during this period."""

    invoice_id: Annotated[OptionalNullable[str], pydantic.Field(alias="invoiceId")] = (
        UNSET
    )
    r"""The ID of the invoice created for this period, if the invoice has been created already."""

    invoice_reference: Annotated[
        OptionalNullable[str], pydantic.Field(alias="invoiceReference")
    ] = UNSET
    r"""The invoice reference, if the invoice has been created already."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["costs", "revenue", "invoiceId", "invoiceReference"]
        nullable_fields = ["invoiceId", "invoiceReference"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class LessThanYearGreaterThanTypedDict(TypedDict):
    less_than_month_greater_than: NotRequired[LessThanMonthGreaterThanTypedDict]


class LessThanYearGreaterThan(BaseModel):
    less_than_month_greater_than: Annotated[
        Optional[LessThanMonthGreaterThan], pydantic.Field(alias="<month>")
    ] = None


class PeriodsTypedDict(TypedDict):
    r"""For bookkeeping purposes, the settlement includes an overview of transactions included in the settlement. These transactions are grouped into 'period' objects — one for each calendar month.

    For example, if a settlement includes funds from 15 April until 4 May, it will include two period objects. One for all transactions processed between 15 April and 30 April, and one for all transactions between 1 May and 4 May.

    Period objects are grouped by year, and then by month. So in the above example, the full `periods` collection will look as follows: `{\"2024\": {\"04\": {...}, \"05\": {...}}}`. The year and month in this documentation are referred as `<year>` and `<month>`.

    The example response should give a good idea of what this looks like in practise.
    """

    less_than_year_greater_than: NotRequired[LessThanYearGreaterThanTypedDict]


class Periods(BaseModel):
    r"""For bookkeeping purposes, the settlement includes an overview of transactions included in the settlement. These transactions are grouped into 'period' objects — one for each calendar month.

    For example, if a settlement includes funds from 15 April until 4 May, it will include two period objects. One for all transactions processed between 15 April and 30 April, and one for all transactions between 1 May and 4 May.

    Period objects are grouped by year, and then by month. So in the above example, the full `periods` collection will look as follows: `{\"2024\": {\"04\": {...}, \"05\": {...}}}`. The year and month in this documentation are referred as `<year>` and `<month>`.

    The example response should give a good idea of what this looks like in practise.
    """

    less_than_year_greater_than: Annotated[
        Optional[LessThanYearGreaterThan], pydantic.Field(alias="<year>")
    ] = None


class GetSettlementSelfTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetSettlementSelf(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetSettlementPaymentsTypedDict(TypedDict):
    r"""The API resource URL of the [payments](list-payments) included in this settlement."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetSettlementPayments(BaseModel):
    r"""The API resource URL of the [payments](list-payments) included in this settlement."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetSettlementCapturesTypedDict(TypedDict):
    r"""The API resource URL of the [captures](list-captures) included in this settlement."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetSettlementCaptures(BaseModel):
    r"""The API resource URL of the [captures](list-captures) included in this settlement."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetSettlementRefundsTypedDict(TypedDict):
    r"""The API resource URL of the [refunds](list-refunds) deducted from this settlement."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetSettlementRefunds(BaseModel):
    r"""The API resource URL of the [refunds](list-refunds) deducted from this settlement."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetSettlementChargebacksTypedDict(TypedDict):
    r"""The API resource URL of the [chargebacks](list-chargebacks) deducted from this settlement."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetSettlementChargebacks(BaseModel):
    r"""The API resource URL of the [chargebacks](list-chargebacks) deducted from this settlement."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class InvoiceTypedDict(TypedDict):
    r"""The API resource URL of the [invoice](list-invoices)."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class Invoice(BaseModel):
    r"""The API resource URL of the [invoice](list-invoices)."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class GetSettlementDocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetSettlementDocumentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetSettlementLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: NotRequired[GetSettlementSelfTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    payments: NotRequired[GetSettlementPaymentsTypedDict]
    r"""The API resource URL of the [payments](list-payments) included in this settlement."""
    captures: NotRequired[GetSettlementCapturesTypedDict]
    r"""The API resource URL of the [captures](list-captures) included in this settlement."""
    refunds: NotRequired[GetSettlementRefundsTypedDict]
    r"""The API resource URL of the [refunds](list-refunds) deducted from this settlement."""
    chargebacks: NotRequired[GetSettlementChargebacksTypedDict]
    r"""The API resource URL of the [chargebacks](list-chargebacks) deducted from this settlement."""
    invoice: NotRequired[Nullable[InvoiceTypedDict]]
    r"""The API resource URL of the [invoice](list-invoices)."""
    documentation: NotRequired[GetSettlementDocumentationTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class GetSettlementLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[Optional[GetSettlementSelf], pydantic.Field(alias="self")] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    payments: Optional[GetSettlementPayments] = None
    r"""The API resource URL of the [payments](list-payments) included in this settlement."""

    captures: Optional[GetSettlementCaptures] = None
    r"""The API resource URL of the [captures](list-captures) included in this settlement."""

    refunds: Optional[GetSettlementRefunds] = None
    r"""The API resource URL of the [refunds](list-refunds) deducted from this settlement."""

    chargebacks: Optional[GetSettlementChargebacks] = None
    r"""The API resource URL of the [chargebacks](list-chargebacks) deducted from this settlement."""

    invoice: OptionalNullable[Invoice] = UNSET
    r"""The API resource URL of the [invoice](list-invoices)."""

    documentation: Optional[GetSettlementDocumentation] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "self",
            "payments",
            "captures",
            "refunds",
            "chargebacks",
            "invoice",
            "documentation",
        ]
        nullable_fields = ["invoice"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetSettlementResponseBodyTypedDict(TypedDict):
    r"""The settlement object."""

    resource: NotRequired[str]
    r"""Indicates the response contains a settlement object. Will always contain the string `settlement` for this endpoint."""
    id: NotRequired[str]
    r"""The identifier uniquely referring to this settlement."""
    created_at: NotRequired[str]
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""
    reference: NotRequired[Nullable[str]]
    r"""The settlement's bank reference, as found in your Mollie account and on your bank statement."""
    settled_at: NotRequired[Nullable[str]]
    r"""The date on which the settlement was settled, in ISO 8601 format.

    For an [open settlement](get-open-settlement) or for the [next settlement](get-next-settlement), no settlement date is available.
    """
    status: NotRequired[str]
    r"""The status of the settlement.

    Possible values: `open` `pending` `paidout` `failed`
    """
    amount: NotRequired[GetSettlementAmountTypedDict]
    r"""The total amount of the settlement."""
    balance_id: NotRequired[str]
    r"""The balance token that the settlement was settled to."""
    invoice_id: NotRequired[Nullable[str]]
    r"""The ID of the oldest invoice created for all the periods, if the invoice has been created yet."""
    periods: NotRequired[PeriodsTypedDict]
    r"""For bookkeeping purposes, the settlement includes an overview of transactions included in the settlement. These transactions are grouped into 'period' objects — one for each calendar month.

    For example, if a settlement includes funds from 15 April until 4 May, it will include two period objects. One for all transactions processed between 15 April and 30 April, and one for all transactions between 1 May and 4 May.

    Period objects are grouped by year, and then by month. So in the above example, the full `periods` collection will look as follows: `{\"2024\": {\"04\": {...}, \"05\": {...}}}`. The year and month in this documentation are referred as `<year>` and `<month>`.

    The example response should give a good idea of what this looks like in practise.
    """
    links: NotRequired[GetSettlementLinksTypedDict]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""


class GetSettlementResponseBody(BaseModel):
    r"""The settlement object."""

    resource: Optional[str] = "settlement"
    r"""Indicates the response contains a settlement object. Will always contain the string `settlement` for this endpoint."""

    id: Optional[str] = None
    r"""The identifier uniquely referring to this settlement."""

    created_at: Annotated[Optional[str], pydantic.Field(alias="createdAt")] = None
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""

    reference: OptionalNullable[str] = UNSET
    r"""The settlement's bank reference, as found in your Mollie account and on your bank statement."""

    settled_at: Annotated[OptionalNullable[str], pydantic.Field(alias="settledAt")] = (
        UNSET
    )
    r"""The date on which the settlement was settled, in ISO 8601 format.

    For an [open settlement](get-open-settlement) or for the [next settlement](get-next-settlement), no settlement date is available.
    """

    status: Optional[str] = None
    r"""The status of the settlement.

    Possible values: `open` `pending` `paidout` `failed`
    """

    amount: Optional[GetSettlementAmount] = None
    r"""The total amount of the settlement."""

    balance_id: Annotated[Optional[str], pydantic.Field(alias="balanceId")] = None
    r"""The balance token that the settlement was settled to."""

    invoice_id: Annotated[OptionalNullable[str], pydantic.Field(alias="invoiceId")] = (
        UNSET
    )
    r"""The ID of the oldest invoice created for all the periods, if the invoice has been created yet."""

    periods: Optional[Periods] = None
    r"""For bookkeeping purposes, the settlement includes an overview of transactions included in the settlement. These transactions are grouped into 'period' objects — one for each calendar month.

    For example, if a settlement includes funds from 15 April until 4 May, it will include two period objects. One for all transactions processed between 15 April and 30 April, and one for all transactions between 1 May and 4 May.

    Period objects are grouped by year, and then by month. So in the above example, the full `periods` collection will look as follows: `{\"2024\": {\"04\": {...}, \"05\": {...}}}`. The year and month in this documentation are referred as `<year>` and `<month>`.

    The example response should give a good idea of what this looks like in practise.
    """

    links: Annotated[Optional[GetSettlementLinks], pydantic.Field(alias="_links")] = (
        None
    )
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "resource",
            "id",
            "createdAt",
            "reference",
            "settledAt",
            "status",
            "amount",
            "balanceId",
            "invoiceId",
            "periods",
            "_links",
        ]
        nullable_fields = ["reference", "settledAt", "invoiceId"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
