"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
import httpx
from mollie import utils
from mollie.models import ClientError
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import (
    FieldMetadata,
    PathParamMetadata,
    QueryParamMetadata,
    validate_open_enum,
)
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import PlainValidator
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class GetMandateRequestTypedDict(TypedDict):
    customer_id: str
    r"""Provide the ID of the related customer."""
    mandate_id: str
    r"""Provide the ID of the related mandate."""
    testmode: NotRequired[Nullable[bool]]
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query
    parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by
    setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """


class GetMandateRequest(BaseModel):
    customer_id: Annotated[
        str,
        pydantic.Field(alias="customerId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""Provide the ID of the related customer."""

    mandate_id: Annotated[
        str,
        pydantic.Field(alias="mandateId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""Provide the ID of the related mandate."""

    testmode: Annotated[
        OptionalNullable[bool],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query
    parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by
    setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["testmode"]
        nullable_fields = ["testmode"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetMandateNotFoundDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str
    type: str


class GetMandateNotFoundDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str

    type: str


class GetMandateNotFoundLinksTypedDict(TypedDict):
    documentation: GetMandateNotFoundDocumentationTypedDict
    r"""The URL to the generic Mollie API error handling guide."""


class GetMandateNotFoundLinks(BaseModel):
    documentation: GetMandateNotFoundDocumentation
    r"""The URL to the generic Mollie API error handling guide."""


class GetMandateHalJSONErrorData(BaseModel):
    status: int
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: str
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: str
    r"""A detailed human-readable description of the error that occurred."""

    links: Annotated[GetMandateNotFoundLinks, pydantic.Field(alias="_links")]

    field: Optional[str] = None
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name
    of the field that caused the issue.
    """


class GetMandateHalJSONError(ClientError):
    r"""An error response object."""

    data: GetMandateHalJSONErrorData

    def __init__(
        self,
        data: GetMandateHalJSONErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        message = body or raw_response.text
        super().__init__(message, raw_response, body)
        self.data = data


class GetMandateMode(str, Enum, metaclass=utils.OpenEnumMeta):
    r"""Whether this entity was created in live mode or in test mode."""

    LIVE = "live"
    TEST = "test"


class GetMandateMethod(str, Enum, metaclass=utils.OpenEnumMeta):
    r"""Payment method of the mandate.

    SEPA Direct Debit and PayPal mandates can be created directly.
    """

    CREDITCARD = "creditcard"
    DIRECTDEBIT = "directdebit"
    PAYPAL = "paypal"


class GetMandateCardLabel(str, Enum, metaclass=utils.OpenEnumMeta):
    r"""The card's label. Available for card mandates, if the card label could be detected."""

    AMERICAN_EXPRESS = "American Express"
    CARTA_SI = "Carta Si"
    CARTE_BLEUE = "Carte Bleue"
    DANKORT = "Dankort"
    DINERS_CLUB = "Diners Club"
    DISCOVER = "Discover"
    JCB = "JCB"
    LASER = "Laser"
    MAESTRO = "Maestro"
    MASTERCARD = "Mastercard"
    UNIONPAY = "Unionpay"
    VISA = "Visa"


class GetMandateDetailsTypedDict(TypedDict):
    consumer_name: NotRequired[Nullable[str]]
    r"""The customer's name. Available for SEPA Direct Debit and PayPal mandates."""
    consumer_account: NotRequired[Nullable[str]]
    r"""The customer's IBAN or email address. Available for SEPA Direct Debit and PayPal mandates."""
    consumer_bic: NotRequired[Nullable[str]]
    r"""The BIC of the customer's bank. Available for SEPA Direct Debit mandates."""
    card_holder: NotRequired[Nullable[str]]
    r"""The card holder's name. Available for card mandates."""
    card_number: NotRequired[Nullable[str]]
    r"""The last four digits of the card number. Available for card mandates."""
    card_expiry_date: NotRequired[Nullable[str]]
    r"""The card's expiry date in `YYYY-MM-DD` format. Available for card mandates."""
    card_label: NotRequired[Nullable[GetMandateCardLabel]]
    r"""The card's label. Available for card mandates, if the card label could be detected."""
    card_fingerprint: NotRequired[Nullable[str]]
    r"""Unique alphanumeric representation of this specific card. Available for card mandates. Can be used to identify
    returning customers.
    """


class GetMandateDetails(BaseModel):
    consumer_name: Annotated[
        OptionalNullable[str], pydantic.Field(alias="consumerName")
    ] = UNSET
    r"""The customer's name. Available for SEPA Direct Debit and PayPal mandates."""

    consumer_account: Annotated[
        OptionalNullable[str], pydantic.Field(alias="consumerAccount")
    ] = UNSET
    r"""The customer's IBAN or email address. Available for SEPA Direct Debit and PayPal mandates."""

    consumer_bic: Annotated[
        OptionalNullable[str], pydantic.Field(alias="consumerBic")
    ] = UNSET
    r"""The BIC of the customer's bank. Available for SEPA Direct Debit mandates."""

    card_holder: Annotated[
        OptionalNullable[str], pydantic.Field(alias="cardHolder")
    ] = UNSET
    r"""The card holder's name. Available for card mandates."""

    card_number: Annotated[
        OptionalNullable[str], pydantic.Field(alias="cardNumber")
    ] = UNSET
    r"""The last four digits of the card number. Available for card mandates."""

    card_expiry_date: Annotated[
        OptionalNullable[str], pydantic.Field(alias="cardExpiryDate")
    ] = UNSET
    r"""The card's expiry date in `YYYY-MM-DD` format. Available for card mandates."""

    card_label: Annotated[
        Annotated[
            OptionalNullable[GetMandateCardLabel],
            PlainValidator(validate_open_enum(False)),
        ],
        pydantic.Field(alias="cardLabel"),
    ] = UNSET
    r"""The card's label. Available for card mandates, if the card label could be detected."""

    card_fingerprint: Annotated[
        OptionalNullable[str], pydantic.Field(alias="cardFingerprint")
    ] = UNSET
    r"""Unique alphanumeric representation of this specific card. Available for card mandates. Can be used to identify
    returning customers.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "consumerName",
            "consumerAccount",
            "consumerBic",
            "cardHolder",
            "cardNumber",
            "cardExpiryDate",
            "cardLabel",
            "cardFingerprint",
        ]
        nullable_fields = [
            "consumerName",
            "consumerAccount",
            "consumerBic",
            "cardHolder",
            "cardNumber",
            "cardExpiryDate",
            "cardLabel",
            "cardFingerprint",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetMandateStatus(str, Enum, metaclass=utils.OpenEnumMeta):
    r"""The status of the mandate. A status can be `pending` for mandates when the first payment is not yet finalized, or
    when we did not received the IBAN yet from the first payment.
    """

    VALID = "valid"
    PENDING = "pending"
    INVALID = "invalid"


class GetMandateSelfTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetMandateSelf(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetMandateCustomerTypedDict(TypedDict):
    r"""The API resource URL of the [customer](get-customer) that this mandate belongs to."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetMandateCustomer(BaseModel):
    r"""The API resource URL of the [customer](get-customer) that this mandate belongs to."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetMandateDocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetMandateDocumentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetMandateLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: GetMandateSelfTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    customer: GetMandateCustomerTypedDict
    r"""The API resource URL of the [customer](get-customer) that this mandate belongs to."""
    documentation: GetMandateDocumentationTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class GetMandateLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[GetMandateSelf, pydantic.Field(alias="self")]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    customer: GetMandateCustomer
    r"""The API resource URL of the [customer](get-customer) that this mandate belongs to."""

    documentation: GetMandateDocumentation
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class GetMandateResponseTypedDict(TypedDict):
    r"""The mandate object."""

    resource: str
    r"""Indicates the response contains a mandate object. Will always contain the string `mandate` for this endpoint."""
    id: str
    r"""The identifier uniquely referring to this mandate. Example: `mdt_pWUnw6pkBN`."""
    mode: GetMandateMode
    r"""Whether this entity was created in live mode or in test mode."""
    method: GetMandateMethod
    r"""Payment method of the mandate.

    SEPA Direct Debit and PayPal mandates can be created directly.
    """
    details: GetMandateDetailsTypedDict
    signature_date: Nullable[str]
    r"""The date when the mandate was signed in `YYYY-MM-DD` format."""
    mandate_reference: Nullable[str]
    r"""A custom mandate reference. For SEPA Direct Debit, it is vital to provide a unique reference. Some banks will
    decline Direct Debit payments if the mandate reference is not unique.
    """
    status: GetMandateStatus
    r"""The status of the mandate. A status can be `pending` for mandates when the first payment is not yet finalized, or
    when we did not received the IBAN yet from the first payment.
    """
    customer_id: str
    r"""The identifier referring to the [customer](get-customer) this mandate was linked to."""
    created_at: str
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""
    links: GetMandateLinksTypedDict
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""


class GetMandateResponse(BaseModel):
    r"""The mandate object."""

    resource: str
    r"""Indicates the response contains a mandate object. Will always contain the string `mandate` for this endpoint."""

    id: str
    r"""The identifier uniquely referring to this mandate. Example: `mdt_pWUnw6pkBN`."""

    mode: Annotated[GetMandateMode, PlainValidator(validate_open_enum(False))]
    r"""Whether this entity was created in live mode or in test mode."""

    method: Annotated[GetMandateMethod, PlainValidator(validate_open_enum(False))]
    r"""Payment method of the mandate.

    SEPA Direct Debit and PayPal mandates can be created directly.
    """

    details: GetMandateDetails

    signature_date: Annotated[Nullable[str], pydantic.Field(alias="signatureDate")]
    r"""The date when the mandate was signed in `YYYY-MM-DD` format."""

    mandate_reference: Annotated[
        Nullable[str], pydantic.Field(alias="mandateReference")
    ]
    r"""A custom mandate reference. For SEPA Direct Debit, it is vital to provide a unique reference. Some banks will
    decline Direct Debit payments if the mandate reference is not unique.
    """

    status: Annotated[GetMandateStatus, PlainValidator(validate_open_enum(False))]
    r"""The status of the mandate. A status can be `pending` for mandates when the first payment is not yet finalized, or
    when we did not received the IBAN yet from the first payment.
    """

    customer_id: Annotated[str, pydantic.Field(alias="customerId")]
    r"""The identifier referring to the [customer](get-customer) this mandate was linked to."""

    created_at: Annotated[str, pydantic.Field(alias="createdAt")]
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""

    links: Annotated[GetMandateLinks, pydantic.Field(alias="_links")]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["signatureDate", "mandateReference"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
