"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
import httpx
from mollie import utils
from mollie.models import ClientError
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import (
    FieldMetadata,
    PathParamMetadata,
    RequestMetadata,
    validate_open_enum,
)
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import PlainValidator
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ModeRequest(str, Enum):
    r"""Updating a profile from `test` mode to `live` mode will trigger a verification process, where we review
    the profile before it can start accepting payments.
    """

    LIVE = "live"
    TEST = "test"


class UpdateProfileRequestBodyTypedDict(TypedDict):
    name: NotRequired[Nullable[str]]
    r"""The profile's name, this will usually reflect the trade name or brand name of the profile's website or
    application.
    """
    website: NotRequired[Nullable[str]]
    r"""The URL to the profile's website or application. Only `https` or `http` URLs are allowed. No `@` signs
    are allowed.
    """
    email: NotRequired[Nullable[str]]
    r"""The email address associated with the profile's trade name or brand."""
    phone: NotRequired[Nullable[str]]
    r"""The phone number associated with the profile's trade name or brand."""
    description: NotRequired[Nullable[str]]
    r"""The products or services offered by the profile's website or application."""
    countries_of_activity: NotRequired[Nullable[List[str]]]
    r"""A list of countries where you expect that the majority of the profile's customers reside,
    in [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) format.
    """
    business_category: NotRequired[Nullable[str]]
    r"""The industry associated with the profile's trade name or brand. Please refer to the
    [business category list](common-data-types) for all possible options.
    """
    mode: NotRequired[Nullable[ModeRequest]]
    r"""Updating a profile from `test` mode to `live` mode will trigger a verification process, where we review
    the profile before it can start accepting payments.
    """


class UpdateProfileRequestBody(BaseModel):
    name: OptionalNullable[str] = UNSET
    r"""The profile's name, this will usually reflect the trade name or brand name of the profile's website or
    application.
    """

    website: OptionalNullable[str] = UNSET
    r"""The URL to the profile's website or application. Only `https` or `http` URLs are allowed. No `@` signs
    are allowed.
    """

    email: OptionalNullable[str] = UNSET
    r"""The email address associated with the profile's trade name or brand."""

    phone: OptionalNullable[str] = UNSET
    r"""The phone number associated with the profile's trade name or brand."""

    description: OptionalNullable[str] = UNSET
    r"""The products or services offered by the profile's website or application."""

    countries_of_activity: Annotated[
        OptionalNullable[List[str]], pydantic.Field(alias="countriesOfActivity")
    ] = UNSET
    r"""A list of countries where you expect that the majority of the profile's customers reside,
    in [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) format.
    """

    business_category: Annotated[
        OptionalNullable[str], pydantic.Field(alias="businessCategory")
    ] = UNSET
    r"""The industry associated with the profile's trade name or brand. Please refer to the
    [business category list](common-data-types) for all possible options.
    """

    mode: OptionalNullable[ModeRequest] = UNSET
    r"""Updating a profile from `test` mode to `live` mode will trigger a verification process, where we review
    the profile before it can start accepting payments.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "name",
            "website",
            "email",
            "phone",
            "description",
            "countriesOfActivity",
            "businessCategory",
            "mode",
        ]
        nullable_fields = [
            "name",
            "website",
            "email",
            "phone",
            "description",
            "countriesOfActivity",
            "businessCategory",
            "mode",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class UpdateProfileRequestTypedDict(TypedDict):
    id: str
    r"""Provide the ID of the item you want to perform this operation on."""
    request_body: UpdateProfileRequestBodyTypedDict


class UpdateProfileRequest(BaseModel):
    id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""Provide the ID of the item you want to perform this operation on."""

    request_body: Annotated[
        UpdateProfileRequestBody,
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ]


class UpdateProfileUnprocessableEntityDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str
    type: str


class UpdateProfileUnprocessableEntityDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str

    type: str


class UpdateProfileUnprocessableEntityLinksTypedDict(TypedDict):
    documentation: UpdateProfileUnprocessableEntityDocumentationTypedDict
    r"""The URL to the generic Mollie API error handling guide."""


class UpdateProfileUnprocessableEntityLinks(BaseModel):
    documentation: UpdateProfileUnprocessableEntityDocumentation
    r"""The URL to the generic Mollie API error handling guide."""


class UpdateProfileUnprocessableEntityHalJSONErrorData(BaseModel):
    status: int
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: str
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: str
    r"""A detailed human-readable description of the error that occurred."""

    links: Annotated[
        UpdateProfileUnprocessableEntityLinks, pydantic.Field(alias="_links")
    ]

    field: Optional[str] = None
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name
    of the field that caused the issue.
    """


class UpdateProfileUnprocessableEntityHalJSONError(ClientError):
    r"""An error response object."""

    data: UpdateProfileUnprocessableEntityHalJSONErrorData

    def __init__(
        self,
        data: UpdateProfileUnprocessableEntityHalJSONErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        message = body or raw_response.text
        super().__init__(message, raw_response, body)
        self.data = data


class UpdateProfileGoneDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str
    type: str


class UpdateProfileGoneDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str

    type: str


class UpdateProfileGoneLinksTypedDict(TypedDict):
    documentation: UpdateProfileGoneDocumentationTypedDict
    r"""The URL to the generic Mollie API error handling guide."""


class UpdateProfileGoneLinks(BaseModel):
    documentation: UpdateProfileGoneDocumentation
    r"""The URL to the generic Mollie API error handling guide."""


class UpdateProfileGoneHalJSONErrorData(BaseModel):
    status: int
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: str
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: str
    r"""A detailed human-readable description of the error that occurred."""

    links: Annotated[UpdateProfileGoneLinks, pydantic.Field(alias="_links")]

    field: Optional[str] = None
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name
    of the field that caused the issue.
    """


class UpdateProfileGoneHalJSONError(ClientError):
    r"""An error response object."""

    data: UpdateProfileGoneHalJSONErrorData

    def __init__(
        self,
        data: UpdateProfileGoneHalJSONErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        message = body or raw_response.text
        super().__init__(message, raw_response, body)
        self.data = data


class UpdateProfileNotFoundDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str
    type: str


class UpdateProfileNotFoundDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str

    type: str


class UpdateProfileNotFoundLinksTypedDict(TypedDict):
    documentation: UpdateProfileNotFoundDocumentationTypedDict
    r"""The URL to the generic Mollie API error handling guide."""


class UpdateProfileNotFoundLinks(BaseModel):
    documentation: UpdateProfileNotFoundDocumentation
    r"""The URL to the generic Mollie API error handling guide."""


class UpdateProfileNotFoundHalJSONErrorData(BaseModel):
    status: int
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: str
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: str
    r"""A detailed human-readable description of the error that occurred."""

    links: Annotated[UpdateProfileNotFoundLinks, pydantic.Field(alias="_links")]

    field: Optional[str] = None
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name
    of the field that caused the issue.
    """


class UpdateProfileNotFoundHalJSONError(ClientError):
    r"""An error response object."""

    data: UpdateProfileNotFoundHalJSONErrorData

    def __init__(
        self,
        data: UpdateProfileNotFoundHalJSONErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        message = body or raw_response.text
        super().__init__(message, raw_response, body)
        self.data = data


class UpdateProfileModeResponse(str, Enum, metaclass=utils.OpenEnumMeta):
    r"""Whether this entity was created in live mode or in test mode."""

    LIVE = "live"
    TEST = "test"


class UpdateProfileStatus(str, Enum, metaclass=utils.OpenEnumMeta):
    r"""The profile status determines whether the profile is able to receive live payments.

    * `unverified`: The profile has not been verified yet and can only be used to create test payments.
    * `verified`: The profile has been verified and can be used to create live payments and test payments.
    * `blocked`: The profile is blocked and can no longer be used or changed.
    """

    UNVERIFIED = "unverified"
    VERIFIED = "verified"
    BLOCKED = "blocked"


class UpdateProfileReviewStatus(str, Enum, metaclass=utils.OpenEnumMeta):
    r"""The status of the requested changes."""

    PENDING = "pending"
    REJECTED = "rejected"


class UpdateProfileReviewTypedDict(TypedDict):
    r"""Present if changes have been made that have not yet been approved by Mollie. Changes to test profiles are approved
    automatically, unless a switch to a live profile has been requested. The review object will therefore usually be
    `null` in test mode.
    """

    status: NotRequired[UpdateProfileReviewStatus]
    r"""The status of the requested changes."""


class UpdateProfileReview(BaseModel):
    r"""Present if changes have been made that have not yet been approved by Mollie. Changes to test profiles are approved
    automatically, unless a switch to a live profile has been requested. The review object will therefore usually be
    `null` in test mode.
    """

    status: Annotated[
        Optional[UpdateProfileReviewStatus], PlainValidator(validate_open_enum(False))
    ] = None
    r"""The status of the requested changes."""


class UpdateProfileSelfTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class UpdateProfileSelf(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class UpdateProfileDashboardTypedDict(TypedDict):
    r"""Link to the profile in the Mollie dashboard."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class UpdateProfileDashboard(BaseModel):
    r"""Link to the profile in the Mollie dashboard."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class UpdateProfileChargebacksTypedDict(TypedDict):
    r"""The API resource URL of the chargebacks that belong to this profile."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class UpdateProfileChargebacks(BaseModel):
    r"""The API resource URL of the chargebacks that belong to this profile."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class UpdateProfileMethodsTypedDict(TypedDict):
    r"""The API resource URL of the methods that are enabled for this profile."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class UpdateProfileMethods(BaseModel):
    r"""The API resource URL of the methods that are enabled for this profile."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class UpdateProfilePaymentsTypedDict(TypedDict):
    r"""The API resource URL of the payments that belong to this profile."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class UpdateProfilePayments(BaseModel):
    r"""The API resource URL of the payments that belong to this profile."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class UpdateProfileRefundsTypedDict(TypedDict):
    r"""The API resource URL of the refunds that belong to this profile."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class UpdateProfileRefunds(BaseModel):
    r"""The API resource URL of the refunds that belong to this profile."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class UpdateProfileCheckoutPreviewURLTypedDict(TypedDict):
    r"""The hosted checkout preview URL. You need to be logged in to access this page."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class UpdateProfileCheckoutPreviewURL(BaseModel):
    r"""The hosted checkout preview URL. You need to be logged in to access this page."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class UpdateProfileDocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class UpdateProfileDocumentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class UpdateProfileLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: NotRequired[UpdateProfileSelfTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    dashboard: NotRequired[UpdateProfileDashboardTypedDict]
    r"""Link to the profile in the Mollie dashboard."""
    chargebacks: NotRequired[UpdateProfileChargebacksTypedDict]
    r"""The API resource URL of the chargebacks that belong to this profile."""
    methods: NotRequired[UpdateProfileMethodsTypedDict]
    r"""The API resource URL of the methods that are enabled for this profile."""
    payments: NotRequired[UpdateProfilePaymentsTypedDict]
    r"""The API resource URL of the payments that belong to this profile."""
    refunds: NotRequired[UpdateProfileRefundsTypedDict]
    r"""The API resource URL of the refunds that belong to this profile."""
    checkout_preview_url: NotRequired[UpdateProfileCheckoutPreviewURLTypedDict]
    r"""The hosted checkout preview URL. You need to be logged in to access this page."""
    documentation: NotRequired[UpdateProfileDocumentationTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class UpdateProfileLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[Optional[UpdateProfileSelf], pydantic.Field(alias="self")] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    dashboard: Optional[UpdateProfileDashboard] = None
    r"""Link to the profile in the Mollie dashboard."""

    chargebacks: Optional[UpdateProfileChargebacks] = None
    r"""The API resource URL of the chargebacks that belong to this profile."""

    methods: Optional[UpdateProfileMethods] = None
    r"""The API resource URL of the methods that are enabled for this profile."""

    payments: Optional[UpdateProfilePayments] = None
    r"""The API resource URL of the payments that belong to this profile."""

    refunds: Optional[UpdateProfileRefunds] = None
    r"""The API resource URL of the refunds that belong to this profile."""

    checkout_preview_url: Annotated[
        Optional[UpdateProfileCheckoutPreviewURL],
        pydantic.Field(alias="checkoutPreviewUrl"),
    ] = None
    r"""The hosted checkout preview URL. You need to be logged in to access this page."""

    documentation: Optional[UpdateProfileDocumentation] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class UpdateProfileResponseTypedDict(TypedDict):
    r"""The updated profile object."""

    resource: NotRequired[str]
    r"""Indicates the response contains a profile object. Will always contain the string `profile` for this endpoint."""
    id: NotRequired[str]
    r"""The identifier uniquely referring to this profile. Example: `pfl_v9hTwCvYqw`."""
    mode: NotRequired[UpdateProfileModeResponse]
    r"""Whether this entity was created in live mode or in test mode."""
    name: NotRequired[str]
    r"""The profile's name, this will usually reflect the trade name or brand name of the profile's website or
    application.
    """
    website: NotRequired[str]
    r"""The URL to the profile's website or application. Only `https` or `http` URLs are allowed. No `@` signs are
    allowed.
    """
    email: NotRequired[str]
    r"""The email address associated with the profile's trade name or brand."""
    phone: NotRequired[str]
    r"""The phone number associated with the profile's trade name or brand."""
    description: NotRequired[str]
    r"""The products or services offered by the profile's website or application."""
    countries_of_activity: NotRequired[List[str]]
    r"""A list of countries where you expect that the majority of the profile's customers reside,
    in [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) format.
    """
    business_category: NotRequired[str]
    r"""The industry associated with the profile's trade name or brand. Please refer to the
    [business category list](common-data-types#business-category) for all possible options.
    """
    status: NotRequired[UpdateProfileStatus]
    r"""The profile status determines whether the profile is able to receive live payments.

    * `unverified`: The profile has not been verified yet and can only be used to create test payments.
    * `verified`: The profile has been verified and can be used to create live payments and test payments.
    * `blocked`: The profile is blocked and can no longer be used or changed.
    """
    review: NotRequired[UpdateProfileReviewTypedDict]
    r"""Present if changes have been made that have not yet been approved by Mollie. Changes to test profiles are approved
    automatically, unless a switch to a live profile has been requested. The review object will therefore usually be
    `null` in test mode.
    """
    created_at: NotRequired[str]
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""
    links: NotRequired[UpdateProfileLinksTypedDict]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""


class UpdateProfileResponse(BaseModel):
    r"""The updated profile object."""

    resource: Optional[str] = None
    r"""Indicates the response contains a profile object. Will always contain the string `profile` for this endpoint."""

    id: Optional[str] = None
    r"""The identifier uniquely referring to this profile. Example: `pfl_v9hTwCvYqw`."""

    mode: Annotated[
        Optional[UpdateProfileModeResponse], PlainValidator(validate_open_enum(False))
    ] = None
    r"""Whether this entity was created in live mode or in test mode."""

    name: Optional[str] = None
    r"""The profile's name, this will usually reflect the trade name or brand name of the profile's website or
    application.
    """

    website: Optional[str] = None
    r"""The URL to the profile's website or application. Only `https` or `http` URLs are allowed. No `@` signs are
    allowed.
    """

    email: Optional[str] = None
    r"""The email address associated with the profile's trade name or brand."""

    phone: Optional[str] = None
    r"""The phone number associated with the profile's trade name or brand."""

    description: Optional[str] = None
    r"""The products or services offered by the profile's website or application."""

    countries_of_activity: Annotated[
        Optional[List[str]], pydantic.Field(alias="countriesOfActivity")
    ] = None
    r"""A list of countries where you expect that the majority of the profile's customers reside,
    in [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) format.
    """

    business_category: Annotated[
        Optional[str], pydantic.Field(alias="businessCategory")
    ] = None
    r"""The industry associated with the profile's trade name or brand. Please refer to the
    [business category list](common-data-types#business-category) for all possible options.
    """

    status: Annotated[
        Optional[UpdateProfileStatus], PlainValidator(validate_open_enum(False))
    ] = None
    r"""The profile status determines whether the profile is able to receive live payments.

    * `unverified`: The profile has not been verified yet and can only be used to create test payments.
    * `verified`: The profile has been verified and can be used to create live payments and test payments.
    * `blocked`: The profile is blocked and can no longer be used or changed.
    """

    review: Optional[UpdateProfileReview] = None
    r"""Present if changes have been made that have not yet been approved by Mollie. Changes to test profiles are approved
    automatically, unless a switch to a live profile has been requested. The review object will therefore usually be
    `null` in test mode.
    """

    created_at: Annotated[Optional[str], pydantic.Field(alias="createdAt")] = None
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""

    links: Annotated[Optional[UpdateProfileLinks], pydantic.Field(alias="_links")] = (
        None
    )
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""
