"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
import httpx
from mollie.models import ClientError
from mollie.types import BaseModel
from mollie.utils import FieldMetadata, PathParamMetadata
import pydantic
from typing import Optional
from typing_extensions import Annotated, TypedDict


class DeleteProfileRequestTypedDict(TypedDict):
    id: str
    r"""Provide the ID of the item you want to perform this operation on."""


class DeleteProfileRequest(BaseModel):
    id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""Provide the ID of the item you want to perform this operation on."""


class DeleteProfileGoneDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str
    type: str


class DeleteProfileGoneDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str

    type: str


class DeleteProfileGoneLinksTypedDict(TypedDict):
    documentation: DeleteProfileGoneDocumentationTypedDict
    r"""The URL to the generic Mollie API error handling guide."""


class DeleteProfileGoneLinks(BaseModel):
    documentation: DeleteProfileGoneDocumentation
    r"""The URL to the generic Mollie API error handling guide."""


class DeleteProfileGoneHalJSONErrorData(BaseModel):
    status: int
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: str
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: str
    r"""A detailed human-readable description of the error that occurred."""

    links: Annotated[DeleteProfileGoneLinks, pydantic.Field(alias="_links")]

    field: Optional[str] = None
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name
    of the field that caused the issue.
    """


class DeleteProfileGoneHalJSONError(ClientError):
    r"""An error response object."""

    data: DeleteProfileGoneHalJSONErrorData

    def __init__(
        self,
        data: DeleteProfileGoneHalJSONErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        message = body or raw_response.text
        super().__init__(message, raw_response, body)
        self.data = data


class DeleteProfileNotFoundDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str
    type: str


class DeleteProfileNotFoundDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str

    type: str


class DeleteProfileNotFoundLinksTypedDict(TypedDict):
    documentation: DeleteProfileNotFoundDocumentationTypedDict
    r"""The URL to the generic Mollie API error handling guide."""


class DeleteProfileNotFoundLinks(BaseModel):
    documentation: DeleteProfileNotFoundDocumentation
    r"""The URL to the generic Mollie API error handling guide."""


class DeleteProfileNotFoundHalJSONErrorData(BaseModel):
    status: int
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: str
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: str
    r"""A detailed human-readable description of the error that occurred."""

    links: Annotated[DeleteProfileNotFoundLinks, pydantic.Field(alias="_links")]

    field: Optional[str] = None
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name
    of the field that caused the issue.
    """


class DeleteProfileNotFoundHalJSONError(ClientError):
    r"""An error response object."""

    data: DeleteProfileNotFoundHalJSONErrorData

    def __init__(
        self,
        data: DeleteProfileNotFoundHalJSONErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        message = body or raw_response.text
        super().__init__(message, raw_response, body)
        self.data = data
