"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
import httpx
from mollie import utils
from mollie.models import ClientError
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import (
    FieldMetadata,
    PathParamMetadata,
    QueryParamMetadata,
    validate_open_enum,
)
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import PlainValidator
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class GetBalanceRequestTypedDict(TypedDict):
    id: str
    r"""Provide the ID of the item you want to perform this operation on."""
    testmode: NotRequired[Nullable[bool]]
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query
    parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by
    setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """


class GetBalanceRequest(BaseModel):
    id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""Provide the ID of the item you want to perform this operation on."""

    testmode: Annotated[
        OptionalNullable[bool],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query
    parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by
    setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["testmode"]
        nullable_fields = ["testmode"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetBalanceNotFoundDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str
    type: str


class GetBalanceNotFoundDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str

    type: str


class GetBalanceNotFoundLinksTypedDict(TypedDict):
    documentation: GetBalanceNotFoundDocumentationTypedDict
    r"""The URL to the generic Mollie API error handling guide."""


class GetBalanceNotFoundLinks(BaseModel):
    documentation: GetBalanceNotFoundDocumentation
    r"""The URL to the generic Mollie API error handling guide."""


class GetBalanceHalJSONErrorData(BaseModel):
    status: int
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: str
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: str
    r"""A detailed human-readable description of the error that occurred."""

    links: Annotated[GetBalanceNotFoundLinks, pydantic.Field(alias="_links")]

    field: Optional[str] = None
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name
    of the field that caused the issue.
    """


class GetBalanceHalJSONError(ClientError):
    r"""An error response object."""

    data: GetBalanceHalJSONErrorData

    def __init__(
        self,
        data: GetBalanceHalJSONErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        message = body or raw_response.text
        super().__init__(message, raw_response, body)
        self.data = data


class GetBalanceMode(str, Enum, metaclass=utils.OpenEnumMeta):
    r"""Whether this entity was created in live mode or in test mode."""

    LIVE = "live"
    TEST = "test"


class GetBalanceCurrency(str, Enum, metaclass=utils.OpenEnumMeta):
    r"""The balance's ISO 4217 currency code."""

    EUR = "EUR"
    GBP = "GBP"
    CHF = "CHF"
    DKK = "DKK"
    NOK = "NOK"
    PLN = "PLN"
    SEK = "SEK"
    USD = "USD"
    CZK = "CZK"
    HUF = "HUF"
    AUD = "AUD"
    CAD = "CAD"


class GetBalanceStatus(str, Enum, metaclass=utils.OpenEnumMeta):
    r"""The status of the balance."""

    ACTIVE = "active"
    INACTIVE = "inactive"


class GetBalanceTransferFrequency(str, Enum, metaclass=utils.OpenEnumMeta):
    r"""The frequency with which the available amount on the balance will be settled to the configured transfer
    destination.

    Settlements created during weekends or on bank holidays will take place on the next business day.
    """

    DAILY = "daily"
    EVERY_MONDAY = "every-monday"
    EVERY_TUESDAY = "every-tuesday"
    EVERY_WEDNESDAY = "every-wednesday"
    EVERY_THURSDAY = "every-thursday"
    EVERY_FRIDAY = "every-friday"
    MONTHLY = "monthly"
    NEVER = "never"


class GetBalanceTransferThresholdTypedDict(TypedDict):
    r"""The minimum amount configured for scheduled automatic settlements. As soon as the amount on the balance exceeds
    this threshold, the complete balance will be paid out to the transfer destination according to the configured
    frequency.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GetBalanceTransferThreshold(BaseModel):
    r"""The minimum amount configured for scheduled automatic settlements. As soon as the amount on the balance exceeds
    this threshold, the complete balance will be paid out to the transfer destination according to the configured
    frequency.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GetBalanceType(str, Enum, metaclass=utils.OpenEnumMeta):
    r"""The default destination of automatic scheduled transfers. Currently only `bank-account` is supported.

    * `bank-account` — Transfer the balance amount to an external bank account
    """

    BANK_ACCOUNT = "bank-account"


class GetBalanceTransferDestinationTypedDict(TypedDict):
    r"""The destination where the available amount will be automatically transferred to according to the configured
    transfer frequency.
    """

    type: NotRequired[GetBalanceType]
    r"""The default destination of automatic scheduled transfers. Currently only `bank-account` is supported.

    * `bank-account` — Transfer the balance amount to an external bank account
    """
    bank_account: NotRequired[str]
    r"""The configured bank account number of the beneficiary the balance amount is to be transferred to."""
    beneficiary_name: NotRequired[str]
    r"""The full name of the beneficiary the balance amount is to be transferred to."""


class GetBalanceTransferDestination(BaseModel):
    r"""The destination where the available amount will be automatically transferred to according to the configured
    transfer frequency.
    """

    type: Annotated[
        Optional[GetBalanceType], PlainValidator(validate_open_enum(False))
    ] = None
    r"""The default destination of automatic scheduled transfers. Currently only `bank-account` is supported.

    * `bank-account` — Transfer the balance amount to an external bank account
    """

    bank_account: Annotated[Optional[str], pydantic.Field(alias="bankAccount")] = None
    r"""The configured bank account number of the beneficiary the balance amount is to be transferred to."""

    beneficiary_name: Annotated[
        Optional[str], pydantic.Field(alias="beneficiaryName")
    ] = None
    r"""The full name of the beneficiary the balance amount is to be transferred to."""


class GetBalanceAvailableAmountTypedDict(TypedDict):
    r"""The amount directly available on the balance, e.g. `{\"currency\":\"EUR\", \"value\":\"100.00\"}`."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GetBalanceAvailableAmount(BaseModel):
    r"""The amount directly available on the balance, e.g. `{\"currency\":\"EUR\", \"value\":\"100.00\"}`."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GetBalancePendingAmountTypedDict(TypedDict):
    r"""The total amount that is queued to be transferred to your balance. For example, a credit card payment can take a
    few days to clear.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GetBalancePendingAmount(BaseModel):
    r"""The total amount that is queued to be transferred to your balance. For example, a credit card payment can take a
    few days to clear.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GetBalanceSelfTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetBalanceSelf(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetBalanceDocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetBalanceDocumentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetBalanceLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: NotRequired[GetBalanceSelfTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    documentation: NotRequired[GetBalanceDocumentationTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class GetBalanceLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[Optional[GetBalanceSelf], pydantic.Field(alias="self")] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    documentation: Optional[GetBalanceDocumentation] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class GetBalanceResponseTypedDict(TypedDict):
    r"""The balance object."""

    resource: NotRequired[str]
    r"""Indicates the response contains a balance object. Will always contain the string `balance` for this endpoint."""
    id: NotRequired[str]
    r"""The identifier uniquely referring to this balance."""
    mode: NotRequired[GetBalanceMode]
    r"""Whether this entity was created in live mode or in test mode."""
    created_at: NotRequired[str]
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""
    currency: NotRequired[GetBalanceCurrency]
    r"""The balance's ISO 4217 currency code."""
    description: NotRequired[str]
    r"""The description or name of the balance. Can be used to denote the purpose of the balance."""
    status: NotRequired[GetBalanceStatus]
    r"""The status of the balance."""
    transfer_frequency: NotRequired[GetBalanceTransferFrequency]
    r"""The frequency with which the available amount on the balance will be settled to the configured transfer
    destination.

    Settlements created during weekends or on bank holidays will take place on the next business day.
    """
    transfer_threshold: NotRequired[GetBalanceTransferThresholdTypedDict]
    r"""The minimum amount configured for scheduled automatic settlements. As soon as the amount on the balance exceeds
    this threshold, the complete balance will be paid out to the transfer destination according to the configured
    frequency.
    """
    transfer_reference: NotRequired[Nullable[str]]
    r"""The transfer reference set to be included in all the transfers for this balance."""
    transfer_destination: NotRequired[Nullable[GetBalanceTransferDestinationTypedDict]]
    r"""The destination where the available amount will be automatically transferred to according to the configured
    transfer frequency.
    """
    available_amount: NotRequired[GetBalanceAvailableAmountTypedDict]
    r"""The amount directly available on the balance, e.g. `{\"currency\":\"EUR\", \"value\":\"100.00\"}`."""
    pending_amount: NotRequired[GetBalancePendingAmountTypedDict]
    r"""The total amount that is queued to be transferred to your balance. For example, a credit card payment can take a
    few days to clear.
    """
    links: NotRequired[GetBalanceLinksTypedDict]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""


class GetBalanceResponse(BaseModel):
    r"""The balance object."""

    resource: Optional[str] = None
    r"""Indicates the response contains a balance object. Will always contain the string `balance` for this endpoint."""

    id: Optional[str] = None
    r"""The identifier uniquely referring to this balance."""

    mode: Annotated[
        Optional[GetBalanceMode], PlainValidator(validate_open_enum(False))
    ] = None
    r"""Whether this entity was created in live mode or in test mode."""

    created_at: Annotated[Optional[str], pydantic.Field(alias="createdAt")] = None
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""

    currency: Annotated[
        Optional[GetBalanceCurrency], PlainValidator(validate_open_enum(False))
    ] = None
    r"""The balance's ISO 4217 currency code."""

    description: Optional[str] = None
    r"""The description or name of the balance. Can be used to denote the purpose of the balance."""

    status: Annotated[
        Optional[GetBalanceStatus], PlainValidator(validate_open_enum(False))
    ] = None
    r"""The status of the balance."""

    transfer_frequency: Annotated[
        Annotated[
            Optional[GetBalanceTransferFrequency],
            PlainValidator(validate_open_enum(False)),
        ],
        pydantic.Field(alias="transferFrequency"),
    ] = None
    r"""The frequency with which the available amount on the balance will be settled to the configured transfer
    destination.

    Settlements created during weekends or on bank holidays will take place on the next business day.
    """

    transfer_threshold: Annotated[
        Optional[GetBalanceTransferThreshold], pydantic.Field(alias="transferThreshold")
    ] = None
    r"""The minimum amount configured for scheduled automatic settlements. As soon as the amount on the balance exceeds
    this threshold, the complete balance will be paid out to the transfer destination according to the configured
    frequency.
    """

    transfer_reference: Annotated[
        OptionalNullable[str], pydantic.Field(alias="transferReference")
    ] = UNSET
    r"""The transfer reference set to be included in all the transfers for this balance."""

    transfer_destination: Annotated[
        OptionalNullable[GetBalanceTransferDestination],
        pydantic.Field(alias="transferDestination"),
    ] = UNSET
    r"""The destination where the available amount will be automatically transferred to according to the configured
    transfer frequency.
    """

    available_amount: Annotated[
        Optional[GetBalanceAvailableAmount], pydantic.Field(alias="availableAmount")
    ] = None
    r"""The amount directly available on the balance, e.g. `{\"currency\":\"EUR\", \"value\":\"100.00\"}`."""

    pending_amount: Annotated[
        Optional[GetBalancePendingAmount], pydantic.Field(alias="pendingAmount")
    ] = None
    r"""The total amount that is queued to be transferred to your balance. For example, a credit card payment can take a
    few days to clear.
    """

    links: Annotated[Optional[GetBalanceLinks], pydantic.Field(alias="_links")] = None
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "resource",
            "id",
            "mode",
            "createdAt",
            "currency",
            "description",
            "status",
            "transferFrequency",
            "transferThreshold",
            "transferReference",
            "transferDestination",
            "availableAmount",
            "pendingAmount",
            "_links",
        ]
        nullable_fields = ["transferReference", "transferDestination"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
