"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
import httpx
from mollie import utils
from mollie.models import ClientError
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import FieldMetadata, PathParamMetadata, validate_open_enum
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import PlainValidator
from typing import Any, Dict, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class GetSettlementRequestTypedDict(TypedDict):
    id: str
    r"""Provide the ID of the item you want to perform this operation on."""


class GetSettlementRequest(BaseModel):
    id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""Provide the ID of the item you want to perform this operation on."""


class GetSettlementNotFoundDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str
    type: str


class GetSettlementNotFoundDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str

    type: str


class GetSettlementNotFoundLinksTypedDict(TypedDict):
    documentation: GetSettlementNotFoundDocumentationTypedDict
    r"""The URL to the generic Mollie API error handling guide."""


class GetSettlementNotFoundLinks(BaseModel):
    documentation: GetSettlementNotFoundDocumentation
    r"""The URL to the generic Mollie API error handling guide."""


class GetSettlementHalJSONErrorData(BaseModel):
    status: int
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: str
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: str
    r"""A detailed human-readable description of the error that occurred."""

    links: Annotated[GetSettlementNotFoundLinks, pydantic.Field(alias="_links")]

    field: Optional[str] = None
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name
    of the field that caused the issue.
    """


class GetSettlementHalJSONError(ClientError):
    r"""An error response object."""

    data: GetSettlementHalJSONErrorData

    def __init__(
        self,
        data: GetSettlementHalJSONErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        message = body or raw_response.text
        super().__init__(message, raw_response, body)
        self.data = data


class GetSettlementStatus(str, Enum, metaclass=utils.OpenEnumMeta):
    r"""The status of the settlement."""

    OPEN = "open"
    PENDING = "pending"
    PAIDOUT = "paidout"
    FAILED = "failed"


class GetSettlementAmountTypedDict(TypedDict):
    r"""The total amount of the settlement."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GetSettlementAmount(BaseModel):
    r"""The total amount of the settlement."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GetSettlementSelfTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetSettlementSelf(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetSettlementPaymentsTypedDict(TypedDict):
    r"""The API resource URL of the [payments](list-payments) included in this settlement."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetSettlementPayments(BaseModel):
    r"""The API resource URL of the [payments](list-payments) included in this settlement."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetSettlementCapturesTypedDict(TypedDict):
    r"""The API resource URL of the [captures](list-captures) included in this settlement."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetSettlementCaptures(BaseModel):
    r"""The API resource URL of the [captures](list-captures) included in this settlement."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetSettlementRefundsTypedDict(TypedDict):
    r"""The API resource URL of the [refunds](list-refunds) deducted from this settlement."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetSettlementRefunds(BaseModel):
    r"""The API resource URL of the [refunds](list-refunds) deducted from this settlement."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetSettlementChargebacksTypedDict(TypedDict):
    r"""The API resource URL of the [chargebacks](list-chargebacks) deducted from this settlement."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetSettlementChargebacks(BaseModel):
    r"""The API resource URL of the [chargebacks](list-chargebacks) deducted from this settlement."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetSettlementInvoiceTypedDict(TypedDict):
    r"""The API resource URL of the [invoice](list-invoices)."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class GetSettlementInvoice(BaseModel):
    r"""The API resource URL of the [invoice](list-invoices)."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class GetSettlementDocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetSettlementDocumentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetSettlementLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: NotRequired[GetSettlementSelfTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    payments: NotRequired[GetSettlementPaymentsTypedDict]
    r"""The API resource URL of the [payments](list-payments) included in this settlement."""
    captures: NotRequired[GetSettlementCapturesTypedDict]
    r"""The API resource URL of the [captures](list-captures) included in this settlement."""
    refunds: NotRequired[GetSettlementRefundsTypedDict]
    r"""The API resource URL of the [refunds](list-refunds) deducted from this settlement."""
    chargebacks: NotRequired[GetSettlementChargebacksTypedDict]
    r"""The API resource URL of the [chargebacks](list-chargebacks) deducted from this settlement."""
    invoice: NotRequired[Nullable[GetSettlementInvoiceTypedDict]]
    r"""The API resource URL of the [invoice](list-invoices)."""
    documentation: NotRequired[GetSettlementDocumentationTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class GetSettlementLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[Optional[GetSettlementSelf], pydantic.Field(alias="self")] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    payments: Optional[GetSettlementPayments] = None
    r"""The API resource URL of the [payments](list-payments) included in this settlement."""

    captures: Optional[GetSettlementCaptures] = None
    r"""The API resource URL of the [captures](list-captures) included in this settlement."""

    refunds: Optional[GetSettlementRefunds] = None
    r"""The API resource URL of the [refunds](list-refunds) deducted from this settlement."""

    chargebacks: Optional[GetSettlementChargebacks] = None
    r"""The API resource URL of the [chargebacks](list-chargebacks) deducted from this settlement."""

    invoice: OptionalNullable[GetSettlementInvoice] = UNSET
    r"""The API resource URL of the [invoice](list-invoices)."""

    documentation: Optional[GetSettlementDocumentation] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "self",
            "payments",
            "captures",
            "refunds",
            "chargebacks",
            "invoice",
            "documentation",
        ]
        nullable_fields = ["invoice"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetSettlementResponseTypedDict(TypedDict):
    r"""The settlement object."""

    resource: NotRequired[str]
    r"""Indicates the response contains a settlement object. Will always contain the string `settlement` for this
    endpoint.
    """
    id: NotRequired[str]
    r"""The identifier uniquely referring to this settlement."""
    created_at: NotRequired[str]
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""
    reference: NotRequired[Nullable[str]]
    r"""The settlement's bank reference, as found in your Mollie account and on your bank statement."""
    settled_at: NotRequired[Nullable[str]]
    r"""The date on which the settlement was settled, in ISO 8601 format.

    For an [open settlement](get-open-settlement) or for the [next settlement](get-next-settlement), no settlement
    date is available.
    """
    status: NotRequired[GetSettlementStatus]
    r"""The status of the settlement."""
    amount: NotRequired[GetSettlementAmountTypedDict]
    r"""The total amount of the settlement."""
    balance_id: NotRequired[str]
    r"""The balance token that the settlement was settled to."""
    invoice_id: NotRequired[Nullable[str]]
    r"""The ID of the oldest invoice created for all the periods, if the invoice has been created yet."""
    periods: NotRequired[Dict[str, Any]]
    r"""For bookkeeping purposes, the settlement includes an overview of transactions included in the settlement. These
    transactions are grouped into 'period' objects — one for each calendar month.

    For example, if a settlement includes funds from 15 April until 4 May, it will include two period objects. One for
    all transactions processed between 15 April and 30 April, and one for all transactions between 1 May and 4 May.

    Period objects are grouped by year, and then by month. So in the above example, the full `periods` collection will
    look as follows: `{\"2024\": {\"04\": {...}, \"05\": {...}}}`. The year and month in this documentation are referred as `<year>` and `<month>`.

    The example response should give a good idea of what this looks like in practise.
    """
    links: NotRequired[GetSettlementLinksTypedDict]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""


class GetSettlementResponse(BaseModel):
    r"""The settlement object."""

    resource: Optional[str] = None
    r"""Indicates the response contains a settlement object. Will always contain the string `settlement` for this
    endpoint.
    """

    id: Optional[str] = None
    r"""The identifier uniquely referring to this settlement."""

    created_at: Annotated[Optional[str], pydantic.Field(alias="createdAt")] = None
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""

    reference: OptionalNullable[str] = UNSET
    r"""The settlement's bank reference, as found in your Mollie account and on your bank statement."""

    settled_at: Annotated[OptionalNullable[str], pydantic.Field(alias="settledAt")] = (
        UNSET
    )
    r"""The date on which the settlement was settled, in ISO 8601 format.

    For an [open settlement](get-open-settlement) or for the [next settlement](get-next-settlement), no settlement
    date is available.
    """

    status: Annotated[
        Optional[GetSettlementStatus], PlainValidator(validate_open_enum(False))
    ] = None
    r"""The status of the settlement."""

    amount: Optional[GetSettlementAmount] = None
    r"""The total amount of the settlement."""

    balance_id: Annotated[Optional[str], pydantic.Field(alias="balanceId")] = None
    r"""The balance token that the settlement was settled to."""

    invoice_id: Annotated[OptionalNullable[str], pydantic.Field(alias="invoiceId")] = (
        UNSET
    )
    r"""The ID of the oldest invoice created for all the periods, if the invoice has been created yet."""

    periods: Optional[Dict[str, Any]] = None
    r"""For bookkeeping purposes, the settlement includes an overview of transactions included in the settlement. These
    transactions are grouped into 'period' objects — one for each calendar month.

    For example, if a settlement includes funds from 15 April until 4 May, it will include two period objects. One for
    all transactions processed between 15 April and 30 April, and one for all transactions between 1 May and 4 May.

    Period objects are grouped by year, and then by month. So in the above example, the full `periods` collection will
    look as follows: `{\"2024\": {\"04\": {...}, \"05\": {...}}}`. The year and month in this documentation are referred as `<year>` and `<month>`.

    The example response should give a good idea of what this looks like in practise.
    """

    links: Annotated[Optional[GetSettlementLinks], pydantic.Field(alias="_links")] = (
        None
    )
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "resource",
            "id",
            "createdAt",
            "reference",
            "settledAt",
            "status",
            "amount",
            "balanceId",
            "invoiceId",
            "periods",
            "_links",
        ]
        nullable_fields = ["reference", "settledAt", "invoiceId"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
