"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
import httpx
from mollie import utils
from mollie.models import ClientError
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import (
    FieldMetadata,
    PathParamMetadata,
    QueryParamMetadata,
    validate_open_enum,
)
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import PlainValidator
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class GetWebhookRequestTypedDict(TypedDict):
    id: str
    r"""Provide the ID of the item you want to perform this operation on."""
    testmode: NotRequired[Nullable[bool]]
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query
    parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by
    setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """


class GetWebhookRequest(BaseModel):
    id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""Provide the ID of the item you want to perform this operation on."""

    testmode: Annotated[
        OptionalNullable[bool],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query
    parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by
    setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["testmode"]
        nullable_fields = ["testmode"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetWebhookUnprocessableEntityDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str
    type: str


class GetWebhookUnprocessableEntityDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str

    type: str


class GetWebhookUnprocessableEntityLinksTypedDict(TypedDict):
    documentation: GetWebhookUnprocessableEntityDocumentationTypedDict
    r"""The URL to the generic Mollie API error handling guide."""


class GetWebhookUnprocessableEntityLinks(BaseModel):
    documentation: GetWebhookUnprocessableEntityDocumentation
    r"""The URL to the generic Mollie API error handling guide."""


class GetWebhookUnprocessableEntityHalJSONErrorData(BaseModel):
    status: int
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: str
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: str
    r"""A detailed human-readable description of the error that occurred."""

    links: Annotated[GetWebhookUnprocessableEntityLinks, pydantic.Field(alias="_links")]

    field: Optional[str] = None
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name
    of the field that caused the issue.
    """


class GetWebhookUnprocessableEntityHalJSONError(ClientError):
    r"""An error response object."""

    data: GetWebhookUnprocessableEntityHalJSONErrorData

    def __init__(
        self,
        data: GetWebhookUnprocessableEntityHalJSONErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        message = body or raw_response.text
        super().__init__(message, raw_response, body)
        self.data = data


class GetWebhookNotFoundDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str
    type: str


class GetWebhookNotFoundDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str

    type: str


class GetWebhookNotFoundLinksTypedDict(TypedDict):
    documentation: GetWebhookNotFoundDocumentationTypedDict
    r"""The URL to the generic Mollie API error handling guide."""


class GetWebhookNotFoundLinks(BaseModel):
    documentation: GetWebhookNotFoundDocumentation
    r"""The URL to the generic Mollie API error handling guide."""


class GetWebhookNotFoundHalJSONErrorData(BaseModel):
    status: int
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: str
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: str
    r"""A detailed human-readable description of the error that occurred."""

    links: Annotated[GetWebhookNotFoundLinks, pydantic.Field(alias="_links")]

    field: Optional[str] = None
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name
    of the field that caused the issue.
    """


class GetWebhookNotFoundHalJSONError(ClientError):
    r"""An error response object."""

    data: GetWebhookNotFoundHalJSONErrorData

    def __init__(
        self,
        data: GetWebhookNotFoundHalJSONErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        message = body or raw_response.text
        super().__init__(message, raw_response, body)
        self.data = data


class GetWebhookWebhookEventTypes(str, Enum, metaclass=utils.OpenEnumMeta):
    r"""The event's type"""

    PAYMENT_LINK_PAID = "payment-link.paid"
    BALANCE_TRANSACTION_CREATED = "balance-transaction.created"
    SALES_INVOICE_CREATED = "sales-invoice.created"
    SALES_INVOICE_ISSUED = "sales-invoice.issued"
    SALES_INVOICE_CANCELED = "sales-invoice.canceled"
    SALES_INVOICE_PAID = "sales-invoice.paid"
    WILDCARD_ = "*"


class GetWebhookStatus(str, Enum, metaclass=utils.OpenEnumMeta):
    r"""The subscription's current status."""

    ENABLED = "enabled"
    BLOCKED = "blocked"
    DISABLED = "disabled"
    DELETED = "deleted"


class GetWebhookMode(str, Enum, metaclass=utils.OpenEnumMeta):
    r"""Whether this entity was created in live mode or in test mode."""

    LIVE = "live"
    TEST = "test"


class GetWebhookDocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetWebhookDocumentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetWebhookLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    documentation: GetWebhookDocumentationTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class GetWebhookLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    documentation: GetWebhookDocumentation
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class GetWebhookResponseTypedDict(TypedDict):
    r"""The webhook object."""

    resource: str
    r"""Indicates the response contains a webhook subscription object.
    Will always contain the string `webhook` for this endpoint.
    """
    id: str
    r"""The identifier uniquely referring to this subscription."""
    url: str
    r"""The subscription's events destination."""
    profile_id: Nullable[str]
    r"""The identifier uniquely referring to the profile that created the subscription."""
    created_at: str
    r"""The subscription's date time of creation."""
    name: str
    r"""The subscription's name."""
    event_types: List[GetWebhookWebhookEventTypes]
    r"""The events types that are subscribed."""
    status: GetWebhookStatus
    r"""The subscription's current status."""
    mode: GetWebhookMode
    r"""Whether this entity was created in live mode or in test mode."""
    links: GetWebhookLinksTypedDict
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""


class GetWebhookResponse(BaseModel):
    r"""The webhook object."""

    resource: str
    r"""Indicates the response contains a webhook subscription object.
    Will always contain the string `webhook` for this endpoint.
    """

    id: str
    r"""The identifier uniquely referring to this subscription."""

    url: str
    r"""The subscription's events destination."""

    profile_id: Annotated[Nullable[str], pydantic.Field(alias="profileId")]
    r"""The identifier uniquely referring to the profile that created the subscription."""

    created_at: Annotated[str, pydantic.Field(alias="createdAt")]
    r"""The subscription's date time of creation."""

    name: str
    r"""The subscription's name."""

    event_types: Annotated[
        List[
            Annotated[
                GetWebhookWebhookEventTypes, PlainValidator(validate_open_enum(False))
            ]
        ],
        pydantic.Field(alias="eventTypes"),
    ]
    r"""The events types that are subscribed."""

    status: Annotated[GetWebhookStatus, PlainValidator(validate_open_enum(False))]
    r"""The subscription's current status."""

    mode: Annotated[GetWebhookMode, PlainValidator(validate_open_enum(False))]
    r"""Whether this entity was created in live mode or in test mode."""

    links: Annotated[GetWebhookLinks, pydantic.Field(alias="_links")]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["profileId"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
