"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
import httpx
from mollie import utils
from mollie.models import ClientError
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import (
    FieldMetadata,
    PathParamMetadata,
    QueryParamMetadata,
    validate_open_enum,
)
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import PlainValidator
from typing import Any, Dict, List, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


class ListRefundsEmbed(str, Enum):
    r"""This endpoint allows embedding related API items by appending the following values via the `embed` query string
    parameter.
    """

    PAYMENT = "payment"


class ListRefundsRequestTypedDict(TypedDict):
    payment_id: str
    r"""Provide the ID of the related payment."""
    from_: NotRequired[str]
    r"""Provide an ID to start the result set from the item with the given ID and onwards. This allows you to paginate the
    result set.
    """
    limit: NotRequired[Nullable[int]]
    r"""The maximum number of items to return. Defaults to 50 items."""
    embed: NotRequired[ListRefundsEmbed]
    r"""This endpoint allows embedding related API items by appending the following values via the `embed` query string
    parameter.
    """
    testmode: NotRequired[Nullable[bool]]
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query
    parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by
    setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """


class ListRefundsRequest(BaseModel):
    payment_id: Annotated[
        str,
        pydantic.Field(alias="paymentId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""Provide the ID of the related payment."""

    from_: Annotated[
        Optional[str],
        pydantic.Field(alias="from"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Provide an ID to start the result set from the item with the given ID and onwards. This allows you to paginate the
    result set.
    """

    limit: Annotated[
        OptionalNullable[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""The maximum number of items to return. Defaults to 50 items."""

    embed: Annotated[
        Optional[ListRefundsEmbed],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""This endpoint allows embedding related API items by appending the following values via the `embed` query string
    parameter.
    """

    testmode: Annotated[
        OptionalNullable[bool],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query
    parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by
    setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["from", "limit", "embed", "testmode"]
        nullable_fields = ["limit", "testmode"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListRefundsNotFoundDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str
    type: str


class ListRefundsNotFoundDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str

    type: str


class ListRefundsNotFoundLinksTypedDict(TypedDict):
    documentation: ListRefundsNotFoundDocumentationTypedDict
    r"""The URL to the generic Mollie API error handling guide."""


class ListRefundsNotFoundLinks(BaseModel):
    documentation: ListRefundsNotFoundDocumentation
    r"""The URL to the generic Mollie API error handling guide."""


class ListRefundsNotFoundHalJSONErrorData(BaseModel):
    status: int
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: str
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: str
    r"""A detailed human-readable description of the error that occurred."""

    links: Annotated[ListRefundsNotFoundLinks, pydantic.Field(alias="_links")]

    field: Optional[str] = None
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name
    of the field that caused the issue.
    """


class ListRefundsNotFoundHalJSONError(ClientError):
    r"""An error response object."""

    data: ListRefundsNotFoundHalJSONErrorData

    def __init__(
        self,
        data: ListRefundsNotFoundHalJSONErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        message = body or raw_response.text
        super().__init__(message, raw_response, body)
        self.data = data


class ListRefundsBadRequestDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str
    type: str


class ListRefundsBadRequestDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str

    type: str


class ListRefundsBadRequestLinksTypedDict(TypedDict):
    documentation: ListRefundsBadRequestDocumentationTypedDict
    r"""The URL to the generic Mollie API error handling guide."""


class ListRefundsBadRequestLinks(BaseModel):
    documentation: ListRefundsBadRequestDocumentation
    r"""The URL to the generic Mollie API error handling guide."""


class ListRefundsBadRequestHalJSONErrorData(BaseModel):
    status: int
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: str
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: str
    r"""A detailed human-readable description of the error that occurred."""

    links: Annotated[ListRefundsBadRequestLinks, pydantic.Field(alias="_links")]

    field: Optional[str] = None
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name
    of the field that caused the issue.
    """


class ListRefundsBadRequestHalJSONError(ClientError):
    r"""An error response object."""

    data: ListRefundsBadRequestHalJSONErrorData

    def __init__(
        self,
        data: ListRefundsBadRequestHalJSONErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        message = body or raw_response.text
        super().__init__(message, raw_response, body)
        self.data = data


class ListRefundsMode(str, Enum, metaclass=utils.OpenEnumMeta):
    r"""Whether this entity was created in live mode or in test mode."""

    LIVE = "live"
    TEST = "test"


class ListRefundsAmountTypedDict(TypedDict):
    r"""The amount refunded to your customer with this refund. The amount is allowed to be lower than the original payment
    amount.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class ListRefundsAmount(BaseModel):
    r"""The amount refunded to your customer with this refund. The amount is allowed to be lower than the original payment
    amount.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class ListRefundsSettlementAmountTypedDict(TypedDict):
    r"""This optional field will contain the approximate amount that will be deducted from your account balance, converted
    to the currency your account is settled in.

    The amount is a **negative** amount.

    If the refund is not directly processed by Mollie, for example for PayPal refunds, the settlement amount will be
    zero.

    Since the field contains an estimated amount during refund processing, it may change over time. For example, while
    the refund is queued the settlement amount is likely not yet available.

    To retrieve accurate settlement amounts we recommend using the
    [List balance transactions endpoint](list-balance-transactions) instead.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class ListRefundsSettlementAmount(BaseModel):
    r"""This optional field will contain the approximate amount that will be deducted from your account balance, converted
    to the currency your account is settled in.

    The amount is a **negative** amount.

    If the refund is not directly processed by Mollie, for example for PayPal refunds, the settlement amount will be
    zero.

    Since the field contains an estimated amount during refund processing, it may change over time. For example, while
    the refund is queued the settlement amount is likely not yet available.

    To retrieve accurate settlement amounts we recommend using the
    [List balance transactions endpoint](list-balance-transactions) instead.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


ListRefundsMetadataTypedDict = TypeAliasType(
    "ListRefundsMetadataTypedDict", Union[str, Dict[str, Any], List[str]]
)
r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever
you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB.
"""


ListRefundsMetadata = TypeAliasType(
    "ListRefundsMetadata", Union[str, Dict[str, Any], List[str]]
)
r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever
you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB.
"""


class ListRefundsStatus(str, Enum, metaclass=utils.OpenEnumMeta):
    r"""Refunds may take some time to get confirmed."""

    QUEUED = "queued"
    PENDING = "pending"
    PROCESSING = "processing"
    REFUNDED = "refunded"
    FAILED = "failed"
    CANCELED = "canceled"


class ListRefundsType(str, Enum, metaclass=utils.OpenEnumMeta):
    r"""Specifies the reference type"""

    ACQUIRER_REFERENCE = "acquirer-reference"


class ListRefundsExternalReferenceTypedDict(TypedDict):
    type: NotRequired[ListRefundsType]
    r"""Specifies the reference type"""
    id: NotRequired[str]
    r"""Unique reference from the payment provider"""


class ListRefundsExternalReference(BaseModel):
    type: Annotated[
        Optional[ListRefundsType], PlainValidator(validate_open_enum(False))
    ] = None
    r"""Specifies the reference type"""

    id: Optional[str] = None
    r"""Unique reference from the payment provider"""


class ListRefundsRoutingReversalAmountTypedDict(TypedDict):
    r"""The amount that will be pulled back."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class ListRefundsRoutingReversalAmount(BaseModel):
    r"""The amount that will be pulled back."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class ListRefundsSourceTypedDict(TypedDict):
    r"""Where the funds will be pulled back from."""

    organization_id: NotRequired[str]
    r"""Required for source type `organization`. The ID of the connected organization the funds should be pulled
    back from.
    """


class ListRefundsSource(BaseModel):
    r"""Where the funds will be pulled back from."""

    organization_id: Annotated[
        Optional[str], pydantic.Field(alias="organizationId")
    ] = None
    r"""Required for source type `organization`. The ID of the connected organization the funds should be pulled
    back from.
    """


class ListRefundsRoutingReversalTypedDict(TypedDict):
    amount: NotRequired[ListRefundsRoutingReversalAmountTypedDict]
    r"""The amount that will be pulled back."""
    source: NotRequired[ListRefundsSourceTypedDict]
    r"""Where the funds will be pulled back from."""


class ListRefundsRoutingReversal(BaseModel):
    amount: Optional[ListRefundsRoutingReversalAmount] = None
    r"""The amount that will be pulled back."""

    source: Optional[ListRefundsSource] = None
    r"""Where the funds will be pulled back from."""


class ListRefundsRefundSelfTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListRefundsRefundSelf(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListRefundsPaymentTypedDict(TypedDict):
    r"""The API resource URL of the [payment](get-payment) that this refund belongs to."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListRefundsPayment(BaseModel):
    r"""The API resource URL of the [payment](get-payment) that this refund belongs to."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListRefundsSettlementTypedDict(TypedDict):
    r"""The API resource URL of the [settlement](get-settlement) this refund has been settled with. Not present if not
    yet settled.
    """

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class ListRefundsSettlement(BaseModel):
    r"""The API resource URL of the [settlement](get-settlement) this refund has been settled with. Not present if not
    yet settled.
    """

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class ListRefundsRefundDocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListRefundsRefundDocumentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListRefundsRefundLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: ListRefundsRefundSelfTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    payment: ListRefundsPaymentTypedDict
    r"""The API resource URL of the [payment](get-payment) that this refund belongs to."""
    documentation: ListRefundsRefundDocumentationTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    settlement: NotRequired[Nullable[ListRefundsSettlementTypedDict]]
    r"""The API resource URL of the [settlement](get-settlement) this refund has been settled with. Not present if not
    yet settled.
    """


class ListRefundsRefundLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[ListRefundsRefundSelf, pydantic.Field(alias="self")]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    payment: ListRefundsPayment
    r"""The API resource URL of the [payment](get-payment) that this refund belongs to."""

    documentation: ListRefundsRefundDocumentation
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    settlement: OptionalNullable[ListRefundsSettlement] = UNSET
    r"""The API resource URL of the [settlement](get-settlement) this refund has been settled with. Not present if not
    yet settled.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["settlement"]
        nullable_fields = ["settlement"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListRefundsRefundTypedDict(TypedDict):
    resource: NotRequired[str]
    r"""Indicates the response contains a refund object. Will always contain the string `refund` for this endpoint."""
    id: NotRequired[str]
    r"""The identifier uniquely referring to this refund. Mollie assigns this identifier at refund creation time. Mollie
    will always refer to the refund by this ID. Example: `re_4qqhO89gsT`.
    """
    mode: NotRequired[ListRefundsMode]
    r"""Whether this entity was created in live mode or in test mode."""
    description: NotRequired[str]
    r"""The description of the refund that may be shown to your customer, depending on the payment method used."""
    amount: NotRequired[ListRefundsAmountTypedDict]
    r"""The amount refunded to your customer with this refund. The amount is allowed to be lower than the original payment
    amount.
    """
    settlement_amount: NotRequired[Nullable[ListRefundsSettlementAmountTypedDict]]
    r"""This optional field will contain the approximate amount that will be deducted from your account balance, converted
    to the currency your account is settled in.

    The amount is a **negative** amount.

    If the refund is not directly processed by Mollie, for example for PayPal refunds, the settlement amount will be
    zero.

    Since the field contains an estimated amount during refund processing, it may change over time. For example, while
    the refund is queued the settlement amount is likely not yet available.

    To retrieve accurate settlement amounts we recommend using the
    [List balance transactions endpoint](list-balance-transactions) instead.
    """
    metadata: NotRequired[Nullable[ListRefundsMetadataTypedDict]]
    r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever
    you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB.
    """
    payment_id: NotRequired[str]
    r"""The unique identifier of the payment this refund was created for.
    The full payment object can be retrieved via the payment URL in the `_links` object.
    """
    settlement_id: NotRequired[Nullable[str]]
    r"""The identifier referring to the settlement this refund was settled with. This field is omitted if the refund is not settled (yet)."""
    status: NotRequired[ListRefundsStatus]
    r"""Refunds may take some time to get confirmed."""
    created_at: NotRequired[str]
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""
    external_reference: NotRequired[ListRefundsExternalReferenceTypedDict]
    routing_reversals: NotRequired[Nullable[List[ListRefundsRoutingReversalTypedDict]]]
    r"""*This feature is only available to marketplace operators.*

    When creating refunds for *routed* payments, by default the full amount is deducted from your balance.

    If you want to pull back funds from the connected merchant(s), you can use this parameter to specify what amount
    needs to be reversed from which merchant(s).

    If you simply want to fully reverse the routed funds, you can also use the `reverseRouting` parameter instead.
    """
    links: NotRequired[ListRefundsRefundLinksTypedDict]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""


class ListRefundsRefund(BaseModel):
    resource: Optional[str] = None
    r"""Indicates the response contains a refund object. Will always contain the string `refund` for this endpoint."""

    id: Optional[str] = None
    r"""The identifier uniquely referring to this refund. Mollie assigns this identifier at refund creation time. Mollie
    will always refer to the refund by this ID. Example: `re_4qqhO89gsT`.
    """

    mode: Annotated[
        Optional[ListRefundsMode], PlainValidator(validate_open_enum(False))
    ] = None
    r"""Whether this entity was created in live mode or in test mode."""

    description: Optional[str] = None
    r"""The description of the refund that may be shown to your customer, depending on the payment method used."""

    amount: Optional[ListRefundsAmount] = None
    r"""The amount refunded to your customer with this refund. The amount is allowed to be lower than the original payment
    amount.
    """

    settlement_amount: Annotated[
        OptionalNullable[ListRefundsSettlementAmount],
        pydantic.Field(alias="settlementAmount"),
    ] = UNSET
    r"""This optional field will contain the approximate amount that will be deducted from your account balance, converted
    to the currency your account is settled in.

    The amount is a **negative** amount.

    If the refund is not directly processed by Mollie, for example for PayPal refunds, the settlement amount will be
    zero.

    Since the field contains an estimated amount during refund processing, it may change over time. For example, while
    the refund is queued the settlement amount is likely not yet available.

    To retrieve accurate settlement amounts we recommend using the
    [List balance transactions endpoint](list-balance-transactions) instead.
    """

    metadata: OptionalNullable[ListRefundsMetadata] = UNSET
    r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever
    you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB.
    """

    payment_id: Annotated[Optional[str], pydantic.Field(alias="paymentId")] = None
    r"""The unique identifier of the payment this refund was created for.
    The full payment object can be retrieved via the payment URL in the `_links` object.
    """

    settlement_id: Annotated[
        OptionalNullable[str], pydantic.Field(alias="settlementId")
    ] = UNSET
    r"""The identifier referring to the settlement this refund was settled with. This field is omitted if the refund is not settled (yet)."""

    status: Annotated[
        Optional[ListRefundsStatus], PlainValidator(validate_open_enum(False))
    ] = None
    r"""Refunds may take some time to get confirmed."""

    created_at: Annotated[Optional[str], pydantic.Field(alias="createdAt")] = None
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""

    external_reference: Annotated[
        Optional[ListRefundsExternalReference],
        pydantic.Field(alias="externalReference"),
    ] = None

    routing_reversals: Annotated[
        OptionalNullable[List[ListRefundsRoutingReversal]],
        pydantic.Field(alias="routingReversals"),
    ] = UNSET
    r"""*This feature is only available to marketplace operators.*

    When creating refunds for *routed* payments, by default the full amount is deducted from your balance.

    If you want to pull back funds from the connected merchant(s), you can use this parameter to specify what amount
    needs to be reversed from which merchant(s).

    If you simply want to fully reverse the routed funds, you can also use the `reverseRouting` parameter instead.
    """

    links: Annotated[
        Optional[ListRefundsRefundLinks], pydantic.Field(alias="_links")
    ] = None
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "resource",
            "id",
            "mode",
            "description",
            "amount",
            "settlementAmount",
            "metadata",
            "paymentId",
            "settlementId",
            "status",
            "createdAt",
            "externalReference",
            "routingReversals",
            "_links",
        ]
        nullable_fields = [
            "settlementAmount",
            "metadata",
            "settlementId",
            "routingReversals",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListRefundsEmbeddedTypedDict(TypedDict):
    refunds: NotRequired[List[ListRefundsRefundTypedDict]]
    r"""An array of refund objects."""


class ListRefundsEmbedded(BaseModel):
    refunds: Optional[List[ListRefundsRefund]] = None
    r"""An array of refund objects."""


class ListRefundsSelfTypedDict(TypedDict):
    r"""The URL to the current set of items."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListRefundsSelf(BaseModel):
    r"""The URL to the current set of items."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListRefundsPreviousTypedDict(TypedDict):
    r"""The previous set of items, if available."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class ListRefundsPrevious(BaseModel):
    r"""The previous set of items, if available."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class ListRefundsNextTypedDict(TypedDict):
    r"""The next set of items, if available."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class ListRefundsNext(BaseModel):
    r"""The next set of items, if available."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class ListRefundsDocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListRefundsDocumentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListRefundsLinksTypedDict(TypedDict):
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""

    self_: ListRefundsSelfTypedDict
    r"""The URL to the current set of items."""
    previous: Nullable[ListRefundsPreviousTypedDict]
    r"""The previous set of items, if available."""
    next: Nullable[ListRefundsNextTypedDict]
    r"""The next set of items, if available."""
    documentation: ListRefundsDocumentationTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class ListRefundsLinks(BaseModel):
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[ListRefundsSelf, pydantic.Field(alias="self")]
    r"""The URL to the current set of items."""

    previous: Nullable[ListRefundsPrevious]
    r"""The previous set of items, if available."""

    next: Nullable[ListRefundsNext]
    r"""The next set of items, if available."""

    documentation: ListRefundsDocumentation
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["previous", "next"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListRefundsResponseTypedDict(TypedDict):
    r"""A list of refund objects. For a complete reference of the refund object, refer to the
    [Get refund endpoint](get-refund) documentation.
    """

    count: NotRequired[int]
    r"""The number of items in this result set. If more items are available, a `_links.next` URL will be present in the result
    as well.

    The maximum number of items per result set is controlled by the `limit` property provided in the request. The default
    limit is 50 items.
    """
    embedded: NotRequired[ListRefundsEmbeddedTypedDict]
    links: NotRequired[ListRefundsLinksTypedDict]
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""


class ListRefundsResponse(BaseModel):
    r"""A list of refund objects. For a complete reference of the refund object, refer to the
    [Get refund endpoint](get-refund) documentation.
    """

    count: Optional[int] = None
    r"""The number of items in this result set. If more items are available, a `_links.next` URL will be present in the result
    as well.

    The maximum number of items per result set is controlled by the `limit` property provided in the request. The default
    limit is 50 items.
    """

    embedded: Annotated[
        Optional[ListRefundsEmbedded], pydantic.Field(alias="_embedded")
    ] = None

    links: Annotated[Optional[ListRefundsLinks], pydantic.Field(alias="_links")] = None
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""
