"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
import httpx
from mollie import utils
from mollie.models import ClientError
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import (
    FieldMetadata,
    PathParamMetadata,
    QueryParamMetadata,
    validate_open_enum,
)
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import PlainValidator
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class PaymentListRoutesRequestTypedDict(TypedDict):
    payment_id: str
    r"""Provide the ID of the related payment."""
    testmode: NotRequired[Nullable[bool]]
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query
    parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by
    setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """


class PaymentListRoutesRequest(BaseModel):
    payment_id: Annotated[
        str,
        pydantic.Field(alias="paymentId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""Provide the ID of the related payment."""

    testmode: Annotated[
        OptionalNullable[bool],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query
    parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by
    setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["testmode"]
        nullable_fields = ["testmode"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class PaymentListRoutesNotFoundDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str
    type: str


class PaymentListRoutesNotFoundDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str

    type: str


class PaymentListRoutesNotFoundLinksTypedDict(TypedDict):
    documentation: PaymentListRoutesNotFoundDocumentationTypedDict
    r"""The URL to the generic Mollie API error handling guide."""


class PaymentListRoutesNotFoundLinks(BaseModel):
    documentation: PaymentListRoutesNotFoundDocumentation
    r"""The URL to the generic Mollie API error handling guide."""


class PaymentListRoutesHalJSONErrorData(BaseModel):
    status: int
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: str
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: str
    r"""A detailed human-readable description of the error that occurred."""

    links: Annotated[PaymentListRoutesNotFoundLinks, pydantic.Field(alias="_links")]

    field: Optional[str] = None
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name
    of the field that caused the issue.
    """


class PaymentListRoutesHalJSONError(ClientError):
    r"""An error response object."""

    data: PaymentListRoutesHalJSONErrorData

    def __init__(
        self,
        data: PaymentListRoutesHalJSONErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        message = body or raw_response.text
        super().__init__(message, raw_response, body)
        self.data = data


class PaymentListRoutesAmountTypedDict(TypedDict):
    r"""The amount of the route.
    That amount that will be routed to the specified destination.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class PaymentListRoutesAmount(BaseModel):
    r"""The amount of the route.
    That amount that will be routed to the specified destination.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class PaymentListRoutesType(str, Enum, metaclass=utils.OpenEnumMeta):
    r"""The type of destination. Currently only the destination type `organization` is supported."""

    ORGANIZATION = "organization"


class PaymentListRoutesDestinationTypedDict(TypedDict):
    r"""The destination of the route."""

    type: PaymentListRoutesType
    r"""The type of destination. Currently only the destination type `organization` is supported."""
    organization_id: str
    r"""Required for destination type `organization`. The ID of the connected organization the funds should be
    routed to.
    """


class PaymentListRoutesDestination(BaseModel):
    r"""The destination of the route."""

    type: Annotated[PaymentListRoutesType, PlainValidator(validate_open_enum(False))]
    r"""The type of destination. Currently only the destination type `organization` is supported."""

    organization_id: Annotated[str, pydantic.Field(alias="organizationId")]
    r"""Required for destination type `organization`. The ID of the connected organization the funds should be
    routed to.
    """


class RouteSelfTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class RouteSelf(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class RouteDocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class RouteDocumentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class RouteLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: RouteSelfTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    documentation: RouteDocumentationTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class RouteLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[RouteSelf, pydantic.Field(alias="self")]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    documentation: RouteDocumentation
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class RouteTypedDict(TypedDict):
    resource: str
    r"""Indicates the response contains a route object. Will always contain the string `route` for this endpoint."""
    id: str
    r"""The identifier uniquely referring to this route. Mollie assigns this identifier at route creation time. Mollie
    will always refer to the route by this ID. Example: `crt_dyARQ3JzCgtPDhU2Pbq3J`.
    """
    payment_id: str
    r"""The unique identifier of the payment. For example: `tr_5B8cwPMGnU6qLbRvo7qEZo`.
    The full payment object can be retrieved via the payment URL in the `_links` object.
    """
    amount: PaymentListRoutesAmountTypedDict
    r"""The amount of the route.
    That amount that will be routed to the specified destination.
    """
    description: str
    r"""The description of the route. This description is shown in the reports."""
    destination: PaymentListRoutesDestinationTypedDict
    r"""The destination of the route."""
    links: RouteLinksTypedDict
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""
    created_at: str
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""


class Route(BaseModel):
    resource: str
    r"""Indicates the response contains a route object. Will always contain the string `route` for this endpoint."""

    id: str
    r"""The identifier uniquely referring to this route. Mollie assigns this identifier at route creation time. Mollie
    will always refer to the route by this ID. Example: `crt_dyARQ3JzCgtPDhU2Pbq3J`.
    """

    payment_id: Annotated[str, pydantic.Field(alias="paymentId")]
    r"""The unique identifier of the payment. For example: `tr_5B8cwPMGnU6qLbRvo7qEZo`.
    The full payment object can be retrieved via the payment URL in the `_links` object.
    """

    amount: PaymentListRoutesAmount
    r"""The amount of the route.
    That amount that will be routed to the specified destination.
    """

    description: str
    r"""The description of the route. This description is shown in the reports."""

    destination: PaymentListRoutesDestination
    r"""The destination of the route."""

    links: Annotated[RouteLinks, pydantic.Field(alias="_links")]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    created_at: Annotated[str, pydantic.Field(alias="createdAt")]
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""


class PaymentListRoutesEmbeddedTypedDict(TypedDict):
    routes: NotRequired[List[RouteTypedDict]]
    r"""An array of route objects."""


class PaymentListRoutesEmbedded(BaseModel):
    routes: Optional[List[Route]] = None
    r"""An array of route objects."""


class PaymentListRoutesSelfTypedDict(TypedDict):
    r"""The URL to the current set of items."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class PaymentListRoutesSelf(BaseModel):
    r"""The URL to the current set of items."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class PaymentListRoutesDocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class PaymentListRoutesDocumentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class PaymentListRoutesLinksTypedDict(TypedDict):
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""

    self_: NotRequired[PaymentListRoutesSelfTypedDict]
    r"""The URL to the current set of items."""
    documentation: NotRequired[PaymentListRoutesDocumentationTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class PaymentListRoutesLinks(BaseModel):
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[Optional[PaymentListRoutesSelf], pydantic.Field(alias="self")] = (
        None
    )
    r"""The URL to the current set of items."""

    documentation: Optional[PaymentListRoutesDocumentation] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class PaymentListRoutesResponseTypedDict(TypedDict):
    r"""A list of route objects."""

    count: NotRequired[int]
    r"""The number of items in this result set. If more items are available, a `_links.next` URL will be present in the result
    as well.

    The maximum number of items per result set is controlled by the `limit` property provided in the request. The default
    limit is 50 items.
    """
    embedded: NotRequired[PaymentListRoutesEmbeddedTypedDict]
    links: NotRequired[PaymentListRoutesLinksTypedDict]
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""


class PaymentListRoutesResponse(BaseModel):
    r"""A list of route objects."""

    count: Optional[int] = None
    r"""The number of items in this result set. If more items are available, a `_links.next` URL will be present in the result
    as well.

    The maximum number of items per result set is controlled by the `limit` property provided in the request. The default
    limit is 50 items.
    """

    embedded: Annotated[
        Optional[PaymentListRoutesEmbedded], pydantic.Field(alias="_embedded")
    ] = None

    links: Annotated[
        Optional[PaymentListRoutesLinks], pydantic.Field(alias="_links")
    ] = None
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""
