"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
import httpx
from mollie import utils
from mollie.models import ClientError
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import (
    FieldMetadata,
    PathParamMetadata,
    RequestMetadata,
    validate_open_enum,
)
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import PlainValidator
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class UpdateWebhookWebhookEventTypesRequest(str, Enum):
    r"""The list of events to enable for this webhook. You may specify `'*'` to add all events, except those
    that require explicit selection. Separate multiple event types with a comma.
    """

    PAYMENT_LINK_PAID = "payment-link.paid"
    BALANCE_TRANSACTION_CREATED = "balance-transaction.created"
    SALES_INVOICE_CREATED = "sales-invoice.created"
    SALES_INVOICE_ISSUED = "sales-invoice.issued"
    SALES_INVOICE_CANCELED = "sales-invoice.canceled"
    SALES_INVOICE_PAID = "sales-invoice.paid"
    WILDCARD_ = "*"


class UpdateWebhookRequestBodyTypedDict(TypedDict):
    name: NotRequired[str]
    r"""A name that identifies the webhook."""
    url: NotRequired[str]
    r"""The URL Mollie will send the events to. This URL must be publicly accessible."""
    webhook_event_types: NotRequired[UpdateWebhookWebhookEventTypesRequest]
    r"""The list of events to enable for this webhook. You may specify `'*'` to add all events, except those
    that require explicit selection. Separate multiple event types with a comma.
    """
    testmode: NotRequired[Nullable[bool]]
    r"""Most API credentials are specifically created for either live mode or test mode. For organization-level credentials
    such as OAuth access tokens, you can enable test mode by setting `testmode` to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """


class UpdateWebhookRequestBody(BaseModel):
    name: Optional[str] = None
    r"""A name that identifies the webhook."""

    url: Optional[str] = None
    r"""The URL Mollie will send the events to. This URL must be publicly accessible."""

    webhook_event_types: Annotated[
        Optional[UpdateWebhookWebhookEventTypesRequest],
        pydantic.Field(alias="eventTypes"),
    ] = None
    r"""The list of events to enable for this webhook. You may specify `'*'` to add all events, except those
    that require explicit selection. Separate multiple event types with a comma.
    """

    testmode: OptionalNullable[bool] = UNSET
    r"""Most API credentials are specifically created for either live mode or test mode. For organization-level credentials
    such as OAuth access tokens, you can enable test mode by setting `testmode` to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["name", "url", "webhook-event-types", "testmode"]
        nullable_fields = ["testmode"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class UpdateWebhookRequestTypedDict(TypedDict):
    id: str
    r"""Provide the ID of the item you want to perform this operation on."""
    request_body: NotRequired[UpdateWebhookRequestBodyTypedDict]


class UpdateWebhookRequest(BaseModel):
    id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""Provide the ID of the item you want to perform this operation on."""

    request_body: Annotated[
        Optional[UpdateWebhookRequestBody],
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ] = None


class UpdateWebhookUnprocessableEntityDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str
    type: str


class UpdateWebhookUnprocessableEntityDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str

    type: str


class UpdateWebhookUnprocessableEntityLinksTypedDict(TypedDict):
    documentation: UpdateWebhookUnprocessableEntityDocumentationTypedDict
    r"""The URL to the generic Mollie API error handling guide."""


class UpdateWebhookUnprocessableEntityLinks(BaseModel):
    documentation: UpdateWebhookUnprocessableEntityDocumentation
    r"""The URL to the generic Mollie API error handling guide."""


class UpdateWebhookUnprocessableEntityHalJSONErrorData(BaseModel):
    status: int
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: str
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: str
    r"""A detailed human-readable description of the error that occurred."""

    links: Annotated[
        UpdateWebhookUnprocessableEntityLinks, pydantic.Field(alias="_links")
    ]

    field: Optional[str] = None
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name
    of the field that caused the issue.
    """


class UpdateWebhookUnprocessableEntityHalJSONError(ClientError):
    r"""An error response object."""

    data: UpdateWebhookUnprocessableEntityHalJSONErrorData

    def __init__(
        self,
        data: UpdateWebhookUnprocessableEntityHalJSONErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        message = body or raw_response.text
        super().__init__(message, raw_response, body)
        self.data = data


class UpdateWebhookNotFoundDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str
    type: str


class UpdateWebhookNotFoundDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str

    type: str


class UpdateWebhookNotFoundLinksTypedDict(TypedDict):
    documentation: UpdateWebhookNotFoundDocumentationTypedDict
    r"""The URL to the generic Mollie API error handling guide."""


class UpdateWebhookNotFoundLinks(BaseModel):
    documentation: UpdateWebhookNotFoundDocumentation
    r"""The URL to the generic Mollie API error handling guide."""


class UpdateWebhookNotFoundHalJSONErrorData(BaseModel):
    status: int
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: str
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: str
    r"""A detailed human-readable description of the error that occurred."""

    links: Annotated[UpdateWebhookNotFoundLinks, pydantic.Field(alias="_links")]

    field: Optional[str] = None
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name
    of the field that caused the issue.
    """


class UpdateWebhookNotFoundHalJSONError(ClientError):
    r"""An error response object."""

    data: UpdateWebhookNotFoundHalJSONErrorData

    def __init__(
        self,
        data: UpdateWebhookNotFoundHalJSONErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        message = body or raw_response.text
        super().__init__(message, raw_response, body)
        self.data = data


class UpdateWebhookEventTypeWebhookEventTypes(str, Enum, metaclass=utils.OpenEnumMeta):
    r"""The event's type"""

    PAYMENT_LINK_PAID = "payment-link.paid"
    BALANCE_TRANSACTION_CREATED = "balance-transaction.created"
    SALES_INVOICE_CREATED = "sales-invoice.created"
    SALES_INVOICE_ISSUED = "sales-invoice.issued"
    SALES_INVOICE_CANCELED = "sales-invoice.canceled"
    SALES_INVOICE_PAID = "sales-invoice.paid"
    WILDCARD_ = "*"


class UpdateWebhookStatus(str, Enum, metaclass=utils.OpenEnumMeta):
    r"""The subscription's current status."""

    ENABLED = "enabled"
    BLOCKED = "blocked"
    DISABLED = "disabled"
    DELETED = "deleted"


class UpdateWebhookMode(str, Enum, metaclass=utils.OpenEnumMeta):
    r"""Whether this entity was created in live mode or in test mode."""

    LIVE = "live"
    TEST = "test"


class UpdateWebhookDocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class UpdateWebhookDocumentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class UpdateWebhookLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    documentation: UpdateWebhookDocumentationTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class UpdateWebhookLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    documentation: UpdateWebhookDocumentation
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class UpdateWebhookResponseTypedDict(TypedDict):
    r"""The webhook object."""

    resource: str
    r"""Indicates the response contains a webhook subscription object.
    Will always contain the string `webhook` for this endpoint.
    """
    id: str
    r"""The identifier uniquely referring to this subscription."""
    url: str
    r"""The subscription's events destination."""
    profile_id: Nullable[str]
    r"""The identifier uniquely referring to the profile that created the subscription."""
    created_at: str
    r"""The subscription's date time of creation."""
    name: str
    r"""The subscription's name."""
    event_types: List[UpdateWebhookEventTypeWebhookEventTypes]
    r"""The events types that are subscribed."""
    status: UpdateWebhookStatus
    r"""The subscription's current status."""
    mode: UpdateWebhookMode
    r"""Whether this entity was created in live mode or in test mode."""
    links: UpdateWebhookLinksTypedDict
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""


class UpdateWebhookResponse(BaseModel):
    r"""The webhook object."""

    resource: str
    r"""Indicates the response contains a webhook subscription object.
    Will always contain the string `webhook` for this endpoint.
    """

    id: str
    r"""The identifier uniquely referring to this subscription."""

    url: str
    r"""The subscription's events destination."""

    profile_id: Annotated[Nullable[str], pydantic.Field(alias="profileId")]
    r"""The identifier uniquely referring to the profile that created the subscription."""

    created_at: Annotated[str, pydantic.Field(alias="createdAt")]
    r"""The subscription's date time of creation."""

    name: str
    r"""The subscription's name."""

    event_types: Annotated[
        List[
            Annotated[
                UpdateWebhookEventTypeWebhookEventTypes,
                PlainValidator(validate_open_enum(False)),
            ]
        ],
        pydantic.Field(alias="eventTypes"),
    ]
    r"""The events types that are subscribed."""

    status: Annotated[UpdateWebhookStatus, PlainValidator(validate_open_enum(False))]
    r"""The subscription's current status."""

    mode: Annotated[UpdateWebhookMode, PlainValidator(validate_open_enum(False))]
    r"""Whether this entity was created in live mode or in test mode."""

    links: Annotated[UpdateWebhookLinks, pydantic.Field(alias="_links")]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["profileId"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
