"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .entity_capability_requirement import (
    EntityCapabilityRequirement,
    EntityCapabilityRequirementTypedDict,
)
from enum import Enum
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
import pydantic
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class EntityCapabilityStatus(str, Enum):
    UNREQUESTED = "unrequested"
    ENABLED = "enabled"
    DISABLED = "disabled"
    PENDING = "pending"


class StatusReasonEnum(str, Enum):
    REQUIREMENT_PAST_DUE = "requirement-past-due"
    ONBOARDING_INFORMATION_NEEDED = "onboarding-information-needed"


class EntityCapabilityTypedDict(TypedDict):
    resource: NotRequired[str]
    r"""Always the word `capability` for this resource type."""
    name: NotRequired[str]
    r"""A unique name for this capability like `payments` / `settlements`."""
    status: NotRequired[EntityCapabilityStatus]
    status_reason: NotRequired[Nullable[StatusReasonEnum]]
    requirements: NotRequired[List[EntityCapabilityRequirementTypedDict]]


class EntityCapability(BaseModel):
    resource: Optional[str] = None
    r"""Always the word `capability` for this resource type."""

    name: Optional[str] = None
    r"""A unique name for this capability like `payments` / `settlements`."""

    status: Optional[EntityCapabilityStatus] = None

    status_reason: Annotated[
        OptionalNullable[StatusReasonEnum], pydantic.Field(alias="statusReason")
    ] = UNSET

    requirements: Optional[List[EntityCapabilityRequirement]] = None

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["resource", "name", "status", "statusReason", "requirements"]
        nullable_fields = ["statusReason"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
