"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .locale_response import LocaleResponse
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import validate_open_enum
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import PlainValidator
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class OwnerTypedDict(TypedDict):
    r"""Personal data of your customer."""

    email: str
    r"""The email address of your customer."""
    given_name: str
    r"""The given name (first name) of your customer."""
    family_name: str
    r"""The family name (surname) of your customer."""
    locale: NotRequired[LocaleResponse]
    r"""Allows you to preset the language to be used."""


class Owner(BaseModel):
    r"""Personal data of your customer."""

    email: str
    r"""The email address of your customer."""

    given_name: Annotated[str, pydantic.Field(alias="givenName")]
    r"""The given name (first name) of your customer."""

    family_name: Annotated[str, pydantic.Field(alias="familyName")]
    r"""The family name (surname) of your customer."""

    locale: Annotated[
        Optional[LocaleResponse], PlainValidator(validate_open_enum(False))
    ] = None
    r"""Allows you to preset the language to be used."""


class EntityClientLinkAddressTypedDict(TypedDict):
    r"""Address of the organization."""

    country: str
    r"""The country of the address in
    [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) format.
    """
    street_and_number: NotRequired[Nullable[str]]
    r"""The street name and house number of the organization."""
    postal_code: NotRequired[Nullable[str]]
    r"""The postal code of the organization. Required if a street address is provided and if the country has a postal
    code system.
    """
    city: NotRequired[Nullable[str]]
    r"""The city of the organization. Required if a street address is provided."""


class EntityClientLinkAddress(BaseModel):
    r"""Address of the organization."""

    country: str
    r"""The country of the address in
    [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) format.
    """

    street_and_number: Annotated[
        OptionalNullable[str], pydantic.Field(alias="streetAndNumber")
    ] = UNSET
    r"""The street name and house number of the organization."""

    postal_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="postalCode")
    ] = UNSET
    r"""The postal code of the organization. Required if a street address is provided and if the country has a postal
    code system.
    """

    city: OptionalNullable[str] = UNSET
    r"""The city of the organization. Required if a street address is provided."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["streetAndNumber", "postalCode", "city"]
        nullable_fields = ["streetAndNumber", "postalCode", "city"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EntityClientLinkTypedDict(TypedDict):
    owner: NotRequired[OwnerTypedDict]
    r"""Personal data of your customer."""
    name: NotRequired[str]
    r"""Name of the organization."""
    address: NotRequired[EntityClientLinkAddressTypedDict]
    r"""Address of the organization."""
    registration_number: NotRequired[Nullable[str]]
    r"""The registration number of the organization at their local chamber of commerce."""
    vat_number: NotRequired[Nullable[str]]
    r"""The VAT number of the organization, if based in the European Union. VAT numbers are verified against the
    international registry *VIES*.
    """


class EntityClientLink(BaseModel):
    owner: Optional[Owner] = None
    r"""Personal data of your customer."""

    name: Optional[str] = None
    r"""Name of the organization."""

    address: Optional[EntityClientLinkAddress] = None
    r"""Address of the organization."""

    registration_number: Annotated[
        OptionalNullable[str], pydantic.Field(alias="registrationNumber")
    ] = UNSET
    r"""The registration number of the organization at their local chamber of commerce."""

    vat_number: Annotated[OptionalNullable[str], pydantic.Field(alias="vatNumber")] = (
        UNSET
    )
    r"""The VAT number of the organization, if based in the European Union. VAT numbers are verified against the
    international registry *VIES*.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "owner",
            "name",
            "address",
            "registrationNumber",
            "vatNumber",
        ]
        nullable_fields = ["registrationNumber", "vatNumber"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
