"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
import pydantic
from pydantic import model_serializer
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class EntityMandateMethod(str, Enum):
    r"""Payment method of the mandate.

    SEPA Direct Debit and PayPal mandates can be created directly.
    """

    CREDITCARD = "creditcard"
    DIRECTDEBIT = "directdebit"
    PAYPAL = "paypal"


class EntityMandateTypedDict(TypedDict):
    id: NotRequired[str]
    method: NotRequired[EntityMandateMethod]
    r"""Payment method of the mandate.

    SEPA Direct Debit and PayPal mandates can be created directly.
    """
    consumer_name: NotRequired[str]
    r"""The customer's name."""
    consumer_account: NotRequired[Nullable[str]]
    r"""The customer's IBAN. Required for SEPA Direct Debit mandates."""
    consumer_bic: NotRequired[Nullable[str]]
    r"""The BIC of the customer's bank."""
    consumer_email: NotRequired[Nullable[str]]
    r"""The customer's email address. Required for PayPal mandates."""
    signature_date: NotRequired[Nullable[str]]
    r"""The date when the mandate was signed in `YYYY-MM-DD` format."""
    mandate_reference: NotRequired[Nullable[str]]
    r"""A custom mandate reference. For SEPA Direct Debit, it is vital to provide a unique reference. Some banks will
    decline Direct Debit payments if the mandate reference is not unique.
    """
    paypal_billing_agreement_id: NotRequired[Nullable[str]]
    r"""The billing agreement ID given by PayPal. For example: `B-12A34567B8901234CD`. Required for PayPal mandates.
    Must provide either this field or `payPalVaultId`, but not both.
    """
    pay_pal_vault_id: NotRequired[Nullable[str]]
    r"""The Vault ID given by PayPal. For example: `8kk8451t`. Required for PayPal mandates.
    Must provide either this field or `paypalBillingAgreementId`, but not both.
    """
    customer_id: NotRequired[str]
    testmode: NotRequired[Nullable[bool]]
    r"""Whether to create the entity in test mode or live mode.

    Most API credentials are specifically created for either live mode or test mode, in which case this parameter can be
    omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting
    `testmode` to `true`.
    """


class EntityMandate(BaseModel):
    id: Optional[str] = None

    method: Optional[EntityMandateMethod] = None
    r"""Payment method of the mandate.

    SEPA Direct Debit and PayPal mandates can be created directly.
    """

    consumer_name: Annotated[Optional[str], pydantic.Field(alias="consumerName")] = None
    r"""The customer's name."""

    consumer_account: Annotated[
        OptionalNullable[str], pydantic.Field(alias="consumerAccount")
    ] = UNSET
    r"""The customer's IBAN. Required for SEPA Direct Debit mandates."""

    consumer_bic: Annotated[
        OptionalNullable[str], pydantic.Field(alias="consumerBic")
    ] = UNSET
    r"""The BIC of the customer's bank."""

    consumer_email: Annotated[
        OptionalNullable[str], pydantic.Field(alias="consumerEmail")
    ] = UNSET
    r"""The customer's email address. Required for PayPal mandates."""

    signature_date: Annotated[
        OptionalNullable[str], pydantic.Field(alias="signatureDate")
    ] = UNSET
    r"""The date when the mandate was signed in `YYYY-MM-DD` format."""

    mandate_reference: Annotated[
        OptionalNullable[str], pydantic.Field(alias="mandateReference")
    ] = UNSET
    r"""A custom mandate reference. For SEPA Direct Debit, it is vital to provide a unique reference. Some banks will
    decline Direct Debit payments if the mandate reference is not unique.
    """

    paypal_billing_agreement_id: Annotated[
        OptionalNullable[str], pydantic.Field(alias="paypalBillingAgreementId")
    ] = UNSET
    r"""The billing agreement ID given by PayPal. For example: `B-12A34567B8901234CD`. Required for PayPal mandates.
    Must provide either this field or `payPalVaultId`, but not both.
    """

    pay_pal_vault_id: Annotated[
        OptionalNullable[str], pydantic.Field(alias="payPalVaultId")
    ] = UNSET
    r"""The Vault ID given by PayPal. For example: `8kk8451t`. Required for PayPal mandates.
    Must provide either this field or `paypalBillingAgreementId`, but not both.
    """

    customer_id: Annotated[Optional[str], pydantic.Field(alias="customerId")] = None

    testmode: OptionalNullable[bool] = UNSET
    r"""Whether to create the entity in test mode or live mode.

    Most API credentials are specifically created for either live mode or test mode, in which case this parameter can be
    omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting
    `testmode` to `true`.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "id",
            "method",
            "consumerName",
            "consumerAccount",
            "consumerBic",
            "consumerEmail",
            "signatureDate",
            "mandateReference",
            "paypalBillingAgreementId",
            "payPalVaultId",
            "customerId",
            "testmode",
        ]
        nullable_fields = [
            "consumerAccount",
            "consumerBic",
            "consumerEmail",
            "signatureDate",
            "mandateReference",
            "paypalBillingAgreementId",
            "payPalVaultId",
            "testmode",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
