"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .url import URL, URLTypedDict
from enum import Enum
from mollie.types import BaseModel
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class EntityOnboardingStatusStatus(str, Enum):
    r"""The current status of the organization's onboarding process.

    * `needs-data` — The merchant needs to provide additional information
    * `in-review` — The merchant provided all information, awaiting review from Mollie
    * `completed` — The onboarding is completed
    """

    NEEDS_DATA = "needs-data"
    IN_REVIEW = "in-review"
    COMPLETED = "completed"


class EntityOnboardingStatusLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: NotRequired[URLTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    dashboard: NotRequired[URLTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    organization: NotRequired[URLTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    documentation: NotRequired[URLTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class EntityOnboardingStatusLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[Optional[URL], pydantic.Field(alias="self")] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    dashboard: Optional[URL] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    organization: Optional[URL] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    documentation: Optional[URL] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class EntityOnboardingStatusTypedDict(TypedDict):
    resource: NotRequired[str]
    r"""Indicates the response contains an onboarding status object. Will always contain the string `onboarding` for this
    resource type.
    """
    name: NotRequired[str]
    r"""The name of the organization."""
    status: NotRequired[EntityOnboardingStatusStatus]
    r"""The current status of the organization's onboarding process.

    * `needs-data` — The merchant needs to provide additional information
    * `in-review` — The merchant provided all information, awaiting review from Mollie
    * `completed` — The onboarding is completed
    """
    can_receive_payments: NotRequired[bool]
    r"""Whether the organization can receive payments."""
    can_receive_settlements: NotRequired[bool]
    r"""Whether the organization can receive settlements to their external bank account."""
    signed_up_at: NotRequired[str]
    r"""The sign up date time of the organization in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""
    links: NotRequired[EntityOnboardingStatusLinksTypedDict]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""


class EntityOnboardingStatus(BaseModel):
    resource: Optional[str] = None
    r"""Indicates the response contains an onboarding status object. Will always contain the string `onboarding` for this
    resource type.
    """

    name: Optional[str] = None
    r"""The name of the organization."""

    status: Optional[EntityOnboardingStatusStatus] = None
    r"""The current status of the organization's onboarding process.

    * `needs-data` — The merchant needs to provide additional information
    * `in-review` — The merchant provided all information, awaiting review from Mollie
    * `completed` — The onboarding is completed
    """

    can_receive_payments: Annotated[
        Optional[bool], pydantic.Field(alias="canReceivePayments")
    ] = None
    r"""Whether the organization can receive payments."""

    can_receive_settlements: Annotated[
        Optional[bool], pydantic.Field(alias="canReceiveSettlements")
    ] = None
    r"""Whether the organization can receive settlements to their external bank account."""

    signed_up_at: Annotated[Optional[str], pydantic.Field(alias="signedUpAt")] = None
    r"""The sign up date time of the organization in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""

    links: Annotated[
        Optional[EntityOnboardingStatusLinks], pydantic.Field(alias="_links")
    ] = None
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""
