"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .amount import Amount, AmountTypedDict
from .entity_method_all import EntityMethodAll, EntityMethodAllTypedDict
from .locale_parameter import LocaleParameter
from .sequence_type import SequenceType
from .url import URL, URLTypedDict
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import FieldMetadata, QueryParamMetadata
import pydantic
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ListAllMethodsRequestTypedDict(TypedDict):
    locale: NotRequired[LocaleParameter]
    r"""Response language"""
    amount: NotRequired[AmountTypedDict]
    r"""If supplied, only payment methods that support the amount and currency
    are returned.

    Example: `/v2/methods/all?amount[value]=100.00&amount[currency]=USD`
    """
    include: NotRequired[Nullable[str]]
    r"""This endpoint allows you to include additional information via the `include` query string parameter."""
    sequence_type: NotRequired[SequenceType]
    r"""Set this parameter to `first` to only return the methods that
    can be used for the first payment of a recurring sequence.

    Set it to `recurring` to only return methods that can be used for recurring payments or subscriptions.
    """
    profile_id: NotRequired[str]
    r"""The identifier referring to the [profile](get-profile) you wish to
    retrieve the resources for.

    Most API credentials are linked to a single profile. In these cases the `profileId` can be omitted. For
    organization-level credentials such as OAuth access tokens however, the `profileId` parameter is required.
    """
    testmode: NotRequired[Nullable[bool]]
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query
    parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by
    setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """


class ListAllMethodsRequest(BaseModel):
    locale: Annotated[
        Optional[LocaleParameter],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Response language"""

    amount: Annotated[
        Optional[Amount],
        FieldMetadata(query=QueryParamMetadata(style="deepObject", explode=True)),
    ] = None
    r"""If supplied, only payment methods that support the amount and currency
    are returned.

    Example: `/v2/methods/all?amount[value]=100.00&amount[currency]=USD`
    """

    include: Annotated[
        OptionalNullable[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""This endpoint allows you to include additional information via the `include` query string parameter."""

    sequence_type: Annotated[
        Optional[SequenceType],
        pydantic.Field(alias="sequenceType"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Set this parameter to `first` to only return the methods that
    can be used for the first payment of a recurring sequence.

    Set it to `recurring` to only return methods that can be used for recurring payments or subscriptions.
    """

    profile_id: Annotated[
        Optional[str],
        pydantic.Field(alias="profileId"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The identifier referring to the [profile](get-profile) you wish to
    retrieve the resources for.

    Most API credentials are linked to a single profile. In these cases the `profileId` can be omitted. For
    organization-level credentials such as OAuth access tokens however, the `profileId` parameter is required.
    """

    testmode: Annotated[
        OptionalNullable[bool],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query
    parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by
    setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "locale",
            "amount",
            "include",
            "sequenceType",
            "profileId",
            "testmode",
        ]
        nullable_fields = ["include", "testmode"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListAllMethodsEmbeddedTypedDict(TypedDict):
    methods: List[EntityMethodAllTypedDict]
    r"""An array of payment method objects. For a complete
    reference of the payment method object, refer to the [Get payment method endpoint](get-method)
    documentation.
    """


class ListAllMethodsEmbedded(BaseModel):
    methods: List[EntityMethodAll]
    r"""An array of payment method objects. For a complete
    reference of the payment method object, refer to the [Get payment method endpoint](get-method)
    documentation.
    """


class ListAllMethodsLinksTypedDict(TypedDict):
    self_: URLTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    documentation: URLTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class ListAllMethodsLinks(BaseModel):
    self_: Annotated[URL, pydantic.Field(alias="self")]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    documentation: URL
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class ListAllMethodsResponseTypedDict(TypedDict):
    r"""A list of payment method objects. For a complete reference of the
    payment method object, refer to the [Get payment method endpoint](get-method) documentation.
    """

    count: int
    r"""The number of payment method objects in this result set. Results are **not** paginated."""
    embedded: ListAllMethodsEmbeddedTypedDict
    links: ListAllMethodsLinksTypedDict


class ListAllMethodsResponse(BaseModel):
    r"""A list of payment method objects. For a complete reference of the
    payment method object, refer to the [Get payment method endpoint](get-method) documentation.
    """

    count: int
    r"""The number of payment method objects in this result set. Results are **not** paginated."""

    embedded: Annotated[ListAllMethodsEmbedded, pydantic.Field(alias="_embedded")]

    links: Annotated[ListAllMethodsLinks, pydantic.Field(alias="_links")]
