"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .mode import Mode
from .url import URL, URLTypedDict
from .webhook_event_types import WebhookEventTypes
from enum import Enum
from mollie.types import BaseModel
from mollie.utils import validate_open_enum
import pydantic
from pydantic.functional_validators import PlainValidator
from typing import List
from typing_extensions import Annotated, TypedDict


class CreateWebhookStatus(str, Enum):
    r"""The subscription's current status."""

    ENABLED = "enabled"
    BLOCKED = "blocked"
    DISABLED = "disabled"


class CreateWebhookLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    documentation: URLTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class CreateWebhookLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    documentation: URL
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class CreateWebhookTypedDict(TypedDict):
    resource: str
    r"""Indicates the response contains a webhook subscription object. Will always contain the string `webhook` for this endpoint."""
    id: str
    r"""The identifier uniquely referring to this subscription."""
    url: str
    r"""The subscription's events destination."""
    profile_id: str
    r"""The identifier uniquely referring to the profile that created the subscription."""
    created_at: str
    r"""The subscription's date time of creation."""
    name: str
    r"""The subscription's name."""
    event_types: List[WebhookEventTypes]
    r"""The events types that are subscribed."""
    status: CreateWebhookStatus
    r"""The subscription's current status."""
    mode: Mode
    r"""Whether this entity was created in live mode or in test mode."""
    webhook_secret: str
    r"""The subscription's secret."""
    links: CreateWebhookLinksTypedDict
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""


class CreateWebhook(BaseModel):
    resource: str
    r"""Indicates the response contains a webhook subscription object. Will always contain the string `webhook` for this endpoint."""

    id: str
    r"""The identifier uniquely referring to this subscription."""

    url: str
    r"""The subscription's events destination."""

    profile_id: Annotated[str, pydantic.Field(alias="profileId")]
    r"""The identifier uniquely referring to the profile that created the subscription."""

    created_at: Annotated[str, pydantic.Field(alias="createdAt")]
    r"""The subscription's date time of creation."""

    name: str
    r"""The subscription's name."""

    event_types: Annotated[List[WebhookEventTypes], pydantic.Field(alias="eventTypes")]
    r"""The events types that are subscribed."""

    status: CreateWebhookStatus
    r"""The subscription's current status."""

    mode: Annotated[Mode, PlainValidator(validate_open_enum(False))]
    r"""Whether this entity was created in live mode or in test mode."""

    webhook_secret: Annotated[str, pydantic.Field(alias="webhookSecret")]
    r"""The subscription's secret."""

    links: Annotated[CreateWebhookLinks, pydantic.Field(alias="_links")]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""
