"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .amount import Amount, AmountTypedDict
from .currencies import Currencies
from .mode import Mode
from .url import URL, URLTypedDict
from enum import Enum
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import validate_open_enum
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import PlainValidator
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class EntityBalanceStatus(str, Enum):
    r"""The status of the balance."""

    ACTIVE = "active"
    INACTIVE = "inactive"


class TransferFrequency(str, Enum):
    r"""The frequency with which the available amount on the balance will be settled to the configured transfer
    destination.

    Settlements created during weekends or on bank holidays will take place on the next business day.
    """

    DAILY = "daily"
    EVERY_MONDAY = "every-monday"
    EVERY_TUESDAY = "every-tuesday"
    EVERY_WEDNESDAY = "every-wednesday"
    EVERY_THURSDAY = "every-thursday"
    EVERY_FRIDAY = "every-friday"
    MONTHLY = "monthly"
    NEVER = "never"


class EntityBalanceType(str, Enum):
    r"""The default destination of automatic scheduled transfers. Currently only `bank-account` is supported.

    * `bank-account` — Transfer the balance amount to an external bank account
    """

    BANK_ACCOUNT = "bank-account"


class TransferDestinationTypedDict(TypedDict):
    r"""The destination where the available amount will be automatically transferred to according to the configured
    transfer frequency.
    """

    type: NotRequired[EntityBalanceType]
    r"""The default destination of automatic scheduled transfers. Currently only `bank-account` is supported.

    * `bank-account` — Transfer the balance amount to an external bank account
    """
    bank_account: NotRequired[str]
    r"""The configured bank account number of the beneficiary the balance amount is to be transferred to."""
    beneficiary_name: NotRequired[str]
    r"""The full name of the beneficiary the balance amount is to be transferred to."""


class TransferDestination(BaseModel):
    r"""The destination where the available amount will be automatically transferred to according to the configured
    transfer frequency.
    """

    type: Optional[EntityBalanceType] = None
    r"""The default destination of automatic scheduled transfers. Currently only `bank-account` is supported.

    * `bank-account` — Transfer the balance amount to an external bank account
    """

    bank_account: Annotated[Optional[str], pydantic.Field(alias="bankAccount")] = None
    r"""The configured bank account number of the beneficiary the balance amount is to be transferred to."""

    beneficiary_name: Annotated[
        Optional[str], pydantic.Field(alias="beneficiaryName")
    ] = None
    r"""The full name of the beneficiary the balance amount is to be transferred to."""


class EntityBalanceLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: NotRequired[URLTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    documentation: NotRequired[URLTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class EntityBalanceLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[Optional[URL], pydantic.Field(alias="self")] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    documentation: Optional[URL] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class EntityBalanceTypedDict(TypedDict):
    resource: NotRequired[str]
    r"""Indicates the response contains a balance object. Will always contain the string `balance` for this endpoint."""
    id: NotRequired[str]
    mode: NotRequired[Mode]
    r"""Whether this entity was created in live mode or in test mode."""
    created_at: NotRequired[str]
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""
    currency: NotRequired[Currencies]
    description: NotRequired[str]
    r"""The description or name of the balance. Can be used to denote the purpose of the balance."""
    status: NotRequired[EntityBalanceStatus]
    r"""The status of the balance."""
    transfer_frequency: NotRequired[TransferFrequency]
    r"""The frequency with which the available amount on the balance will be settled to the configured transfer
    destination.

    Settlements created during weekends or on bank holidays will take place on the next business day.
    """
    transfer_threshold: NotRequired[AmountTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    transfer_reference: NotRequired[Nullable[str]]
    r"""The transfer reference set to be included in all the transfers for this balance."""
    transfer_destination: NotRequired[Nullable[TransferDestinationTypedDict]]
    r"""The destination where the available amount will be automatically transferred to according to the configured
    transfer frequency.
    """
    available_amount: NotRequired[AmountTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    pending_amount: NotRequired[AmountTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    links: NotRequired[EntityBalanceLinksTypedDict]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""


class EntityBalance(BaseModel):
    resource: Optional[str] = None
    r"""Indicates the response contains a balance object. Will always contain the string `balance` for this endpoint."""

    id: Optional[str] = None

    mode: Annotated[Optional[Mode], PlainValidator(validate_open_enum(False))] = None
    r"""Whether this entity was created in live mode or in test mode."""

    created_at: Annotated[Optional[str], pydantic.Field(alias="createdAt")] = None
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""

    currency: Annotated[
        Optional[Currencies], PlainValidator(validate_open_enum(False))
    ] = None

    description: Optional[str] = None
    r"""The description or name of the balance. Can be used to denote the purpose of the balance."""

    status: Optional[EntityBalanceStatus] = None
    r"""The status of the balance."""

    transfer_frequency: Annotated[
        Optional[TransferFrequency], pydantic.Field(alias="transferFrequency")
    ] = None
    r"""The frequency with which the available amount on the balance will be settled to the configured transfer
    destination.

    Settlements created during weekends or on bank holidays will take place on the next business day.
    """

    transfer_threshold: Annotated[
        Optional[Amount], pydantic.Field(alias="transferThreshold")
    ] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    transfer_reference: Annotated[
        OptionalNullable[str], pydantic.Field(alias="transferReference")
    ] = UNSET
    r"""The transfer reference set to be included in all the transfers for this balance."""

    transfer_destination: Annotated[
        OptionalNullable[TransferDestination],
        pydantic.Field(alias="transferDestination"),
    ] = UNSET
    r"""The destination where the available amount will be automatically transferred to according to the configured
    transfer frequency.
    """

    available_amount: Annotated[
        Optional[Amount], pydantic.Field(alias="availableAmount")
    ] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    pending_amount: Annotated[
        Optional[Amount], pydantic.Field(alias="pendingAmount")
    ] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    links: Annotated[Optional[EntityBalanceLinks], pydantic.Field(alias="_links")] = (
        None
    )
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "resource",
            "id",
            "mode",
            "createdAt",
            "currency",
            "description",
            "status",
            "transferFrequency",
            "transferThreshold",
            "transferReference",
            "transferDestination",
            "availableAmount",
            "pendingAmount",
            "_links",
        ]
        nullable_fields = ["transferReference", "transferDestination"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
