"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .amount import Amount, AmountTypedDict
from .url import URL, URLTypedDict
from enum import Enum
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
import pydantic
from pydantic import model_serializer
from typing_extensions import Annotated, NotRequired, TypedDict


class EntityPaymentRouteType(str, Enum):
    r"""The type of destination. Currently only the destination type `organization` is supported."""

    ORGANIZATION = "organization"


class EntityPaymentRouteDestinationTypedDict(TypedDict):
    r"""The destination of this portion of the payment."""

    type: EntityPaymentRouteType
    r"""The type of destination. Currently only the destination type `organization` is supported."""
    organization_id: str


class EntityPaymentRouteDestination(BaseModel):
    r"""The destination of this portion of the payment."""

    type: EntityPaymentRouteType
    r"""The type of destination. Currently only the destination type `organization` is supported."""

    organization_id: Annotated[str, pydantic.Field(alias="organizationId")]


class EntityPaymentRouteLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: URLTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    payment: URLTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class EntityPaymentRouteLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[URL, pydantic.Field(alias="self")]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    payment: URL
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class EntityPaymentRouteTypedDict(TypedDict):
    id: str
    amount: AmountTypedDict
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    destination: EntityPaymentRouteDestinationTypedDict
    r"""The destination of this portion of the payment."""
    links: EntityPaymentRouteLinksTypedDict
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""
    release_date: NotRequired[Nullable[str]]
    r"""Optionally, schedule this portion of the payment to be transferred to its destination on a later date. The
    date must be given in `YYYY-MM-DD` format.

    If no date is given, the funds become available to the connected merchant as soon as the payment succeeds.
    """


class EntityPaymentRoute(BaseModel):
    id: str

    amount: Amount
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    destination: EntityPaymentRouteDestination
    r"""The destination of this portion of the payment."""

    links: Annotated[EntityPaymentRouteLinks, pydantic.Field(alias="_links")]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    release_date: Annotated[
        OptionalNullable[str], pydantic.Field(alias="releaseDate")
    ] = UNSET
    r"""Optionally, schedule this portion of the payment to be transferred to its destination on a later date. The
    date must be given in `YYYY-MM-DD` format.

    If no date is given, the funds become available to the connected merchant as soon as the payment succeeds.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["releaseDate"]
        nullable_fields = ["releaseDate"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
