"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .mode import Mode
from .url import URL, URLTypedDict
from enum import Enum
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import validate_open_enum
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import PlainValidator
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class MandateResponseMethod(str, Enum):
    r"""Payment method of the mandate.

    SEPA Direct Debit and PayPal mandates can be created directly.
    """

    CREDITCARD = "creditcard"
    DIRECTDEBIT = "directdebit"
    PAYPAL = "paypal"


class MandateResponseCardLabel(str, Enum):
    r"""The card's label. Available for card mandates, if the card label could be detected."""

    AMERICAN_EXPRESS = "American Express"
    CARTA_SI = "Carta Si"
    CARTE_BLEUE = "Carte Bleue"
    DANKORT = "Dankort"
    DINERS_CLUB = "Diners Club"
    DISCOVER = "Discover"
    JCB = "JCB"
    LASER = "Laser"
    MAESTRO = "Maestro"
    MASTERCARD = "Mastercard"
    UNIONPAY = "Unionpay"
    VISA = "Visa"


class MandateResponseDetailsTypedDict(TypedDict):
    consumer_name: NotRequired[Nullable[str]]
    r"""The customer's name. Available for SEPA Direct Debit and PayPal mandates."""
    consumer_account: NotRequired[Nullable[str]]
    r"""The customer's IBAN or email address. Available for SEPA Direct Debit and PayPal mandates."""
    consumer_bic: NotRequired[Nullable[str]]
    r"""The BIC of the customer's bank. Available for SEPA Direct Debit mandates."""
    card_holder: NotRequired[Nullable[str]]
    r"""The card holder's name. Available for card mandates."""
    card_number: NotRequired[Nullable[str]]
    r"""The last four digits of the card number. Available for card mandates."""
    card_expiry_date: NotRequired[Nullable[str]]
    r"""The card's expiry date in `YYYY-MM-DD` format. Available for card mandates."""
    card_label: NotRequired[Nullable[MandateResponseCardLabel]]
    r"""The card's label. Available for card mandates, if the card label could be detected."""
    card_fingerprint: NotRequired[Nullable[str]]
    r"""Unique alphanumeric representation of this specific card. Available for card mandates. Can be used to identify
    returning customers.
    """


class MandateResponseDetails(BaseModel):
    consumer_name: Annotated[
        OptionalNullable[str], pydantic.Field(alias="consumerName")
    ] = UNSET
    r"""The customer's name. Available for SEPA Direct Debit and PayPal mandates."""

    consumer_account: Annotated[
        OptionalNullable[str], pydantic.Field(alias="consumerAccount")
    ] = UNSET
    r"""The customer's IBAN or email address. Available for SEPA Direct Debit and PayPal mandates."""

    consumer_bic: Annotated[
        OptionalNullable[str], pydantic.Field(alias="consumerBic")
    ] = UNSET
    r"""The BIC of the customer's bank. Available for SEPA Direct Debit mandates."""

    card_holder: Annotated[
        OptionalNullable[str], pydantic.Field(alias="cardHolder")
    ] = UNSET
    r"""The card holder's name. Available for card mandates."""

    card_number: Annotated[
        OptionalNullable[str], pydantic.Field(alias="cardNumber")
    ] = UNSET
    r"""The last four digits of the card number. Available for card mandates."""

    card_expiry_date: Annotated[
        OptionalNullable[str], pydantic.Field(alias="cardExpiryDate")
    ] = UNSET
    r"""The card's expiry date in `YYYY-MM-DD` format. Available for card mandates."""

    card_label: Annotated[
        OptionalNullable[MandateResponseCardLabel], pydantic.Field(alias="cardLabel")
    ] = UNSET
    r"""The card's label. Available for card mandates, if the card label could be detected."""

    card_fingerprint: Annotated[
        OptionalNullable[str], pydantic.Field(alias="cardFingerprint")
    ] = UNSET
    r"""Unique alphanumeric representation of this specific card. Available for card mandates. Can be used to identify
    returning customers.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "consumerName",
            "consumerAccount",
            "consumerBic",
            "cardHolder",
            "cardNumber",
            "cardExpiryDate",
            "cardLabel",
            "cardFingerprint",
        ]
        nullable_fields = [
            "consumerName",
            "consumerAccount",
            "consumerBic",
            "cardHolder",
            "cardNumber",
            "cardExpiryDate",
            "cardLabel",
            "cardFingerprint",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class MandateResponseStatus(str, Enum):
    r"""The status of the mandate. A status can be `pending` for mandates when the first payment is not yet finalized, or
    when we did not received the IBAN yet from the first payment.
    """

    VALID = "valid"
    PENDING = "pending"
    INVALID = "invalid"


class MandateResponseLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: URLTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    customer: URLTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    documentation: URLTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class MandateResponseLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[URL, pydantic.Field(alias="self")]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    customer: URL
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    documentation: URL
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class MandateResponseTypedDict(TypedDict):
    resource: NotRequired[str]
    r"""Indicates the response contains a mandate object. Will always contain the string `mandate` for this endpoint."""
    id: NotRequired[str]
    mode: NotRequired[Mode]
    r"""Whether this entity was created in live mode or in test mode."""
    method: NotRequired[MandateResponseMethod]
    r"""Payment method of the mandate.

    SEPA Direct Debit and PayPal mandates can be created directly.
    """
    details: NotRequired[MandateResponseDetailsTypedDict]
    signature_date: NotRequired[Nullable[str]]
    r"""The date when the mandate was signed in `YYYY-MM-DD` format."""
    mandate_reference: NotRequired[Nullable[str]]
    r"""A custom mandate reference. For SEPA Direct Debit, it is vital to provide a unique reference. Some banks will
    decline Direct Debit payments if the mandate reference is not unique.
    """
    status: NotRequired[MandateResponseStatus]
    r"""The status of the mandate. A status can be `pending` for mandates when the first payment is not yet finalized, or
    when we did not received the IBAN yet from the first payment.
    """
    customer_id: NotRequired[str]
    created_at: NotRequired[str]
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""
    links: NotRequired[MandateResponseLinksTypedDict]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""


class MandateResponse(BaseModel):
    resource: Optional[str] = None
    r"""Indicates the response contains a mandate object. Will always contain the string `mandate` for this endpoint."""

    id: Optional[str] = None

    mode: Annotated[Optional[Mode], PlainValidator(validate_open_enum(False))] = None
    r"""Whether this entity was created in live mode or in test mode."""

    method: Optional[MandateResponseMethod] = None
    r"""Payment method of the mandate.

    SEPA Direct Debit and PayPal mandates can be created directly.
    """

    details: Optional[MandateResponseDetails] = None

    signature_date: Annotated[
        OptionalNullable[str], pydantic.Field(alias="signatureDate")
    ] = UNSET
    r"""The date when the mandate was signed in `YYYY-MM-DD` format."""

    mandate_reference: Annotated[
        OptionalNullable[str], pydantic.Field(alias="mandateReference")
    ] = UNSET
    r"""A custom mandate reference. For SEPA Direct Debit, it is vital to provide a unique reference. Some banks will
    decline Direct Debit payments if the mandate reference is not unique.
    """

    status: Optional[MandateResponseStatus] = None
    r"""The status of the mandate. A status can be `pending` for mandates when the first payment is not yet finalized, or
    when we did not received the IBAN yet from the first payment.
    """

    customer_id: Annotated[Optional[str], pydantic.Field(alias="customerId")] = None

    created_at: Annotated[Optional[str], pydantic.Field(alias="createdAt")] = None
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""

    links: Annotated[Optional[MandateResponseLinks], pydantic.Field(alias="_links")] = (
        None
    )
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "resource",
            "id",
            "mode",
            "method",
            "details",
            "signatureDate",
            "mandateReference",
            "status",
            "customerId",
            "createdAt",
            "_links",
        ]
        nullable_fields = ["signatureDate", "mandateReference"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
