"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import FieldMetadata, PathParamMetadata, RequestMetadata
import pydantic
from pydantic import model_serializer
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class CancelSubscriptionRequestBodyTypedDict(TypedDict):
    testmode: NotRequired[Nullable[bool]]
    r"""Most API credentials are specifically created for either live mode or test mode. For organization-level credentials
    such as OAuth access tokens, you can enable test mode by setting `testmode` to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """


class CancelSubscriptionRequestBody(BaseModel):
    testmode: OptionalNullable[bool] = UNSET
    r"""Most API credentials are specifically created for either live mode or test mode. For organization-level credentials
    such as OAuth access tokens, you can enable test mode by setting `testmode` to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["testmode"]
        nullable_fields = ["testmode"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class CancelSubscriptionRequestTypedDict(TypedDict):
    customer_id: str
    r"""Provide the ID of the related customer."""
    subscription_id: str
    r"""Provide the ID of the related subscription."""
    request_body: NotRequired[CancelSubscriptionRequestBodyTypedDict]


class CancelSubscriptionRequest(BaseModel):
    customer_id: Annotated[
        str,
        pydantic.Field(alias="customerId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""Provide the ID of the related customer."""

    subscription_id: Annotated[
        str,
        pydantic.Field(alias="subscriptionId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""Provide the ID of the related subscription."""

    request_body: Annotated[
        Optional[CancelSubscriptionRequestBody],
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ] = None
