"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .amount import Amount, AmountTypedDict
from .invoice_status import InvoiceStatus
from .url import URL, URLTypedDict
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import validate_open_enum
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import PlainValidator
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class EntityInvoiceLineTypedDict(TypedDict):
    period: NotRequired[str]
    r"""The administrative period in `YYYY-MM` on which the line should be booked."""
    description: NotRequired[str]
    r"""Description of the product."""
    count: NotRequired[int]
    r"""Number of products invoiced. For example, the number of payments."""
    vat_percentage: NotRequired[int]
    r"""VAT percentage rate that applies to this product."""
    amount: NotRequired[AmountTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""


class EntityInvoiceLine(BaseModel):
    period: Optional[str] = None
    r"""The administrative period in `YYYY-MM` on which the line should be booked."""

    description: Optional[str] = None
    r"""Description of the product."""

    count: Optional[int] = None
    r"""Number of products invoiced. For example, the number of payments."""

    vat_percentage: Annotated[Optional[int], pydantic.Field(alias="vatPercentage")] = (
        None
    )
    r"""VAT percentage rate that applies to this product."""

    amount: Optional[Amount] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""


class EntityInvoiceLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: NotRequired[URLTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    pdf: NotRequired[URLTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    documentation: NotRequired[URLTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class EntityInvoiceLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[Optional[URL], pydantic.Field(alias="self")] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    pdf: Optional[URL] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    documentation: Optional[URL] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class EntityInvoiceTypedDict(TypedDict):
    resource: NotRequired[str]
    r"""Indicates that the response contains an invoice object.
    Will always contain the string `invoice` for this endpoint.
    """
    id: NotRequired[str]
    r"""The identifier uniquely referring to this invoice. Example: `inv_FrvewDA3Pr`."""
    reference: NotRequired[str]
    r"""The reference number of the invoice. An example value would be: `2024.10000`."""
    vat_number: NotRequired[Nullable[str]]
    r"""The VAT number to which the invoice was issued to, if applicable."""
    status: NotRequired[InvoiceStatus]
    r"""Status of the invoice."""
    net_amount: NotRequired[AmountTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    vat_amount: NotRequired[AmountTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    gross_amount: NotRequired[AmountTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    lines: NotRequired[List[EntityInvoiceLineTypedDict]]
    r"""The collection of products which make up the invoice."""
    issued_at: NotRequired[str]
    r"""The invoice date in `YYYY-MM-DD` format."""
    paid_at: NotRequired[Nullable[str]]
    r"""The date on which the invoice was paid, if applicable, in `YYYY-MM-DD` format."""
    due_at: NotRequired[Nullable[str]]
    r"""The date on which the invoice is due, if applicable, in `YYYY-MM-DD` format."""
    links: NotRequired[EntityInvoiceLinksTypedDict]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""


class EntityInvoice(BaseModel):
    resource: Optional[str] = None
    r"""Indicates that the response contains an invoice object.
    Will always contain the string `invoice` for this endpoint.
    """

    id: Optional[str] = None
    r"""The identifier uniquely referring to this invoice. Example: `inv_FrvewDA3Pr`."""

    reference: Optional[str] = None
    r"""The reference number of the invoice. An example value would be: `2024.10000`."""

    vat_number: Annotated[OptionalNullable[str], pydantic.Field(alias="vatNumber")] = (
        UNSET
    )
    r"""The VAT number to which the invoice was issued to, if applicable."""

    status: Annotated[
        Optional[InvoiceStatus], PlainValidator(validate_open_enum(False))
    ] = None
    r"""Status of the invoice."""

    net_amount: Annotated[Optional[Amount], pydantic.Field(alias="netAmount")] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    vat_amount: Annotated[Optional[Amount], pydantic.Field(alias="vatAmount")] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    gross_amount: Annotated[Optional[Amount], pydantic.Field(alias="grossAmount")] = (
        None
    )
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    lines: Optional[List[EntityInvoiceLine]] = None
    r"""The collection of products which make up the invoice."""

    issued_at: Annotated[Optional[str], pydantic.Field(alias="issuedAt")] = None
    r"""The invoice date in `YYYY-MM-DD` format."""

    paid_at: Annotated[OptionalNullable[str], pydantic.Field(alias="paidAt")] = UNSET
    r"""The date on which the invoice was paid, if applicable, in `YYYY-MM-DD` format."""

    due_at: Annotated[OptionalNullable[str], pydantic.Field(alias="dueAt")] = UNSET
    r"""The date on which the invoice is due, if applicable, in `YYYY-MM-DD` format."""

    links: Annotated[Optional[EntityInvoiceLinks], pydantic.Field(alias="_links")] = (
        None
    )
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "resource",
            "id",
            "reference",
            "vatNumber",
            "status",
            "netAmount",
            "vatAmount",
            "grossAmount",
            "lines",
            "issuedAt",
            "paidAt",
            "dueAt",
            "_links",
        ]
        nullable_fields = ["vatNumber", "paidAt", "dueAt"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
