"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .amount import Amount, AmountTypedDict
from .payment_method import PaymentMethod
from .settlement_status import SettlementStatus
from .url import URL, URLTypedDict
from .url_nullable import URLNullable, URLNullableTypedDict
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import validate_open_enum
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import PlainValidator
from typing import Dict, List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class RateTypedDict(TypedDict):
    r"""The service rates, further divided into `fixed` and `percentage` costs."""

    fixed: NotRequired[AmountTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    percentage: NotRequired[AmountTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""


class Rate(BaseModel):
    r"""The service rates, further divided into `fixed` and `percentage` costs."""

    fixed: Optional[Amount] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    percentage: Optional[Amount] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""


class CostTypedDict(TypedDict):
    description: NotRequired[str]
    r"""A description of the cost subtotal"""
    method: NotRequired[Nullable[PaymentMethod]]
    r"""The payment method, if applicable"""
    count: NotRequired[int]
    r"""The number of fees"""
    rate: NotRequired[RateTypedDict]
    r"""The service rates, further divided into `fixed` and `percentage` costs."""
    amount_net: NotRequired[AmountTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    amount_vat: NotRequired[AmountTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    amount_gross: NotRequired[AmountTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""


class Cost(BaseModel):
    description: Optional[str] = None
    r"""A description of the cost subtotal"""

    method: Annotated[
        OptionalNullable[PaymentMethod], PlainValidator(validate_open_enum(False))
    ] = UNSET
    r"""The payment method, if applicable"""

    count: Optional[int] = None
    r"""The number of fees"""

    rate: Optional[Rate] = None
    r"""The service rates, further divided into `fixed` and `percentage` costs."""

    amount_net: Annotated[Optional[Amount], pydantic.Field(alias="amountNet")] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    amount_vat: Annotated[Optional[Amount], pydantic.Field(alias="amountVat")] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    amount_gross: Annotated[Optional[Amount], pydantic.Field(alias="amountGross")] = (
        None
    )
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "description",
            "method",
            "count",
            "rate",
            "amountNet",
            "amountVat",
            "amountGross",
        ]
        nullable_fields = ["method"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class RevenueTypedDict(TypedDict):
    description: NotRequired[str]
    r"""A description of the revenue subtotal"""
    method: NotRequired[Nullable[PaymentMethod]]
    r"""The payment method, if applicable"""
    count: NotRequired[int]
    r"""The number of payments"""
    amount_net: NotRequired[AmountTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    amount_vat: NotRequired[AmountTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    amount_gross: NotRequired[AmountTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""


class Revenue(BaseModel):
    description: Optional[str] = None
    r"""A description of the revenue subtotal"""

    method: Annotated[
        OptionalNullable[PaymentMethod], PlainValidator(validate_open_enum(False))
    ] = UNSET
    r"""The payment method, if applicable"""

    count: Optional[int] = None
    r"""The number of payments"""

    amount_net: Annotated[Optional[Amount], pydantic.Field(alias="amountNet")] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    amount_vat: Annotated[Optional[Amount], pydantic.Field(alias="amountVat")] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    amount_gross: Annotated[Optional[Amount], pydantic.Field(alias="amountGross")] = (
        None
    )
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "description",
            "method",
            "count",
            "amountNet",
            "amountVat",
            "amountGross",
        ]
        nullable_fields = ["method"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class PeriodsTypedDict(TypedDict):
    costs: NotRequired[List[CostTypedDict]]
    r"""An array of cost objects, describing the fees withheld for each payment method during this period."""
    revenue: NotRequired[List[RevenueTypedDict]]
    r"""An array of revenue objects containing the total revenue for each payment method during this period."""
    invoice_id: NotRequired[str]
    invoice_reference: NotRequired[Nullable[str]]
    r"""The invoice reference, if the invoice has been created already."""


class Periods(BaseModel):
    costs: Optional[List[Cost]] = None
    r"""An array of cost objects, describing the fees withheld for each payment method during this period."""

    revenue: Optional[List[Revenue]] = None
    r"""An array of revenue objects containing the total revenue for each payment method during this period."""

    invoice_id: Annotated[Optional[str], pydantic.Field(alias="invoiceId")] = None

    invoice_reference: Annotated[
        OptionalNullable[str], pydantic.Field(alias="invoiceReference")
    ] = UNSET
    r"""The invoice reference, if the invoice has been created already."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["costs", "revenue", "invoiceId", "invoiceReference"]
        nullable_fields = ["invoiceReference"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EntitySettlementLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: NotRequired[URLTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    payments: NotRequired[URLTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    captures: NotRequired[URLTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    refunds: NotRequired[URLTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    chargebacks: NotRequired[URLTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    invoice: NotRequired[Nullable[URLNullableTypedDict]]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    documentation: NotRequired[URLTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class EntitySettlementLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[Optional[URL], pydantic.Field(alias="self")] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    payments: Optional[URL] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    captures: Optional[URL] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    refunds: Optional[URL] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    chargebacks: Optional[URL] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    invoice: OptionalNullable[URLNullable] = UNSET
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    documentation: Optional[URL] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "self",
            "payments",
            "captures",
            "refunds",
            "chargebacks",
            "invoice",
            "documentation",
        ]
        nullable_fields = ["invoice"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EntitySettlementTypedDict(TypedDict):
    resource: NotRequired[str]
    r"""Indicates the response contains a settlement object. Will always contain the string `settlement` for this
    endpoint.
    """
    id: NotRequired[str]
    created_at: NotRequired[str]
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""
    reference: NotRequired[Nullable[str]]
    r"""The settlement's bank reference, as found in your Mollie account and on your bank statement."""
    settled_at: NotRequired[Nullable[str]]
    r"""The date on which the settlement was settled, in ISO 8601 format.

    For an [open settlement](get-open-settlement) or for the [next settlement](get-next-settlement), no settlement
    date is available.
    """
    status: NotRequired[SettlementStatus]
    r"""The status of the settlement."""
    amount: NotRequired[AmountTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    balance_id: NotRequired[str]
    invoice_id: NotRequired[str]
    periods: NotRequired[Dict[str, Dict[str, PeriodsTypedDict]]]
    r"""For bookkeeping purposes, the settlement includes an overview of transactions included in the settlement. These
    transactions are grouped into 'period' objects — one for each calendar month.

    For example, if a settlement includes funds from 15 April until 4 May, it will include two period objects. One for
    all transactions processed between 15 April and 30 April, and one for all transactions between 1 May and 4 May.

    Period objects are grouped by year, and then by month. So in the above example, the full `periods` collection will
    look as follows: `{\"2024\": {\"04\": {...}, \"05\": {...}}}`. The year and month in this documentation are referred as `<year>` and `<month>`.

    The example response should give a good idea of what this looks like in practise.
    """
    links: NotRequired[EntitySettlementLinksTypedDict]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""


class EntitySettlement(BaseModel):
    resource: Optional[str] = None
    r"""Indicates the response contains a settlement object. Will always contain the string `settlement` for this
    endpoint.
    """

    id: Optional[str] = None

    created_at: Annotated[Optional[str], pydantic.Field(alias="createdAt")] = None
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""

    reference: OptionalNullable[str] = UNSET
    r"""The settlement's bank reference, as found in your Mollie account and on your bank statement."""

    settled_at: Annotated[OptionalNullable[str], pydantic.Field(alias="settledAt")] = (
        UNSET
    )
    r"""The date on which the settlement was settled, in ISO 8601 format.

    For an [open settlement](get-open-settlement) or for the [next settlement](get-next-settlement), no settlement
    date is available.
    """

    status: Annotated[
        Optional[SettlementStatus], PlainValidator(validate_open_enum(False))
    ] = None
    r"""The status of the settlement."""

    amount: Optional[Amount] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    balance_id: Annotated[Optional[str], pydantic.Field(alias="balanceId")] = None

    invoice_id: Annotated[Optional[str], pydantic.Field(alias="invoiceId")] = None

    periods: Optional[Dict[str, Dict[str, Periods]]] = None
    r"""For bookkeeping purposes, the settlement includes an overview of transactions included in the settlement. These
    transactions are grouped into 'period' objects — one for each calendar month.

    For example, if a settlement includes funds from 15 April until 4 May, it will include two period objects. One for
    all transactions processed between 15 April and 30 April, and one for all transactions between 1 May and 4 May.

    Period objects are grouped by year, and then by month. So in the above example, the full `periods` collection will
    look as follows: `{\"2024\": {\"04\": {...}, \"05\": {...}}}`. The year and month in this documentation are referred as `<year>` and `<month>`.

    The example response should give a good idea of what this looks like in practise.
    """

    links: Annotated[
        Optional[EntitySettlementLinks], pydantic.Field(alias="_links")
    ] = None
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "resource",
            "id",
            "createdAt",
            "reference",
            "settledAt",
            "status",
            "amount",
            "balanceId",
            "invoiceId",
            "periods",
            "_links",
        ]
        nullable_fields = ["reference", "settledAt"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
