"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .url import URL, URLTypedDict
from mollie.types import BaseModel
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class EntityPermissionLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: NotRequired[URLTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    documentation: NotRequired[URLTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class EntityPermissionLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[Optional[URL], pydantic.Field(alias="self")] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    documentation: Optional[URL] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class EntityPermissionTypedDict(TypedDict):
    resource: NotRequired[str]
    r"""Indicates the response contains a permission object. Will always contain the string `permission` for this
    endpoint.
    """
    id: NotRequired[str]
    description: NotRequired[str]
    r"""A short description of what kind of access the permission enables."""
    granted: NotRequired[bool]
    r"""Whether this permission is granted to the app by the organization."""
    links: NotRequired[EntityPermissionLinksTypedDict]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""


class EntityPermission(BaseModel):
    resource: Optional[str] = None
    r"""Indicates the response contains a permission object. Will always contain the string `permission` for this
    endpoint.
    """

    id: Optional[str] = None

    description: Optional[str] = None
    r"""A short description of what kind of access the permission enables."""

    granted: Optional[bool] = None
    r"""Whether this permission is granted to the app by the organization."""

    links: Annotated[
        Optional[EntityPermissionLinks], pydantic.Field(alias="_links")
    ] = None
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""
