"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .amount import Amount, AmountTypedDict
from .capture_mode import CaptureMode
from .entity_payment_route import EntityPaymentRoute, EntityPaymentRouteTypedDict
from .line_categories import LineCategories
from .locale import Locale
from .metadata import Metadata, MetadataTypedDict
from .method import Method
from .payment_address import PaymentAddress, PaymentAddressTypedDict
from .payment_line_type import PaymentLineType
from .recurring_line_item import RecurringLineItem, RecurringLineItemTypedDict
from .sequence_type import SequenceType
from datetime import date
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
import pydantic
from pydantic import model_serializer
from typing import Any, Dict, List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class PaymentRequestLineTypedDict(TypedDict):
    description: str
    r"""A description of the line item. For example *LEGO 4440 Forest Police Station*."""
    quantity: int
    r"""The number of items."""
    unit_price: AmountTypedDict
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    total_amount: AmountTypedDict
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    type: NotRequired[PaymentLineType]
    r"""The type of product purchased. For example, a physical or a digital product.

    The `tip` payment line type is not available when creating a payment.
    """
    quantity_unit: NotRequired[str]
    r"""The unit for the quantity. For example *pcs*, *kg*, or *cm*."""
    discount_amount: NotRequired[AmountTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    vat_rate: NotRequired[str]
    r"""The VAT rate applied to the line, for example `21.00` for 21%. The vatRate should be passed as a string and
    not as a float, to ensure the correct number of decimals are passed.
    """
    vat_amount: NotRequired[AmountTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    sku: NotRequired[str]
    r"""The SKU, EAN, ISBN or UPC of the product sold."""
    categories: NotRequired[List[LineCategories]]
    r"""An array with the voucher categories, in case of a line eligible for a voucher. See the
    [Integrating Vouchers](https://docs.mollie.com/docs/integrating-vouchers/) guide for more information.
    """
    image_url: NotRequired[str]
    r"""A link pointing to an image of the product sold."""
    product_url: NotRequired[str]
    r"""A link pointing to the product page in your web shop of the product sold."""
    recurring: NotRequired[RecurringLineItemTypedDict]


class PaymentRequestLine(BaseModel):
    description: str
    r"""A description of the line item. For example *LEGO 4440 Forest Police Station*."""

    quantity: int
    r"""The number of items."""

    unit_price: Annotated[Amount, pydantic.Field(alias="unitPrice")]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    total_amount: Annotated[Amount, pydantic.Field(alias="totalAmount")]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    type: Optional[PaymentLineType] = None
    r"""The type of product purchased. For example, a physical or a digital product.

    The `tip` payment line type is not available when creating a payment.
    """

    quantity_unit: Annotated[Optional[str], pydantic.Field(alias="quantityUnit")] = None
    r"""The unit for the quantity. For example *pcs*, *kg*, or *cm*."""

    discount_amount: Annotated[
        Optional[Amount], pydantic.Field(alias="discountAmount")
    ] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    vat_rate: Annotated[Optional[str], pydantic.Field(alias="vatRate")] = None
    r"""The VAT rate applied to the line, for example `21.00` for 21%. The vatRate should be passed as a string and
    not as a float, to ensure the correct number of decimals are passed.
    """

    vat_amount: Annotated[Optional[Amount], pydantic.Field(alias="vatAmount")] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    sku: Optional[str] = None
    r"""The SKU, EAN, ISBN or UPC of the product sold."""

    categories: Optional[List[LineCategories]] = None
    r"""An array with the voucher categories, in case of a line eligible for a voucher. See the
    [Integrating Vouchers](https://docs.mollie.com/docs/integrating-vouchers/) guide for more information.
    """

    image_url: Annotated[Optional[str], pydantic.Field(alias="imageUrl")] = None
    r"""A link pointing to an image of the product sold."""

    product_url: Annotated[Optional[str], pydantic.Field(alias="productUrl")] = None
    r"""A link pointing to the product page in your web shop of the product sold."""

    recurring: Optional[RecurringLineItem] = None


class PaymentRequestApplicationFeeTypedDict(TypedDict):
    r"""With Mollie Connect you can charge fees on payments that your app is processing on behalf of other Mollie
    merchants.

    If you use OAuth to create payments on a connected merchant's account, you can charge a fee using this
    `applicationFee` parameter. If the payment succeeds, the fee will be deducted from the merchant's balance and sent
    to your own account balance.

    If instead you want to split a payment on your own account between yourself and a connected merchant, refer to the
    `routing` parameter.
    """

    amount: NotRequired[AmountTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    description: NotRequired[str]
    r"""The description of the application fee. This will appear on settlement reports towards both you and the
    connected merchant.
    """


class PaymentRequestApplicationFee(BaseModel):
    r"""With Mollie Connect you can charge fees on payments that your app is processing on behalf of other Mollie
    merchants.

    If you use OAuth to create payments on a connected merchant's account, you can charge a fee using this
    `applicationFee` parameter. If the payment succeeds, the fee will be deducted from the merchant's balance and sent
    to your own account balance.

    If instead you want to split a payment on your own account between yourself and a connected merchant, refer to the
    `routing` parameter.
    """

    amount: Optional[Amount] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    description: Optional[str] = None
    r"""The description of the application fee. This will appear on settlement reports towards both you and the
    connected merchant.
    """


class CompanyTypedDict(TypedDict):
    r"""Billie is a business-to-business (B2B) payment method. It requires extra information to identify the organization
    that is completing the payment. It is recommended to include these parameters up front for a seamless flow.
    Otherwise, Billie will ask the customer to complete the missing fields during checkout.
    """

    registration_number: NotRequired[str]
    r"""The organization's registration number."""
    vat_number: NotRequired[str]
    r"""The organization's VAT number."""
    entity_type: NotRequired[str]
    r"""The organization's entity type."""


class Company(BaseModel):
    r"""Billie is a business-to-business (B2B) payment method. It requires extra information to identify the organization
    that is completing the payment. It is recommended to include these parameters up front for a seamless flow.
    Otherwise, Billie will ask the customer to complete the missing fields during checkout.
    """

    registration_number: Annotated[
        Optional[str], pydantic.Field(alias="registrationNumber")
    ] = None
    r"""The organization's registration number."""

    vat_number: Annotated[Optional[str], pydantic.Field(alias="vatNumber")] = None
    r"""The organization's VAT number."""

    entity_type: Annotated[Optional[str], pydantic.Field(alias="entityType")] = None
    r"""The organization's entity type."""


class PaymentRequestTypedDict(TypedDict):
    id: NotRequired[str]
    description: NotRequired[str]
    r"""The description of the payment. This will be shown to your customer on their card or bank statement when possible.
    We truncate the description automatically according to the limits of the used payment method. The description is
    also visible in any exports you generate.

    We recommend you use a unique identifier so that you can always link the payment to the order in your back office.
    This is particularly useful for bookkeeping.

    The maximum length of the description field differs per payment method, with the absolute maximum being 255
    characters. The API will not reject strings longer than the maximum length but it will truncate them to fit.
    """
    amount: NotRequired[AmountTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    amount_refunded: NotRequired[AmountTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    amount_remaining: NotRequired[AmountTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    amount_captured: NotRequired[AmountTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    amount_charged_back: NotRequired[AmountTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    settlement_amount: NotRequired[AmountTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    redirect_url: NotRequired[Nullable[str]]
    r"""The URL your customer will be redirected to after the payment process.

    It could make sense for the redirectUrl to contain a unique identifier – like your order ID – so you can show the
    right page referencing the order when your customer returns.

    The parameter is normally required, but can be omitted for recurring payments (`sequenceType: recurring`) and for
    Apple Pay payments with an `applePayPaymentToken`.
    """
    cancel_url: NotRequired[Nullable[str]]
    r"""The URL your customer will be redirected to when the customer explicitly cancels the payment. If this URL is not
    provided, the customer will be redirected to the `redirectUrl` instead — see above.

    Mollie will always give you status updates via webhooks, including for the canceled status. This parameter is
    therefore entirely optional, but can be useful when implementing a dedicated customer-facing flow to handle
    payment cancellations.
    """
    webhook_url: NotRequired[Nullable[str]]
    r"""The webhook URL where we will send payment status updates to.

    The webhookUrl is optional, but without a webhook you will miss out on important status changes to your payment.

    The webhookUrl must be reachable from Mollie's point of view, so you cannot use `localhost`. If you want to use
    webhook during development on `localhost`, you must use a tool like ngrok to have the webhooks delivered to your
    local machine.
    """
    lines: NotRequired[Nullable[List[PaymentRequestLineTypedDict]]]
    r"""Optionally provide the order lines for the payment. Each line contains details such as a description of the item
    ordered and its price.

    All lines must have the same currency as the payment.

    Required for payment methods `billie`, `in3`, `klarna`, `riverty` and `voucher`.
    """
    billing_address: NotRequired[PaymentAddressTypedDict]
    shipping_address: NotRequired[PaymentAddressTypedDict]
    locale: NotRequired[Nullable[Locale]]
    r"""Allows you to preset the language to be used."""
    method: NotRequired[Nullable[Method]]
    r"""Normally, a payment method screen is shown. However, when using this parameter, you can choose a specific payment
    method and your customer will skip the selection screen and is sent directly to the chosen payment method. The
    parameter enables you to fully integrate the payment method selection into your website.

    You can also specify the methods in an array. By doing so we will still show the payment method selection screen
    but will only show the methods specified in the array. For example, you can use this functionality to only show
    payment methods from a specific country to your customer `['bancontact', 'belfius']`.
    """
    issuer: NotRequired[Nullable[str]]
    r"""**Only relevant for iDEAL, KBC/CBC, gift card, and voucher payments.**

    **⚠️ With the introduction of iDEAL 2 in 2025, this field will be ignored for iDEAL payments. For more information
    on the migration, refer to our [help center](https://help.mollie.com/hc/articles/19100313768338-iDEAL-2-0).**

    Some payment methods are a network of connected banks or card issuers. In these cases, after selecting the payment
    method, the customer may still need to select the appropriate issuer before the payment can proceed.

    We provide hosted issuer selection screens, but these screens can be skipped by providing the `issuer` via the API
    up front.

    The full list of issuers for a specific method can be retrieved via the Methods API by using the optional
    `issuers` include.

    A valid issuer for iDEAL is for example `ideal_INGBNL2A` (for ING Bank).
    """
    restrict_payment_methods_to_country: NotRequired[Nullable[str]]
    r"""For digital goods in most jurisdictions, you must apply the VAT rate from your customer's country. Choose the VAT
    rates you have used for the order to ensure your customer's country matches the VAT country.

    Use this parameter to restrict the payment methods available to your customer to those from a single country.

    If available, the credit card method will still be offered, but only cards from the allowed country are accepted.

    The field expects a country code in ISO 3166-1 alpha-2 format, for example `NL`.
    """
    metadata: NotRequired[Nullable[MetadataTypedDict]]
    r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever
    you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB.
    """
    capture_mode: NotRequired[Nullable[CaptureMode]]
    r"""Indicate if the funds should be captured immediately or if you want to [place a hold](https://docs.mollie.com/docs/place-a-hold-for-a-payment#/)
    and capture at a later time.

    This field needs to be set to `manual` for method `riverty`.
    """
    capture_delay: NotRequired[Nullable[str]]
    r"""**Only relevant if you wish to manage authorization and capturing separately.**

    Some payment methods allow placing a hold on the card or bank account. This hold or 'authorization' can then at a
    later point either be 'captured' or canceled.

    By default, we charge the customer's card or bank account immediately when they complete the payment. If you set a
    capture delay however, we will delay the automatic capturing of the payment for the specified amount of time. For
    example `8 hours` or `2 days`.

    To schedule an automatic capture, the `captureMode` must be set to `automatic`.

    The maximum delay is 7 days (168 hours).

    Possible values: `... hours` `... days`
    """
    application_fee: NotRequired[Nullable[PaymentRequestApplicationFeeTypedDict]]
    r"""With Mollie Connect you can charge fees on payments that your app is processing on behalf of other Mollie
    merchants.

    If you use OAuth to create payments on a connected merchant's account, you can charge a fee using this
    `applicationFee` parameter. If the payment succeeds, the fee will be deducted from the merchant's balance and sent
    to your own account balance.

    If instead you want to split a payment on your own account between yourself and a connected merchant, refer to the
    `routing` parameter.
    """
    routing: NotRequired[Nullable[List[EntityPaymentRouteTypedDict]]]
    r"""*This functionality is not enabled by default. Reach out to our partner management team if you wish to use it.*

    With Mollie Connect you can charge fees on payments that your app is processing on behalf of other Mollie
    merchants.

    If you create payments on your own account that you want to split between yourself and one or more connected
    merchants, you can use this `routing` parameter to route the payment accordingly.

    The `routing` parameter should contain an array of objects, with each object describing the destination for a
    specific portion of the payment.

    It is not necessary to indicate in the array which portion goes to yourself. After all portions of the total
    payment amount have been routed, the amount left will be routed to the current organization automatically.

    If instead you use OAuth to create payments on a connected merchant's account, refer to the `applicationFee`
    parameter.
    """
    sequence_type: NotRequired[SequenceType]
    subscription_id: NotRequired[str]
    mandate_id: NotRequired[str]
    customer_id: NotRequired[str]
    profile_id: NotRequired[str]
    r"""The identifier referring to the [profile](get-profile) this entity belongs to.

    Most API credentials are linked to a single profile. In these cases the `profileId` can be omitted in the creation
    request. For organization-level credentials such as OAuth access tokens however, the `profileId` parameter is
    required.
    """
    settlement_id: NotRequired[str]
    order_id: NotRequired[str]
    due_date: NotRequired[str]
    r"""The date by which the payment should be completed in `YYYY-MM-DD` format"""
    testmode: NotRequired[Nullable[bool]]
    r"""Whether to create the entity in test mode or live mode.

    Most API credentials are specifically created for either live mode or test mode, in which case this parameter can be
    omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting
    `testmode` to `true`.
    """
    apple_pay_payment_token: NotRequired[str]
    r"""The Apple Pay Payment token object (encoded as JSON) that is part of the result of authorizing a payment request.
    The token contains the payment information needed to authorize the payment.

    The object should be passed encoded in a JSON string.
    """
    company: NotRequired[CompanyTypedDict]
    r"""Billie is a business-to-business (B2B) payment method. It requires extra information to identify the organization
    that is completing the payment. It is recommended to include these parameters up front for a seamless flow.
    Otherwise, Billie will ask the customer to complete the missing fields during checkout.
    """
    card_token: NotRequired[str]
    r"""When creating credit card payments using Mollie Components, you need to provide the card token you received from
    the card component in this field. The token represents the customer's card information needed to complete the
    payment. Note: field only valid for oneoff and first payments. For recurring payments, the customerId alone is
    enough.
    """
    voucher_number: NotRequired[str]
    r"""The card token you received from the card component of Mollie Components. The token represents the customer's card
    information needed to complete the payment.
    """
    voucher_pin: NotRequired[str]
    r"""The PIN on the gift card. You can supply this to prefill the PIN, if the card has any."""
    consumer_date_of_birth: NotRequired[date]
    r"""The customer's date of birth. If not provided via the API, iDeal in3 will ask the customer to provide it during
    the payment process.
    """
    extra_merchant_data: NotRequired[Dict[str, Any]]
    r"""For some industries, additional purchase information can be sent to Klarna to increase the authorization rate.
    You can submit your extra data in this field if you have agreed upon this with Klarna. This field should be an
    object containing any of the allowed keys and sub-objects described at the Klarna Developer Documentation.
    """
    session_id: NotRequired[str]
    r"""The unique ID you have used for the PayPal fraud library. You should include this if you use PayPal for an
    on-demand payment.
    """
    digital_goods: NotRequired[bool]
    r"""Indicate if you are about to deliver digital goods, such as for example a software license. Setting this parameter
    can have consequences for your PayPal Seller Protection. Refer to PayPal's documentation for more information.
    """
    customer_reference: NotRequired[str]
    r"""Used by paysafecard for customer identification across payments. When you generate a customer reference yourself,
    make sure not to put personal identifiable information or IP addresses in the customer reference directly.
    """
    terminal_id: NotRequired[str]
    r"""The ID of the terminal device where you want to initiate the payment on."""


class PaymentRequest(BaseModel):
    id: Optional[str] = None

    description: Optional[str] = None
    r"""The description of the payment. This will be shown to your customer on their card or bank statement when possible.
    We truncate the description automatically according to the limits of the used payment method. The description is
    also visible in any exports you generate.

    We recommend you use a unique identifier so that you can always link the payment to the order in your back office.
    This is particularly useful for bookkeeping.

    The maximum length of the description field differs per payment method, with the absolute maximum being 255
    characters. The API will not reject strings longer than the maximum length but it will truncate them to fit.
    """

    amount: Optional[Amount] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    amount_refunded: Annotated[
        Optional[Amount], pydantic.Field(alias="amountRefunded")
    ] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    amount_remaining: Annotated[
        Optional[Amount], pydantic.Field(alias="amountRemaining")
    ] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    amount_captured: Annotated[
        Optional[Amount], pydantic.Field(alias="amountCaptured")
    ] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    amount_charged_back: Annotated[
        Optional[Amount], pydantic.Field(alias="amountChargedBack")
    ] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    settlement_amount: Annotated[
        Optional[Amount], pydantic.Field(alias="settlementAmount")
    ] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    redirect_url: Annotated[
        OptionalNullable[str], pydantic.Field(alias="redirectUrl")
    ] = UNSET
    r"""The URL your customer will be redirected to after the payment process.

    It could make sense for the redirectUrl to contain a unique identifier – like your order ID – so you can show the
    right page referencing the order when your customer returns.

    The parameter is normally required, but can be omitted for recurring payments (`sequenceType: recurring`) and for
    Apple Pay payments with an `applePayPaymentToken`.
    """

    cancel_url: Annotated[OptionalNullable[str], pydantic.Field(alias="cancelUrl")] = (
        UNSET
    )
    r"""The URL your customer will be redirected to when the customer explicitly cancels the payment. If this URL is not
    provided, the customer will be redirected to the `redirectUrl` instead — see above.

    Mollie will always give you status updates via webhooks, including for the canceled status. This parameter is
    therefore entirely optional, but can be useful when implementing a dedicated customer-facing flow to handle
    payment cancellations.
    """

    webhook_url: Annotated[
        OptionalNullable[str], pydantic.Field(alias="webhookUrl")
    ] = UNSET
    r"""The webhook URL where we will send payment status updates to.

    The webhookUrl is optional, but without a webhook you will miss out on important status changes to your payment.

    The webhookUrl must be reachable from Mollie's point of view, so you cannot use `localhost`. If you want to use
    webhook during development on `localhost`, you must use a tool like ngrok to have the webhooks delivered to your
    local machine.
    """

    lines: OptionalNullable[List[PaymentRequestLine]] = UNSET
    r"""Optionally provide the order lines for the payment. Each line contains details such as a description of the item
    ordered and its price.

    All lines must have the same currency as the payment.

    Required for payment methods `billie`, `in3`, `klarna`, `riverty` and `voucher`.
    """

    billing_address: Annotated[
        Optional[PaymentAddress], pydantic.Field(alias="billingAddress")
    ] = None

    shipping_address: Annotated[
        Optional[PaymentAddress], pydantic.Field(alias="shippingAddress")
    ] = None

    locale: OptionalNullable[Locale] = UNSET
    r"""Allows you to preset the language to be used."""

    method: OptionalNullable[Method] = UNSET
    r"""Normally, a payment method screen is shown. However, when using this parameter, you can choose a specific payment
    method and your customer will skip the selection screen and is sent directly to the chosen payment method. The
    parameter enables you to fully integrate the payment method selection into your website.

    You can also specify the methods in an array. By doing so we will still show the payment method selection screen
    but will only show the methods specified in the array. For example, you can use this functionality to only show
    payment methods from a specific country to your customer `['bancontact', 'belfius']`.
    """

    issuer: OptionalNullable[str] = UNSET
    r"""**Only relevant for iDEAL, KBC/CBC, gift card, and voucher payments.**

    **⚠️ With the introduction of iDEAL 2 in 2025, this field will be ignored for iDEAL payments. For more information
    on the migration, refer to our [help center](https://help.mollie.com/hc/articles/19100313768338-iDEAL-2-0).**

    Some payment methods are a network of connected banks or card issuers. In these cases, after selecting the payment
    method, the customer may still need to select the appropriate issuer before the payment can proceed.

    We provide hosted issuer selection screens, but these screens can be skipped by providing the `issuer` via the API
    up front.

    The full list of issuers for a specific method can be retrieved via the Methods API by using the optional
    `issuers` include.

    A valid issuer for iDEAL is for example `ideal_INGBNL2A` (for ING Bank).
    """

    restrict_payment_methods_to_country: Annotated[
        OptionalNullable[str], pydantic.Field(alias="restrictPaymentMethodsToCountry")
    ] = UNSET
    r"""For digital goods in most jurisdictions, you must apply the VAT rate from your customer's country. Choose the VAT
    rates you have used for the order to ensure your customer's country matches the VAT country.

    Use this parameter to restrict the payment methods available to your customer to those from a single country.

    If available, the credit card method will still be offered, but only cards from the allowed country are accepted.

    The field expects a country code in ISO 3166-1 alpha-2 format, for example `NL`.
    """

    metadata: OptionalNullable[Metadata] = UNSET
    r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever
    you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB.
    """

    capture_mode: Annotated[
        OptionalNullable[CaptureMode], pydantic.Field(alias="captureMode")
    ] = UNSET
    r"""Indicate if the funds should be captured immediately or if you want to [place a hold](https://docs.mollie.com/docs/place-a-hold-for-a-payment#/)
    and capture at a later time.

    This field needs to be set to `manual` for method `riverty`.
    """

    capture_delay: Annotated[
        OptionalNullable[str], pydantic.Field(alias="captureDelay")
    ] = UNSET
    r"""**Only relevant if you wish to manage authorization and capturing separately.**

    Some payment methods allow placing a hold on the card or bank account. This hold or 'authorization' can then at a
    later point either be 'captured' or canceled.

    By default, we charge the customer's card or bank account immediately when they complete the payment. If you set a
    capture delay however, we will delay the automatic capturing of the payment for the specified amount of time. For
    example `8 hours` or `2 days`.

    To schedule an automatic capture, the `captureMode` must be set to `automatic`.

    The maximum delay is 7 days (168 hours).

    Possible values: `... hours` `... days`
    """

    application_fee: Annotated[
        OptionalNullable[PaymentRequestApplicationFee],
        pydantic.Field(alias="applicationFee"),
    ] = UNSET
    r"""With Mollie Connect you can charge fees on payments that your app is processing on behalf of other Mollie
    merchants.

    If you use OAuth to create payments on a connected merchant's account, you can charge a fee using this
    `applicationFee` parameter. If the payment succeeds, the fee will be deducted from the merchant's balance and sent
    to your own account balance.

    If instead you want to split a payment on your own account between yourself and a connected merchant, refer to the
    `routing` parameter.
    """

    routing: OptionalNullable[List[EntityPaymentRoute]] = UNSET
    r"""*This functionality is not enabled by default. Reach out to our partner management team if you wish to use it.*

    With Mollie Connect you can charge fees on payments that your app is processing on behalf of other Mollie
    merchants.

    If you create payments on your own account that you want to split between yourself and one or more connected
    merchants, you can use this `routing` parameter to route the payment accordingly.

    The `routing` parameter should contain an array of objects, with each object describing the destination for a
    specific portion of the payment.

    It is not necessary to indicate in the array which portion goes to yourself. After all portions of the total
    payment amount have been routed, the amount left will be routed to the current organization automatically.

    If instead you use OAuth to create payments on a connected merchant's account, refer to the `applicationFee`
    parameter.
    """

    sequence_type: Annotated[
        Optional[SequenceType], pydantic.Field(alias="sequenceType")
    ] = None

    subscription_id: Annotated[
        Optional[str], pydantic.Field(alias="subscriptionId")
    ] = None

    mandate_id: Annotated[Optional[str], pydantic.Field(alias="mandateId")] = None

    customer_id: Annotated[Optional[str], pydantic.Field(alias="customerId")] = None

    profile_id: Annotated[Optional[str], pydantic.Field(alias="profileId")] = None
    r"""The identifier referring to the [profile](get-profile) this entity belongs to.

    Most API credentials are linked to a single profile. In these cases the `profileId` can be omitted in the creation
    request. For organization-level credentials such as OAuth access tokens however, the `profileId` parameter is
    required.
    """

    settlement_id: Annotated[Optional[str], pydantic.Field(alias="settlementId")] = None

    order_id: Annotated[Optional[str], pydantic.Field(alias="orderId")] = None

    due_date: Annotated[Optional[str], pydantic.Field(alias="dueDate")] = None
    r"""The date by which the payment should be completed in `YYYY-MM-DD` format"""

    testmode: OptionalNullable[bool] = UNSET
    r"""Whether to create the entity in test mode or live mode.

    Most API credentials are specifically created for either live mode or test mode, in which case this parameter can be
    omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting
    `testmode` to `true`.
    """

    apple_pay_payment_token: Annotated[
        Optional[str], pydantic.Field(alias="applePayPaymentToken")
    ] = None
    r"""The Apple Pay Payment token object (encoded as JSON) that is part of the result of authorizing a payment request.
    The token contains the payment information needed to authorize the payment.

    The object should be passed encoded in a JSON string.
    """

    company: Optional[Company] = None
    r"""Billie is a business-to-business (B2B) payment method. It requires extra information to identify the organization
    that is completing the payment. It is recommended to include these parameters up front for a seamless flow.
    Otherwise, Billie will ask the customer to complete the missing fields during checkout.
    """

    card_token: Annotated[Optional[str], pydantic.Field(alias="cardToken")] = None
    r"""When creating credit card payments using Mollie Components, you need to provide the card token you received from
    the card component in this field. The token represents the customer's card information needed to complete the
    payment. Note: field only valid for oneoff and first payments. For recurring payments, the customerId alone is
    enough.
    """

    voucher_number: Annotated[Optional[str], pydantic.Field(alias="voucherNumber")] = (
        None
    )
    r"""The card token you received from the card component of Mollie Components. The token represents the customer's card
    information needed to complete the payment.
    """

    voucher_pin: Annotated[Optional[str], pydantic.Field(alias="voucherPin")] = None
    r"""The PIN on the gift card. You can supply this to prefill the PIN, if the card has any."""

    consumer_date_of_birth: Annotated[
        Optional[date], pydantic.Field(alias="consumerDateOfBirth")
    ] = None
    r"""The customer's date of birth. If not provided via the API, iDeal in3 will ask the customer to provide it during
    the payment process.
    """

    extra_merchant_data: Annotated[
        Optional[Dict[str, Any]], pydantic.Field(alias="extraMerchantData")
    ] = None
    r"""For some industries, additional purchase information can be sent to Klarna to increase the authorization rate.
    You can submit your extra data in this field if you have agreed upon this with Klarna. This field should be an
    object containing any of the allowed keys and sub-objects described at the Klarna Developer Documentation.
    """

    session_id: Annotated[Optional[str], pydantic.Field(alias="sessionId")] = None
    r"""The unique ID you have used for the PayPal fraud library. You should include this if you use PayPal for an
    on-demand payment.
    """

    digital_goods: Annotated[Optional[bool], pydantic.Field(alias="digitalGoods")] = (
        None
    )
    r"""Indicate if you are about to deliver digital goods, such as for example a software license. Setting this parameter
    can have consequences for your PayPal Seller Protection. Refer to PayPal's documentation for more information.
    """

    customer_reference: Annotated[
        Optional[str], pydantic.Field(alias="customerReference")
    ] = None
    r"""Used by paysafecard for customer identification across payments. When you generate a customer reference yourself,
    make sure not to put personal identifiable information or IP addresses in the customer reference directly.
    """

    terminal_id: Annotated[Optional[str], pydantic.Field(alias="terminalId")] = None
    r"""The ID of the terminal device where you want to initiate the payment on."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "id",
            "description",
            "amount",
            "amountRefunded",
            "amountRemaining",
            "amountCaptured",
            "amountChargedBack",
            "settlementAmount",
            "redirectUrl",
            "cancelUrl",
            "webhookUrl",
            "lines",
            "billingAddress",
            "shippingAddress",
            "locale",
            "method",
            "issuer",
            "restrictPaymentMethodsToCountry",
            "metadata",
            "captureMode",
            "captureDelay",
            "applicationFee",
            "routing",
            "sequenceType",
            "subscriptionId",
            "mandateId",
            "customerId",
            "profileId",
            "settlementId",
            "orderId",
            "dueDate",
            "testmode",
            "applePayPaymentToken",
            "company",
            "cardToken",
            "voucherNumber",
            "voucherPin",
            "consumerDateOfBirth",
            "extraMerchantData",
            "sessionId",
            "digitalGoods",
            "customerReference",
            "terminalId",
        ]
        nullable_fields = [
            "redirectUrl",
            "cancelUrl",
            "webhookUrl",
            "lines",
            "locale",
            "method",
            "issuer",
            "restrictPaymentMethodsToCountry",
            "metadata",
            "captureMode",
            "captureDelay",
            "applicationFee",
            "routing",
            "testmode",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
