"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .address import Address, AddressTypedDict
from .locale_response import LocaleResponse
from .organization_vat_regulation import OrganizationVatRegulation
from .url import URL, URLTypedDict
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import validate_open_enum
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import PlainValidator
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class EntityOrganizationLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: NotRequired[URLTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    dashboard: NotRequired[URLTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    documentation: NotRequired[URLTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class EntityOrganizationLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[Optional[URL], pydantic.Field(alias="self")] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    dashboard: Optional[URL] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    documentation: Optional[URL] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class EntityOrganizationTypedDict(TypedDict):
    resource: NotRequired[str]
    r"""Indicates the response contains an organization object. Will always contain the string `organization` for this
    resource type.
    """
    id: NotRequired[str]
    r"""The identifier uniquely referring to this organization. Example: `org_12345678`."""
    name: NotRequired[str]
    r"""The name of the organization."""
    email: NotRequired[str]
    r"""The email address associated with the organization."""
    locale: NotRequired[Nullable[LocaleResponse]]
    r"""Allows you to preset the language to be used."""
    address: NotRequired[AddressTypedDict]
    registration_number: NotRequired[str]
    r"""The registration number of the organization at their local chamber of commerce."""
    vat_number: NotRequired[Nullable[str]]
    r"""The VAT number of the organization, if based in the European Union or in The United Kingdom. VAT numbers are
    verified against the international registry *VIES*.

    The field is not present for merchants residing in other countries.
    """
    vat_regulation: NotRequired[Nullable[OrganizationVatRegulation]]
    r"""Mollie applies Dutch VAT for merchants based in The Netherlands, British VAT for merchants based in The United
    Kingdom, and shifted VAT for merchants in the European Union.

    The field is not present for merchants residing in other countries.
    """
    links: NotRequired[EntityOrganizationLinksTypedDict]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""


class EntityOrganization(BaseModel):
    resource: Optional[str] = None
    r"""Indicates the response contains an organization object. Will always contain the string `organization` for this
    resource type.
    """

    id: Optional[str] = None
    r"""The identifier uniquely referring to this organization. Example: `org_12345678`."""

    name: Optional[str] = None
    r"""The name of the organization."""

    email: Optional[str] = None
    r"""The email address associated with the organization."""

    locale: Annotated[
        OptionalNullable[LocaleResponse], PlainValidator(validate_open_enum(False))
    ] = UNSET
    r"""Allows you to preset the language to be used."""

    address: Optional[Address] = None

    registration_number: Annotated[
        Optional[str], pydantic.Field(alias="registrationNumber")
    ] = None
    r"""The registration number of the organization at their local chamber of commerce."""

    vat_number: Annotated[OptionalNullable[str], pydantic.Field(alias="vatNumber")] = (
        UNSET
    )
    r"""The VAT number of the organization, if based in the European Union or in The United Kingdom. VAT numbers are
    verified against the international registry *VIES*.

    The field is not present for merchants residing in other countries.
    """

    vat_regulation: Annotated[
        Annotated[
            OptionalNullable[OrganizationVatRegulation],
            PlainValidator(validate_open_enum(False)),
        ],
        pydantic.Field(alias="vatRegulation"),
    ] = UNSET
    r"""Mollie applies Dutch VAT for merchants based in The Netherlands, British VAT for merchants based in The United
    Kingdom, and shifted VAT for merchants in the European Union.

    The field is not present for merchants residing in other countries.
    """

    links: Annotated[
        Optional[EntityOrganizationLinks], pydantic.Field(alias="_links")
    ] = None
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "resource",
            "id",
            "name",
            "email",
            "locale",
            "address",
            "registrationNumber",
            "vatNumber",
            "vatRegulation",
            "_links",
        ]
        nullable_fields = ["locale", "vatNumber", "vatRegulation"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
