"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .amount import Amount, AmountTypedDict
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
import pydantic
from pydantic import model_serializer
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class RecurringLineItemTypedDict(TypedDict):
    interval: str
    r"""Cadence unit of the recurring item. For example: `12 months`, `52 weeks` or `365 days`.

    Possible values: `... days`, `... weeks`, `... months`.
    """
    description: NotRequired[str]
    r"""A description of the recurring item. If not present, the main description of the item will be used."""
    amount: NotRequired[AmountTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    times: NotRequired[int]
    r"""Total number of charges for the subscription to complete. Leave empty for ongoing subscription."""
    start_date: NotRequired[Nullable[str]]
    r"""The start date of the subscription if it does not start right away (format `YYYY-MM-DD`)"""


class RecurringLineItem(BaseModel):
    interval: str
    r"""Cadence unit of the recurring item. For example: `12 months`, `52 weeks` or `365 days`.

    Possible values: `... days`, `... weeks`, `... months`.
    """

    description: Optional[str] = None
    r"""A description of the recurring item. If not present, the main description of the item will be used."""

    amount: Optional[Amount] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    times: Optional[int] = None
    r"""Total number of charges for the subscription to complete. Leave empty for ongoing subscription."""

    start_date: Annotated[OptionalNullable[str], pydantic.Field(alias="startDate")] = (
        UNSET
    )
    r"""The start date of the subscription if it does not start right away (format `YYYY-MM-DD`)"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["description", "amount", "times", "startDate"]
        nullable_fields = ["startDate"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
