"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .amount import Amount, AmountTypedDict
from .route_destination_type_response import RouteDestinationTypeResponse
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import validate_open_enum
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import PlainValidator
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class EntityRouteDestinationTypedDict(TypedDict):
    r"""The destination of the route."""

    type: RouteDestinationTypeResponse
    r"""The type of destination. Currently only the destination type `organization` is supported."""
    organization_id: str


class EntityRouteDestination(BaseModel):
    r"""The destination of the route."""

    type: Annotated[
        RouteDestinationTypeResponse, PlainValidator(validate_open_enum(False))
    ]
    r"""The type of destination. Currently only the destination type `organization` is supported."""

    organization_id: Annotated[str, pydantic.Field(alias="organizationId")]


class EntityRouteTypedDict(TypedDict):
    id: NotRequired[str]
    payment_id: NotRequired[str]
    amount: NotRequired[AmountTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    description: NotRequired[str]
    r"""The description of the route. This description is shown in the reports."""
    destination: NotRequired[EntityRouteDestinationTypedDict]
    r"""The destination of the route."""
    testmode: NotRequired[Nullable[bool]]
    r"""Whether to create the entity in test mode or live mode.

    Most API credentials are specifically created for either live mode or test mode, in which case this parameter can be
    omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting
    `testmode` to `true`.
    """


class EntityRoute(BaseModel):
    id: Optional[str] = None

    payment_id: Annotated[Optional[str], pydantic.Field(alias="paymentId")] = None

    amount: Optional[Amount] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    description: Optional[str] = None
    r"""The description of the route. This description is shown in the reports."""

    destination: Optional[EntityRouteDestination] = None
    r"""The destination of the route."""

    testmode: OptionalNullable[bool] = UNSET
    r"""Whether to create the entity in test mode or live mode.

    Most API credentials are specifically created for either live mode or test mode, in which case this parameter can be
    omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting
    `testmode` to `true`.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "id",
            "paymentId",
            "amount",
            "description",
            "destination",
            "testmode",
        ]
        nullable_fields = ["testmode"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
