"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .amount import Amount, AmountTypedDict
from .payment_address import PaymentAddress, PaymentAddressTypedDict
from .payment_line_item import PaymentLineItem, PaymentLineItemTypedDict
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import (
    FieldMetadata,
    HeaderMetadata,
    PathParamMetadata,
    RequestMetadata,
)
import pydantic
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class UpdatePaymentLinkRequestBodyTypedDict(TypedDict):
    description: NotRequired[str]
    r"""A short description of the payment link. The description is visible in the Dashboard and will be shown
    on the customer's bank or card statement when possible.

    Updating the description does not affect any previously existing payments created for this payment link.
    """
    minimum_amount: NotRequired[AmountTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    archived: NotRequired[bool]
    r"""Whether the payment link is archived. Customers will not be able to complete payments on archived
    payment links.
    """
    allowed_methods: NotRequired[Nullable[List[str]]]
    r"""An array of payment methods that are allowed to be used for this payment link. When this parameter is
    not provided or is an empty array, all enabled payment methods will be available.

    Enum: 'applepay', 'bacs', 'bancomatpay', 'bancontact', 'banktransfer', 'belfius', 'billie', 'blik', 'creditcard', 'eps',
    'giftcard', 'ideal', 'in3', 'kbc', 'klarna', 'mbway', 'multibanco', 'mybank', 'paybybank', 'paypal', 'paysafecard',
    'pointofsale', 'przelewy24', 'riverty', 'satispay', 'swish', 'trustly', 'twint', 'voucher'.
    """
    lines: NotRequired[Nullable[List[PaymentLineItemTypedDict]]]
    r"""Optionally provide the order lines for the payment. Each line contains details such as a description of the item
    ordered and its price.

    All lines must have the same currency as the payment.

    Required for payment methods `billie`, `in3`, `klarna`, `riverty` and `voucher`.
    """
    billing_address: NotRequired[PaymentAddressTypedDict]
    shipping_address: NotRequired[PaymentAddressTypedDict]
    testmode: NotRequired[Nullable[bool]]
    r"""Most API credentials are specifically created for either live mode or test mode. For organization-level credentials
    such as OAuth access tokens, you can enable test mode by setting `testmode` to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """


class UpdatePaymentLinkRequestBody(BaseModel):
    description: Optional[str] = None
    r"""A short description of the payment link. The description is visible in the Dashboard and will be shown
    on the customer's bank or card statement when possible.

    Updating the description does not affect any previously existing payments created for this payment link.
    """

    minimum_amount: Annotated[
        Optional[Amount], pydantic.Field(alias="minimumAmount")
    ] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    archived: Optional[bool] = None
    r"""Whether the payment link is archived. Customers will not be able to complete payments on archived
    payment links.
    """

    allowed_methods: Annotated[
        OptionalNullable[List[str]], pydantic.Field(alias="allowedMethods")
    ] = UNSET
    r"""An array of payment methods that are allowed to be used for this payment link. When this parameter is
    not provided or is an empty array, all enabled payment methods will be available.

    Enum: 'applepay', 'bacs', 'bancomatpay', 'bancontact', 'banktransfer', 'belfius', 'billie', 'blik', 'creditcard', 'eps',
    'giftcard', 'ideal', 'in3', 'kbc', 'klarna', 'mbway', 'multibanco', 'mybank', 'paybybank', 'paypal', 'paysafecard',
    'pointofsale', 'przelewy24', 'riverty', 'satispay', 'swish', 'trustly', 'twint', 'voucher'.
    """

    lines: OptionalNullable[List[PaymentLineItem]] = UNSET
    r"""Optionally provide the order lines for the payment. Each line contains details such as a description of the item
    ordered and its price.

    All lines must have the same currency as the payment.

    Required for payment methods `billie`, `in3`, `klarna`, `riverty` and `voucher`.
    """

    billing_address: Annotated[
        Optional[PaymentAddress], pydantic.Field(alias="billingAddress")
    ] = None

    shipping_address: Annotated[
        Optional[PaymentAddress], pydantic.Field(alias="shippingAddress")
    ] = None

    testmode: OptionalNullable[bool] = UNSET
    r"""Most API credentials are specifically created for either live mode or test mode. For organization-level credentials
    such as OAuth access tokens, you can enable test mode by setting `testmode` to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "description",
            "minimumAmount",
            "archived",
            "allowedMethods",
            "lines",
            "billingAddress",
            "shippingAddress",
            "testmode",
        ]
        nullable_fields = ["allowedMethods", "lines", "testmode"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class UpdatePaymentLinkRequestTypedDict(TypedDict):
    payment_link_id: str
    r"""Provide the ID of the related payment link."""
    idempotency_key: NotRequired[str]
    r"""A unique key to ensure idempotent requests. This key should be a UUID v4 string."""
    request_body: NotRequired[UpdatePaymentLinkRequestBodyTypedDict]


class UpdatePaymentLinkRequest(BaseModel):
    payment_link_id: Annotated[
        str,
        pydantic.Field(alias="paymentLinkId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""Provide the ID of the related payment link."""

    idempotency_key: Annotated[
        Optional[str],
        pydantic.Field(alias="idempotency-key"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ] = None
    r"""A unique key to ensure idempotent requests. This key should be a UUID v4 string."""

    request_body: Annotated[
        Optional[UpdatePaymentLinkRequestBody],
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ] = None
