"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .amount import Amount, AmountTypedDict
from .amount_nullable import AmountNullable, AmountNullableTypedDict
from .metadata import Metadata, MetadataTypedDict
from .refund_external_reference_type import RefundExternalReferenceType
from .refund_routing_reversals_source_type import RefundRoutingReversalsSourceType
from .refund_status import RefundStatus
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import validate_open_enum
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import PlainValidator
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class EntityRefundExternalReferenceTypedDict(TypedDict):
    type: NotRequired[RefundExternalReferenceType]
    r"""Specifies the reference type"""
    id: NotRequired[str]
    r"""Unique reference from the payment provider"""


class EntityRefundExternalReference(BaseModel):
    type: Optional[RefundExternalReferenceType] = None
    r"""Specifies the reference type"""

    id: Optional[str] = None
    r"""Unique reference from the payment provider"""


class EntityRefundSourceTypedDict(TypedDict):
    r"""Where the funds will be pulled back from."""

    type: NotRequired[RefundRoutingReversalsSourceType]
    r"""The type of source. Currently only the source type `organization` is supported."""
    organization_id: NotRequired[str]


class EntityRefundSource(BaseModel):
    r"""Where the funds will be pulled back from."""

    type: Optional[RefundRoutingReversalsSourceType] = None
    r"""The type of source. Currently only the source type `organization` is supported."""

    organization_id: Annotated[
        Optional[str], pydantic.Field(alias="organizationId")
    ] = None


class EntityRefundRoutingReversalTypedDict(TypedDict):
    amount: NotRequired[AmountTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    source: NotRequired[EntityRefundSourceTypedDict]
    r"""Where the funds will be pulled back from."""


class EntityRefundRoutingReversal(BaseModel):
    amount: Optional[Amount] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    source: Optional[EntityRefundSource] = None
    r"""Where the funds will be pulled back from."""


class EntityRefundTypedDict(TypedDict):
    id: str
    description: str
    r"""The description of the refund that may be shown to your customer, depending on the payment method used."""
    amount: AmountTypedDict
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    metadata: Nullable[MetadataTypedDict]
    r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever
    you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB.
    """
    status: RefundStatus
    settlement_amount: NotRequired[Nullable[AmountNullableTypedDict]]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    payment_id: NotRequired[str]
    settlement_id: NotRequired[str]
    external_reference: NotRequired[EntityRefundExternalReferenceTypedDict]
    reverse_routing: NotRequired[Nullable[bool]]
    r"""*This feature is only available to marketplace operators.*

    With Mollie Connect you can charge fees on payments that your app is processing on behalf of other Mollie
    merchants, by providing the `routing` object during [payment creation](create-payment).

    When creating refunds for these *routed* payments, by default the full amount is deducted from your balance.

    If you want to pull back the funds that were routed to the connected merchant(s), you can set this parameter to
    `true` when issuing a full refund.

    For more fine-grained control and for partial refunds, use the `routingReversals` parameter instead.
    """
    routing_reversals: NotRequired[Nullable[List[EntityRefundRoutingReversalTypedDict]]]
    r"""*This feature is only available to marketplace operators.*

    When creating refunds for *routed* payments, by default the full amount is deducted from your balance.

    If you want to pull back funds from the connected merchant(s), you can use this parameter to specify what amount
    needs to be reversed from which merchant(s).

    If you simply want to fully reverse the routed funds, you can also use the `reverseRouting` parameter instead.
    """
    testmode: NotRequired[Nullable[bool]]
    r"""Whether to create the entity in test mode or live mode.

    Most API credentials are specifically created for either live mode or test mode, in which case this parameter can be
    omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting
    `testmode` to `true`.
    """


class EntityRefund(BaseModel):
    id: str

    description: str
    r"""The description of the refund that may be shown to your customer, depending on the payment method used."""

    amount: Amount
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    metadata: Nullable[Metadata]
    r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever
    you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB.
    """

    status: Annotated[RefundStatus, PlainValidator(validate_open_enum(False))]

    settlement_amount: Annotated[
        OptionalNullable[AmountNullable], pydantic.Field(alias="settlementAmount")
    ] = UNSET
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    payment_id: Annotated[Optional[str], pydantic.Field(alias="paymentId")] = None

    settlement_id: Annotated[Optional[str], pydantic.Field(alias="settlementId")] = None

    external_reference: Annotated[
        Optional[EntityRefundExternalReference],
        pydantic.Field(alias="externalReference"),
    ] = None

    reverse_routing: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="reverseRouting")
    ] = UNSET
    r"""*This feature is only available to marketplace operators.*

    With Mollie Connect you can charge fees on payments that your app is processing on behalf of other Mollie
    merchants, by providing the `routing` object during [payment creation](create-payment).

    When creating refunds for these *routed* payments, by default the full amount is deducted from your balance.

    If you want to pull back the funds that were routed to the connected merchant(s), you can set this parameter to
    `true` when issuing a full refund.

    For more fine-grained control and for partial refunds, use the `routingReversals` parameter instead.
    """

    routing_reversals: Annotated[
        OptionalNullable[List[EntityRefundRoutingReversal]],
        pydantic.Field(alias="routingReversals"),
    ] = UNSET
    r"""*This feature is only available to marketplace operators.*

    When creating refunds for *routed* payments, by default the full amount is deducted from your balance.

    If you want to pull back funds from the connected merchant(s), you can use this parameter to specify what amount
    needs to be reversed from which merchant(s).

    If you simply want to fully reverse the routed funds, you can also use the `reverseRouting` parameter instead.
    """

    testmode: OptionalNullable[bool] = UNSET
    r"""Whether to create the entity in test mode or live mode.

    Most API credentials are specifically created for either live mode or test mode, in which case this parameter can be
    omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting
    `testmode` to `true`.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "settlementAmount",
            "paymentId",
            "settlementId",
            "externalReference",
            "reverseRouting",
            "routingReversals",
            "testmode",
        ]
        nullable_fields = [
            "settlementAmount",
            "metadata",
            "reverseRouting",
            "routingReversals",
            "testmode",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
