"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .sales_invoice_recipient_locale_response import SalesInvoiceRecipientLocaleResponse
from .sales_invoice_recipient_type_response import SalesInvoiceRecipientTypeResponse
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import validate_open_enum
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import PlainValidator
from typing_extensions import Annotated, NotRequired, TypedDict


class SalesInvoiceRecipientResponseTypedDict(TypedDict):
    type: SalesInvoiceRecipientTypeResponse
    r"""The type of recipient, either `consumer` or `business`. This will determine what further fields are
    required on the `recipient` object.
    """
    email: str
    r"""The email address of the recipient."""
    street_and_number: str
    r"""A street and street number."""
    postal_code: str
    r"""A postal code."""
    city: str
    r"""The recipient's city."""
    country: str
    r"""A country code in [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) format."""
    locale: SalesInvoiceRecipientLocaleResponse
    r"""The locale for the recipient, to be used for translations in PDF generation and payment pages."""
    title: NotRequired[Nullable[str]]
    r"""The title of the `consumer` type recipient, for example Mr. or Mrs.."""
    given_name: NotRequired[Nullable[str]]
    r"""The given name (first name) of the `consumer` type recipient should be at least two characters and cannot contain
    only numbers.
    """
    family_name: NotRequired[Nullable[str]]
    r"""The given name (last name) of the `consumer` type recipient should be at least two characters and cannot contain
    only numbers.
    """
    organization_name: NotRequired[Nullable[str]]
    r"""The trading name of the `business` type recipient."""
    organization_number: NotRequired[Nullable[str]]
    r"""The Chamber of Commerce number of the organization for a `business` type recipient. Either this or `vatNumber`
    has to be provided.
    """
    vat_number: NotRequired[Nullable[str]]
    r"""The VAT number of the organization for a `business` type recipient. Either this or `organizationNumber`
    has to be provided.
    """
    phone: NotRequired[Nullable[str]]
    r"""The phone number of the recipient."""
    street_additional: NotRequired[Nullable[str]]
    r"""Any additional addressing details, for example an apartment number."""
    region: NotRequired[Nullable[str]]
    r"""The recipient's region."""


class SalesInvoiceRecipientResponse(BaseModel):
    type: Annotated[
        SalesInvoiceRecipientTypeResponse, PlainValidator(validate_open_enum(False))
    ]
    r"""The type of recipient, either `consumer` or `business`. This will determine what further fields are
    required on the `recipient` object.
    """

    email: str
    r"""The email address of the recipient."""

    street_and_number: Annotated[str, pydantic.Field(alias="streetAndNumber")]
    r"""A street and street number."""

    postal_code: Annotated[str, pydantic.Field(alias="postalCode")]
    r"""A postal code."""

    city: str
    r"""The recipient's city."""

    country: str
    r"""A country code in [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) format."""

    locale: Annotated[
        SalesInvoiceRecipientLocaleResponse, PlainValidator(validate_open_enum(False))
    ]
    r"""The locale for the recipient, to be used for translations in PDF generation and payment pages."""

    title: OptionalNullable[str] = UNSET
    r"""The title of the `consumer` type recipient, for example Mr. or Mrs.."""

    given_name: Annotated[OptionalNullable[str], pydantic.Field(alias="givenName")] = (
        UNSET
    )
    r"""The given name (first name) of the `consumer` type recipient should be at least two characters and cannot contain
    only numbers.
    """

    family_name: Annotated[
        OptionalNullable[str], pydantic.Field(alias="familyName")
    ] = UNSET
    r"""The given name (last name) of the `consumer` type recipient should be at least two characters and cannot contain
    only numbers.
    """

    organization_name: Annotated[
        OptionalNullable[str], pydantic.Field(alias="organizationName")
    ] = UNSET
    r"""The trading name of the `business` type recipient."""

    organization_number: Annotated[
        OptionalNullable[str], pydantic.Field(alias="organizationNumber")
    ] = UNSET
    r"""The Chamber of Commerce number of the organization for a `business` type recipient. Either this or `vatNumber`
    has to be provided.
    """

    vat_number: Annotated[OptionalNullable[str], pydantic.Field(alias="vatNumber")] = (
        UNSET
    )
    r"""The VAT number of the organization for a `business` type recipient. Either this or `organizationNumber`
    has to be provided.
    """

    phone: OptionalNullable[str] = UNSET
    r"""The phone number of the recipient."""

    street_additional: Annotated[
        OptionalNullable[str], pydantic.Field(alias="streetAdditional")
    ] = UNSET
    r"""Any additional addressing details, for example an apartment number."""

    region: OptionalNullable[str] = UNSET
    r"""The recipient's region."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "title",
            "givenName",
            "familyName",
            "organizationName",
            "organizationNumber",
            "vatNumber",
            "phone",
            "streetAdditional",
            "region",
        ]
        nullable_fields = [
            "title",
            "givenName",
            "familyName",
            "organizationName",
            "organizationNumber",
            "vatNumber",
            "phone",
            "streetAdditional",
            "region",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
