"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .balance_report_grouping import BalanceReportGrouping
from mollie.types import BaseModel
from mollie.utils import (
    FieldMetadata,
    HeaderMetadata,
    PathParamMetadata,
    QueryParamMetadata,
    validate_open_enum,
)
import pydantic
from pydantic.functional_validators import PlainValidator
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class GetBalanceReportGlobalsTypedDict(TypedDict):
    testmode: NotRequired[bool]
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query
    parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by
    setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """


class GetBalanceReportGlobals(BaseModel):
    testmode: Annotated[
        Optional[bool],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query
    parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by
    setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """


class GetBalanceReportRequestTypedDict(TypedDict):
    balance_id: str
    r"""Provide the ID of the related balance."""
    from_: str
    r"""The start date of the report, in `YYYY-MM-DD` format. The from date is
    'inclusive', and in Central European Time. This means a report with for example `from=2024-01-01` will
    include transactions from 2024-01-01 0:00:00 CET and onwards.
    """
    until: str
    r"""The end date of the report, in `YYYY-MM-DD` format. The until date is 'exclusive', and in Central European Time.
    This means a report with for example `until=2024-02-01` will include transactions up until
    2024-01-31 23:59:59 CET.
    """
    grouping: NotRequired[BalanceReportGrouping]
    r"""You can retrieve reports in two different formats. With the `status-balances` format, transactions are grouped
    by status (e.g. `pending`, `available`), then by transaction type, and then by other sub-groupings where
    available (e.g. payment method).

    With the `transaction-categories` format, transactions are grouped by
    transaction type, then by status, and then again by other sub-groupings where available.
    """
    idempotency_key: NotRequired[str]
    r"""A unique key to ensure idempotent requests. This key should be a UUID v4 string."""


class GetBalanceReportRequest(BaseModel):
    balance_id: Annotated[
        str,
        pydantic.Field(alias="balanceId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""Provide the ID of the related balance."""

    from_: Annotated[
        str,
        pydantic.Field(alias="from"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ]
    r"""The start date of the report, in `YYYY-MM-DD` format. The from date is
    'inclusive', and in Central European Time. This means a report with for example `from=2024-01-01` will
    include transactions from 2024-01-01 0:00:00 CET and onwards.
    """

    until: Annotated[
        str, FieldMetadata(query=QueryParamMetadata(style="form", explode=True))
    ]
    r"""The end date of the report, in `YYYY-MM-DD` format. The until date is 'exclusive', and in Central European Time.
    This means a report with for example `until=2024-02-01` will include transactions up until
    2024-01-31 23:59:59 CET.
    """

    grouping: Annotated[
        Annotated[
            Optional[BalanceReportGrouping], PlainValidator(validate_open_enum(False))
        ],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""You can retrieve reports in two different formats. With the `status-balances` format, transactions are grouped
    by status (e.g. `pending`, `available`), then by transaction type, and then by other sub-groupings where
    available (e.g. payment method).

    With the `transaction-categories` format, transactions are grouped by
    transaction type, then by status, and then again by other sub-groupings where available.
    """

    idempotency_key: Annotated[
        Optional[str],
        pydantic.Field(alias="idempotency-key"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ] = None
    r"""A unique key to ensure idempotent requests. This key should be a UUID v4 string."""
