"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .list_links import ListLinks, ListLinksTypedDict
from .subscription_response import SubscriptionResponse, SubscriptionResponseTypedDict
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import FieldMetadata, HeaderMetadata, QueryParamMetadata
import pydantic
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ListAllSubscriptionsGlobalsTypedDict(TypedDict):
    profile_id: NotRequired[str]
    r"""The identifier referring to the [profile](get-profile) you wish to
    retrieve the resources for.

    Most API credentials are linked to a single profile. In these cases the `profileId` can be omitted. For
    organization-level credentials such as OAuth access tokens however, the `profileId` parameter is required.
    """
    testmode: NotRequired[bool]
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query
    parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by
    setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """


class ListAllSubscriptionsGlobals(BaseModel):
    profile_id: Annotated[
        Optional[str],
        pydantic.Field(alias="profileId"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The identifier referring to the [profile](get-profile) you wish to
    retrieve the resources for.

    Most API credentials are linked to a single profile. In these cases the `profileId` can be omitted. For
    organization-level credentials such as OAuth access tokens however, the `profileId` parameter is required.
    """

    testmode: Annotated[
        Optional[bool],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query
    parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by
    setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """


class ListAllSubscriptionsRequestTypedDict(TypedDict):
    from_: NotRequired[Nullable[str]]
    r"""Provide an ID to start the result set from the item with the given ID and onwards. This allows you to paginate the
    result set.
    """
    limit: NotRequired[Nullable[int]]
    r"""The maximum number of items to return. Defaults to 50 items."""
    idempotency_key: NotRequired[str]
    r"""A unique key to ensure idempotent requests. This key should be a UUID v4 string."""


class ListAllSubscriptionsRequest(BaseModel):
    from_: Annotated[
        OptionalNullable[str],
        pydantic.Field(alias="from"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Provide an ID to start the result set from the item with the given ID and onwards. This allows you to paginate the
    result set.
    """

    limit: Annotated[
        OptionalNullable[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""The maximum number of items to return. Defaults to 50 items."""

    idempotency_key: Annotated[
        Optional[str],
        pydantic.Field(alias="idempotency-key"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ] = None
    r"""A unique key to ensure idempotent requests. This key should be a UUID v4 string."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["from", "limit", "idempotency-key"]
        nullable_fields = ["from", "limit"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListAllSubscriptionsEmbeddedTypedDict(TypedDict):
    subscriptions: NotRequired[List[SubscriptionResponseTypedDict]]
    r"""A list of subscription objects."""


class ListAllSubscriptionsEmbedded(BaseModel):
    subscriptions: Optional[List[SubscriptionResponse]] = None
    r"""A list of subscription objects."""


class ListAllSubscriptionsResponseTypedDict(TypedDict):
    r"""A list of subscription objects."""

    count: int
    r"""The number of items in this result set. If more items are available, a `_links.next` URL will be present in the result
    as well.

    The maximum number of items per result set is controlled by the `limit` property provided in the request. The default
    limit is 50 items.
    """
    embedded: ListAllSubscriptionsEmbeddedTypedDict
    links: ListLinksTypedDict
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""


class ListAllSubscriptionsResponse(BaseModel):
    r"""A list of subscription objects."""

    count: int
    r"""The number of items in this result set. If more items are available, a `_links.next` URL will be present in the result
    as well.

    The maximum number of items per result set is controlled by the `limit` property provided in the request. The default
    limit is 50 items.
    """

    embedded: Annotated[ListAllSubscriptionsEmbedded, pydantic.Field(alias="_embedded")]

    links: Annotated[ListLinks, pydantic.Field(alias="_links")]
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""
