"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from .basesdk import BaseSDK
from mollie import models, utils
from mollie._hooks import HookContext
from mollie.types import OptionalNullable, UNSET
from mollie.utils import get_security_from_env
from mollie.utils.unmarshal_json_response import unmarshal_json_response
from typing import Any, Mapping, Optional, Union


class ClientLinks(BaseSDK):
    def create(
        self,
        *,
        idempotency_key: Optional[str] = None,
        entity_client_link: Optional[
            Union[models.EntityClientLink, models.EntityClientLinkTypedDict]
        ] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.ClientLinkResponse:
        r"""Create client link

        Link a new or existing organization to your OAuth application, in effect creating a new client. The response
        contains a `clientLink` where you should redirect your customer to.

        ## Redirecting the Customer

        The `clientLink` URL behaves similarly to a standard OAuth authorization URL. Therefore, after receiving the
        `clientLink` URL in the API response, you need to **append the following query parameters** *before* redirecting
        the customer:

        * `client_id` _string (required)_

        The client ID you received when you registered your OAuth app. The ID starts with `app_`. For example:
        `app_abc123qwerty`.

        * `state` _string (required)_

        A random string **generated by your app** to prevent CSRF attacks. This will be reflected in the `state` query
        parameter when the user returns to the `redirect_uri` after authorizing your app.

        * `scope` _string (required)_

        A space-separated list of permissions ('scopes') your app requires. See the
        [permissions list](https://docs.mollie.com/docs/connect-permissions) for more information about the available
        scopes.

        We recommend at least : `onboarding.read onboarding.write`

        * `approval_prompt` _string_

        Can be set to `force` to force showing the consent screen to the merchant, *even when it is not necessary*. If you
        force an approval prompt and the user creates a new authorization, previously active authorizations will be
        revoked.

        Possible values: `auto` `force` (default: `auto`)

        ### Example of a Complete Redirect URL

        After adding the above url parameter your URL will look something like this and you can redirect your client to this
        page:

        ```
        https://my.mollie.com/dashboard/client-link/{id}?client_id={your_client_id}&state={unique_state}&scope=onboarding.read%20onboarding.write
        ```

        ## Error Handling

        Error handling is also dealt with similar to the [Authorize](https://docs.mollie.com/reference/authorize) endpoint:
        the customer is redirected back to your app's redirect URL with the `error` and `error_description` parameters added
        to the URL.

        > 🚧
        >
        > A client link must be used within 30 days of creation. After that period, it will expire and you will need to create a new client link.

        :param idempotency_key: A unique key to ensure idempotent requests. This key should be a UUID v4 string.
        :param entity_client_link:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.CreateClientLinkRequest(
            idempotency_key=idempotency_key,
            entity_client_link=utils.get_pydantic_model(
                entity_client_link, Optional[models.EntityClientLink]
            ),
        )

        req = self._build_request(
            method="POST",
            path="/client-links",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/hal+json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.entity_client_link,
                False,
                True,
                "json",
                Optional[models.EntityClientLink],
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(500, 60000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["5xx"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="create-client-link",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "201", "application/hal+json"):
            return unmarshal_json_response(models.ClientLinkResponse, http_res)
        if utils.match_response(http_res, ["404", "422"], "application/hal+json"):
            response_data = unmarshal_json_response(models.ErrorResponseData, http_res)
            raise models.ErrorResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.APIError("API error occurred", http_res, http_res_text)

        raise models.APIError("Unexpected response received", http_res)

    async def create_async(
        self,
        *,
        idempotency_key: Optional[str] = None,
        entity_client_link: Optional[
            Union[models.EntityClientLink, models.EntityClientLinkTypedDict]
        ] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.ClientLinkResponse:
        r"""Create client link

        Link a new or existing organization to your OAuth application, in effect creating a new client. The response
        contains a `clientLink` where you should redirect your customer to.

        ## Redirecting the Customer

        The `clientLink` URL behaves similarly to a standard OAuth authorization URL. Therefore, after receiving the
        `clientLink` URL in the API response, you need to **append the following query parameters** *before* redirecting
        the customer:

        * `client_id` _string (required)_

        The client ID you received when you registered your OAuth app. The ID starts with `app_`. For example:
        `app_abc123qwerty`.

        * `state` _string (required)_

        A random string **generated by your app** to prevent CSRF attacks. This will be reflected in the `state` query
        parameter when the user returns to the `redirect_uri` after authorizing your app.

        * `scope` _string (required)_

        A space-separated list of permissions ('scopes') your app requires. See the
        [permissions list](https://docs.mollie.com/docs/connect-permissions) for more information about the available
        scopes.

        We recommend at least : `onboarding.read onboarding.write`

        * `approval_prompt` _string_

        Can be set to `force` to force showing the consent screen to the merchant, *even when it is not necessary*. If you
        force an approval prompt and the user creates a new authorization, previously active authorizations will be
        revoked.

        Possible values: `auto` `force` (default: `auto`)

        ### Example of a Complete Redirect URL

        After adding the above url parameter your URL will look something like this and you can redirect your client to this
        page:

        ```
        https://my.mollie.com/dashboard/client-link/{id}?client_id={your_client_id}&state={unique_state}&scope=onboarding.read%20onboarding.write
        ```

        ## Error Handling

        Error handling is also dealt with similar to the [Authorize](https://docs.mollie.com/reference/authorize) endpoint:
        the customer is redirected back to your app's redirect URL with the `error` and `error_description` parameters added
        to the URL.

        > 🚧
        >
        > A client link must be used within 30 days of creation. After that period, it will expire and you will need to create a new client link.

        :param idempotency_key: A unique key to ensure idempotent requests. This key should be a UUID v4 string.
        :param entity_client_link:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.CreateClientLinkRequest(
            idempotency_key=idempotency_key,
            entity_client_link=utils.get_pydantic_model(
                entity_client_link, Optional[models.EntityClientLink]
            ),
        )

        req = self._build_request_async(
            method="POST",
            path="/client-links",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/hal+json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.entity_client_link,
                False,
                True,
                "json",
                Optional[models.EntityClientLink],
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(500, 60000, 1.5, 3600000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["5xx"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="create-client-link",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "201", "application/hal+json"):
            return unmarshal_json_response(models.ClientLinkResponse, http_res)
        if utils.match_response(http_res, ["404", "422"], "application/hal+json"):
            response_data = unmarshal_json_response(models.ErrorResponseData, http_res)
            raise models.ErrorResponse(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.APIError("API error occurred", http_res, http_res_text)

        raise models.APIError("Unexpected response received", http_res)
