"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .amount import Amount, AmountTypedDict
from .balance_transfer_category_response import BalanceTransferCategoryResponse
from .balance_transfer_status import BalanceTransferStatus
from .balance_transfer_status_reason_response import BalanceTransferStatusReasonResponse
from .entity_balance_transfer_party_response import (
    EntityBalanceTransferPartyResponse,
    EntityBalanceTransferPartyResponseTypedDict,
)
from .mode import Mode
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import validate_open_enum
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import PlainValidator
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class EntityBalanceTransferResponseStatusReasonTypedDict(TypedDict):
    r"""The reason for the current status of the transfer, if applicable."""

    code: BalanceTransferStatusReasonResponse
    r"""A machine-readable code that indicates the reason for the transfer's status."""
    message: str
    r"""A description of the status reason, localized according to the transfer."""


class EntityBalanceTransferResponseStatusReason(BaseModel):
    r"""The reason for the current status of the transfer, if applicable."""

    code: Annotated[
        BalanceTransferStatusReasonResponse, PlainValidator(validate_open_enum(False))
    ]
    r"""A machine-readable code that indicates the reason for the transfer's status."""

    message: str
    r"""A description of the status reason, localized according to the transfer."""


class EntityBalanceTransferResponseTypedDict(TypedDict):
    resource: str
    r"""Indicates the response contains a balance transfer object. Will always contain the string `connect-balance-transfer` for this endpoint."""
    id: str
    amount: AmountTypedDict
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    source: EntityBalanceTransferPartyResponseTypedDict
    r"""A party involved in the balance transfer, either the sender or the receiver."""
    destination: EntityBalanceTransferPartyResponseTypedDict
    r"""A party involved in the balance transfer, either the sender or the receiver."""
    description: str
    r"""The transfer description for initiating party."""
    status: BalanceTransferStatus
    r"""The status of the transfer."""
    status_reason: EntityBalanceTransferResponseStatusReasonTypedDict
    r"""The reason for the current status of the transfer, if applicable."""
    created_at: str
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""
    mode: Mode
    r"""Whether this entity was created in live mode or in test mode."""
    category: NotRequired[BalanceTransferCategoryResponse]
    r"""The type of the transfer. Different fees may apply to different types of transfers."""
    executed_at: NotRequired[Nullable[str]]
    r"""The date and time when the transfer was completed, in ISO 8601 format. This parameter is omitted if the transfer is
    not executed (yet).
    """


class EntityBalanceTransferResponse(BaseModel):
    resource: str
    r"""Indicates the response contains a balance transfer object. Will always contain the string `connect-balance-transfer` for this endpoint."""

    id: str

    amount: Amount
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    source: EntityBalanceTransferPartyResponse
    r"""A party involved in the balance transfer, either the sender or the receiver."""

    destination: EntityBalanceTransferPartyResponse
    r"""A party involved in the balance transfer, either the sender or the receiver."""

    description: str
    r"""The transfer description for initiating party."""

    status: Annotated[BalanceTransferStatus, PlainValidator(validate_open_enum(False))]
    r"""The status of the transfer."""

    status_reason: Annotated[
        EntityBalanceTransferResponseStatusReason, pydantic.Field(alias="statusReason")
    ]
    r"""The reason for the current status of the transfer, if applicable."""

    created_at: Annotated[str, pydantic.Field(alias="createdAt")]
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""

    mode: Annotated[Mode, PlainValidator(validate_open_enum(False))]
    r"""Whether this entity was created in live mode or in test mode."""

    category: Annotated[
        Optional[BalanceTransferCategoryResponse],
        PlainValidator(validate_open_enum(False)),
    ] = None
    r"""The type of the transfer. Different fees may apply to different types of transfers."""

    executed_at: Annotated[
        OptionalNullable[str], pydantic.Field(alias="executedAt")
    ] = UNSET
    r"""The date and time when the transfer was completed, in ISO 8601 format. This parameter is omitted if the transfer is
    not executed (yet).
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["category", "executedAt"]
        nullable_fields = ["executedAt"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
