"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .entity_capability import EntityCapability, EntityCapabilityTypedDict
from .entity_onboarding_status import (
    EntityOnboardingStatus,
    EntityOnboardingStatusTypedDict,
)
from .entity_organization import EntityOrganization, EntityOrganizationTypedDict
from .url import URL, URLTypedDict
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import (
    FieldMetadata,
    HeaderMetadata,
    PathParamMetadata,
    QueryParamMetadata,
)
import pydantic
from pydantic import model_serializer
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class GetClientRequestTypedDict(TypedDict):
    id: str
    r"""Provide the ID of the item you want to perform this operation on."""
    embed: NotRequired[Nullable[str]]
    r"""This endpoint allows embedding related API items by appending the following values via the `embed` query string
    parameter.
    """
    idempotency_key: NotRequired[str]
    r"""A unique key to ensure idempotent requests. This key should be a UUID v4 string."""


class GetClientRequest(BaseModel):
    id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""Provide the ID of the item you want to perform this operation on."""

    embed: Annotated[
        OptionalNullable[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""This endpoint allows embedding related API items by appending the following values via the `embed` query string
    parameter.
    """

    idempotency_key: Annotated[
        Optional[str],
        pydantic.Field(alias="idempotency-key"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ] = None
    r"""A unique key to ensure idempotent requests. This key should be a UUID v4 string."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["embed", "idempotency-key"]
        nullable_fields = ["embed"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetClientCommissionTypedDict(TypedDict):
    r"""The commission object."""

    count: NotRequired[int]
    r"""The commission count."""


class GetClientCommission(BaseModel):
    r"""The commission object."""

    count: Optional[int] = None
    r"""The commission count."""


class GetClientLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: URLTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    organization: NotRequired[URLTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    onboarding: NotRequired[URLTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    documentation: NotRequired[URLTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class GetClientLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[URL, pydantic.Field(alias="self")]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    organization: Optional[URL] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    onboarding: Optional[URL] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    documentation: Optional[URL] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class GetClientEmbeddedTypedDict(TypedDict):
    organization: NotRequired[EntityOrganizationTypedDict]
    onboarding: NotRequired[EntityOnboardingStatusTypedDict]
    capabilities: NotRequired[EntityCapabilityTypedDict]


class GetClientEmbedded(BaseModel):
    organization: Optional[EntityOrganization] = None

    onboarding: Optional[EntityOnboardingStatus] = None

    capabilities: Optional[EntityCapability] = None


class GetClientResponseTypedDict(TypedDict):
    r"""The client object."""

    resource: str
    r"""Indicates the response contains a client object. Will always contain the string `client` for this resource type."""
    id: str
    links: GetClientLinksTypedDict
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""
    commission: NotRequired[Nullable[GetClientCommissionTypedDict]]
    r"""The commission object."""
    organization_created_at: NotRequired[str]
    r"""The date and time the client organization was created, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601)
    format.
    """
    embedded: NotRequired[GetClientEmbeddedTypedDict]


class GetClientResponse(BaseModel):
    r"""The client object."""

    resource: str
    r"""Indicates the response contains a client object. Will always contain the string `client` for this resource type."""

    id: str

    links: Annotated[GetClientLinks, pydantic.Field(alias="_links")]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    commission: OptionalNullable[GetClientCommission] = UNSET
    r"""The commission object."""

    organization_created_at: Annotated[
        Optional[str], pydantic.Field(alias="organizationCreatedAt")
    ] = None
    r"""The date and time the client organization was created, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601)
    format.
    """

    embedded: Annotated[
        Optional[GetClientEmbedded], pydantic.Field(alias="_embedded")
    ] = None

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["commission", "organizationCreatedAt", "_embedded"]
        nullable_fields = ["commission"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
