"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .balance_card_audience import BalanceCardAudience
from .balance_card_issuer import BalanceCardIssuer
from .balance_card_region import BalanceCardRegion
from .balance_fee_type import BalanceFeeType
from .balance_prepayment_part_type import BalancePrepaymentPartType
from .balance_transaction_type import BalanceTransactionType
from .payment_method import PaymentMethod
from .sub_totals import SubTotals, SubTotalsTypedDict
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import validate_open_enum
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import PlainValidator
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ComponentsSubTotalsTypedDict(TypedDict):
    sub_totals: NotRequired[Nullable[List[SubTotalsTypedDict]]]
    count: NotRequired[int]
    r"""Number of transactions of this type"""
    method: NotRequired[Nullable[PaymentMethod]]
    r"""The payment method, if applicable"""
    card_issuer: NotRequired[BalanceCardIssuer]
    card_audience: NotRequired[BalanceCardAudience]
    card_region: NotRequired[BalanceCardRegion]
    fee_type: NotRequired[BalanceFeeType]
    prepayment_part_type: NotRequired[BalancePrepaymentPartType]
    transaction_type: NotRequired[BalanceTransactionType]


class ComponentsSubTotals(BaseModel):
    sub_totals: Annotated[
        OptionalNullable[List[SubTotals]], pydantic.Field(alias="sub-totals")
    ] = UNSET

    count: Optional[int] = None
    r"""Number of transactions of this type"""

    method: Annotated[
        OptionalNullable[PaymentMethod], PlainValidator(validate_open_enum(False))
    ] = UNSET
    r"""The payment method, if applicable"""

    card_issuer: Annotated[
        Annotated[
            Optional[BalanceCardIssuer], PlainValidator(validate_open_enum(False))
        ],
        pydantic.Field(alias="cardIssuer"),
    ] = None

    card_audience: Annotated[
        Annotated[
            Optional[BalanceCardAudience], PlainValidator(validate_open_enum(False))
        ],
        pydantic.Field(alias="cardAudience"),
    ] = None

    card_region: Annotated[
        Annotated[
            Optional[BalanceCardRegion], PlainValidator(validate_open_enum(False))
        ],
        pydantic.Field(alias="cardRegion"),
    ] = None

    fee_type: Annotated[
        Annotated[Optional[BalanceFeeType], PlainValidator(validate_open_enum(False))],
        pydantic.Field(alias="feeType"),
    ] = None

    prepayment_part_type: Annotated[
        Annotated[
            Optional[BalancePrepaymentPartType],
            PlainValidator(validate_open_enum(False)),
        ],
        pydantic.Field(alias="prepaymentPartType"),
    ] = None

    transaction_type: Annotated[
        Annotated[
            Optional[BalanceTransactionType], PlainValidator(validate_open_enum(False))
        ],
        pydantic.Field(alias="transactionType"),
    ] = None

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "sub-totals",
            "count",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        nullable_fields = ["sub-totals", "method"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
