"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .sales_invoice_discount import SalesInvoiceDiscount, SalesInvoiceDiscountTypedDict
from .sales_invoice_email_details import (
    SalesInvoiceEmailDetails,
    SalesInvoiceEmailDetailsTypedDict,
)
from .sales_invoice_line_item import SalesInvoiceLineItem, SalesInvoiceLineItemTypedDict
from .sales_invoice_payment_details import (
    SalesInvoicePaymentDetails,
    SalesInvoicePaymentDetailsTypedDict,
)
from .sales_invoice_payment_term import SalesInvoicePaymentTerm
from .sales_invoice_recipient import (
    SalesInvoiceRecipient,
    SalesInvoiceRecipientTypedDict,
)
from .sales_invoice_status import SalesInvoiceStatus
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
import pydantic
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class UpdateValuesSalesInvoiceTypedDict(TypedDict):
    testmode: NotRequired[Nullable[bool]]
    r"""Most API credentials are specifically created for either live mode or test mode. For organization-level credentials
    such as OAuth access tokens, you can enable test mode by setting `testmode` to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """
    status: NotRequired[SalesInvoiceStatus]
    r"""The status for the invoice to end up in.

    A `draft` invoice is not paid or not sent and can be updated after creation. Setting it to `issued` sends it to
    the recipient so they may then pay through our payment system. To skip our payment process, set this to `paid` to
    mark it as paid. It can then subsequently be sent as well, same as with `issued`.

    A status value that cannot be set but can be returned is `canceled`, for invoices which were
    issued, but then canceled. Currently this can only be done for invoices created in the dashboard.

    Dependent parameters:
    - `paymentDetails` is required if invoice should be set directly to `paid`
    - `customerId` and `mandateId` are required if a recurring payment should be used to set the invoice to `paid`
    - `emailDetails` optional for `issued` and `paid` to send the invoice by email
    """
    memo: NotRequired[Nullable[str]]
    r"""A free-form memo you can set on the invoice, and will be shown on the invoice PDF."""
    payment_term: NotRequired[Nullable[SalesInvoicePaymentTerm]]
    r"""The payment term to be set on the invoice."""
    payment_details: NotRequired[SalesInvoicePaymentDetailsTypedDict]
    email_details: NotRequired[Nullable[SalesInvoiceEmailDetailsTypedDict]]
    recipient_identifier: NotRequired[str]
    r"""An identifier tied to the recipient data. This should be a unique value based on data your system contains,
    so that both you and us know who we're referring to. It is a value you provide to us so that recipient management
    is not required to send a first invoice to a recipient.
    """
    recipient: NotRequired[Nullable[SalesInvoiceRecipientTypedDict]]
    lines: NotRequired[Nullable[List[SalesInvoiceLineItemTypedDict]]]
    r"""Provide the line items for the invoice. Each line contains details such as a description of the item
    ordered and its price.

    All lines must have the same currency as the invoice.
    """
    discount: NotRequired[Nullable[SalesInvoiceDiscountTypedDict]]


class UpdateValuesSalesInvoice(BaseModel):
    testmode: OptionalNullable[bool] = UNSET
    r"""Most API credentials are specifically created for either live mode or test mode. For organization-level credentials
    such as OAuth access tokens, you can enable test mode by setting `testmode` to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """

    status: Optional[SalesInvoiceStatus] = None
    r"""The status for the invoice to end up in.

    A `draft` invoice is not paid or not sent and can be updated after creation. Setting it to `issued` sends it to
    the recipient so they may then pay through our payment system. To skip our payment process, set this to `paid` to
    mark it as paid. It can then subsequently be sent as well, same as with `issued`.

    A status value that cannot be set but can be returned is `canceled`, for invoices which were
    issued, but then canceled. Currently this can only be done for invoices created in the dashboard.

    Dependent parameters:
    - `paymentDetails` is required if invoice should be set directly to `paid`
    - `customerId` and `mandateId` are required if a recurring payment should be used to set the invoice to `paid`
    - `emailDetails` optional for `issued` and `paid` to send the invoice by email
    """

    memo: OptionalNullable[str] = UNSET
    r"""A free-form memo you can set on the invoice, and will be shown on the invoice PDF."""

    payment_term: Annotated[
        OptionalNullable[SalesInvoicePaymentTerm], pydantic.Field(alias="paymentTerm")
    ] = UNSET
    r"""The payment term to be set on the invoice."""

    payment_details: Annotated[
        Optional[SalesInvoicePaymentDetails], pydantic.Field(alias="paymentDetails")
    ] = None

    email_details: Annotated[
        OptionalNullable[SalesInvoiceEmailDetails], pydantic.Field(alias="emailDetails")
    ] = UNSET

    recipient_identifier: Annotated[
        Optional[str], pydantic.Field(alias="recipientIdentifier")
    ] = None
    r"""An identifier tied to the recipient data. This should be a unique value based on data your system contains,
    so that both you and us know who we're referring to. It is a value you provide to us so that recipient management
    is not required to send a first invoice to a recipient.
    """

    recipient: OptionalNullable[SalesInvoiceRecipient] = UNSET

    lines: OptionalNullable[List[SalesInvoiceLineItem]] = UNSET
    r"""Provide the line items for the invoice. Each line contains details such as a description of the item
    ordered and its price.

    All lines must have the same currency as the invoice.
    """

    discount: OptionalNullable[SalesInvoiceDiscount] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "testmode",
            "status",
            "memo",
            "paymentTerm",
            "paymentDetails",
            "emailDetails",
            "recipientIdentifier",
            "recipient",
            "lines",
            "discount",
        ]
        nullable_fields = [
            "testmode",
            "memo",
            "paymentTerm",
            "emailDetails",
            "recipient",
            "lines",
            "discount",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
