"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .amount import Amount, AmountTypedDict
from .sales_invoice_discount import SalesInvoiceDiscount, SalesInvoiceDiscountTypedDict
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
import pydantic
from pydantic import model_serializer
from typing_extensions import Annotated, NotRequired, TypedDict


class SalesInvoiceLineItemTypedDict(TypedDict):
    description: str
    r"""A description of the line item. For example *LEGO 4440 Forest Police Station*."""
    quantity: int
    r"""The number of items."""
    vat_rate: str
    r"""The vat rate to be applied to this line item."""
    unit_price: AmountTypedDict
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    discount: NotRequired[Nullable[SalesInvoiceDiscountTypedDict]]


class SalesInvoiceLineItem(BaseModel):
    description: str
    r"""A description of the line item. For example *LEGO 4440 Forest Police Station*."""

    quantity: int
    r"""The number of items."""

    vat_rate: Annotated[str, pydantic.Field(alias="vatRate")]
    r"""The vat rate to be applied to this line item."""

    unit_price: Annotated[Amount, pydantic.Field(alias="unitPrice")]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    discount: OptionalNullable[SalesInvoiceDiscount] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["discount"]
        nullable_fields = ["discount"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
